Joskin_Silospace = {};

function Joskin_Silospace.prerequisitesPresent(specializations)
    return true;
end;

function Joskin_Silospace:load(xmlFile)
	self.isHakenliftObject = true;
	
	local hydraulicsCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.hydraulics#count"), 0);	
	self.hydraulics = {};	
	for i=1, hydraulicsCount do
		local hydraulicName = string.format("vehicle.hydraulics.hydraulic%d", i);		
		self.hydraulics[i] = {};		
		self.hydraulics[i].node = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#index"));
		self.hydraulics[i].punch = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#punch"));
		self.hydraulics[i].translationPunch = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#punchFixpoint"));
		self.hydraulics[i].fixPoint = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#fixpoint"));
		if self.hydraulics[i].punch ~= nil and self.hydraulics[i].translationPunch ~= nil then
			local ax, ay, az = getWorldTranslation(self.hydraulics[i].punch);
			local bx, by, bz = getWorldTranslation(self.hydraulics[i].translationPunch);		
			self.hydraulics[i].punchDistance = Utils.vector3Length(ax-bx, ay-by, az-bz);
		end;
	end;

	self.fillNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fillNode#index"));
	
end;

function Joskin_Silospace:delete()
end;

function Joskin_Silospace:readStream(streamId, connection)	
end;

function Joskin_Silospace:writeStream(streamId, connection)
end;

function Joskin_Silospace:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Joskin_Silospace:keyEvent(unicode, sym, modifier, isDown)
end;

function Joskin_Silospace:update(dt)
	if self.attacherVehicle ~= nil and self.attacherVehicle.isHakenliftTrailer then
		self.tipReferencePoint = self.attacherVehicle.tipReferencePoint;
	end;
	if self.attacherVehicle ~= nil and self.attacherVehicle:getIsActiveForInput() and self.attacherVehicle.isHakenliftTrailer and self.attacherVehicle.selectedImplement == 0 then
		if self.isClient then
            if self.currentFillType ~= Fillable.FILLTYPE_UNKNOWN then
                local fruitType = FruitUtil.fillTypeToFruitType[self.currentFillType];
                if fruitType ~= nil then
					g_currentMission:setFruitOverlayFruitType(fruitType);
				end;
            end;
        end;
	end;
end;

function Joskin_Silospace:updateTick(dt)

	for i=1, table.getn(self.hydraulics) do
		local ax, ay, az = getWorldTranslation(self.hydraulics[i].node);
		local bx, by, bz = getWorldTranslation(self.hydraulics[i].fixPoint);
		if bx ~= nil and by ~= nil and bz ~= nil then
			local x, y, z = worldDirectionToLocal(getParent(self.hydraulics[i].node), bx-ax, by-ay, bz-az);
			setDirection(self.hydraulics[i].node, x, y, z, 0, 0, 1);
			local distance = Utils.vector3Length(ax-bx, ay-by, az-bz);
			if self.hydraulics[i].punch ~= nil and self.hydraulics[i].punchDistance ~= nil and self.hydraulics[i].translationPunch then
				if self.hydraulics[i].doScale then
					local xScale, yScale, zScale = getScale(self.hydraulics[i].punch);
					local newScale = xScale * (distance / self.hydraulics[i].punchDistance);
					setScale(self.hydraulics[i].punch, 1, 1, newScale);
				else
					setTranslation(self.hydraulics[i].punch, 0, 0, distance-self.hydraulics[i].punchDistance);
				end;
			end;
		end;
	end;

end;

function Joskin_Silospace:draw()	
end;

function Joskin_Silospace:onAttach(attacherVehicle)
end;

function Joskin_Silospace:onDetach()
	self.tipReferencePoint = nil;
end;