SetWrapperStateEvent = {};
SetWrapperStateEvent_mt = Class(SetWrapperStateEvent, Event);
InitEventClass(SetWrapperStateEvent, "SetWrapperStateEvent");

function SetWrapperStateEvent:emptyNew()
    local self = Event:new(SetWrapperStateEvent_mt);
    self.className = "SetWrapperStateEvent";
    return self;
end;

function SetWrapperStateEvent:new(vehicle, state)
    local self = SetWrapperStateEvent:emptyNew();
	self.vehicle = vehicle;
	self.state = state;
    return self;
end;

function SetWrapperStateEvent:writeStream(streamId, connection)
	streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteInt8(streamId, self.state);
end;

function SetWrapperStateEvent:readStream(streamId, connection)
	self.vehicle = networkGetObject(streamReadInt32(streamId));
	self.state = streamReadInt8(streamId);
	self:run(connection);
end;

function SetWrapperStateEvent:run(connection)
	self.vehicle:setWrapperState(self.state, true);
	if not connection:getIsServer() then
		g_server:broadcastEvent(SetWrapperStateEvent:new(self.vehicle, self.state), nil, connection, self.vehicle);
	end;
end;

function SetWrapperStateEvent.sendEvent(vehicle, state, noEventSend)
	if not noEventSend then
		if g_server ~= nil then
			g_server:broadcastEvent(SetWrapperStateEvent:new(vehicle, state), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(SetWrapperStateEvent:new(vehicle, state));
		end;
	end;
end;