SetWrapperActiveEvent = {};
SetWrapperActiveEvent_mt = Class(SetWrapperActiveEvent, Event);
InitEventClass(SetWrapperActiveEvent, "SetWrapperActiveEvent");

function SetWrapperActiveEvent:emptyNew()
    local self = Event:new(SetWrapperActiveEvent_mt);
    self.className = "SetWrapperActiveEvent";
    return self;
end;

function SetWrapperActiveEvent:new(vehicle, isActive)
    local self = SetWrapperActiveEvent:emptyNew();
	self.vehicle = vehicle;
	self.isActive = isActive;
    return self;
end;

function SetWrapperActiveEvent:writeStream(streamId, connection)
	streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteBool(streamId, self.isActive);
end;

function SetWrapperActiveEvent:readStream(streamId, connection)
	self.vehicle = networkGetObject(streamReadInt32(streamId));
	self.isActive = streamReadBool(streamId);
	self:run(connection);
end;

function SetWrapperActiveEvent:run(connection)
	self.vehicle:setWrapperActive(self.isActive, true);
	if not connection:getIsServer() then
		g_server:broadcastEvent(SetWrapperActiveEvent:new(self.vehicle, self.isActive), nil, connection, self.vehicle);
	end;
end;

function SetWrapperActiveEvent.sendEvent(vehicle, isActive, noEventSend)
	if not noEventSend then
		if g_server ~= nil then
			g_server:broadcastEvent(SetWrapperActiveEvent:new(vehicle, isActive), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(SetWrapperActiveEvent:new(vehicle, isActive));
		end;
	end;
end;