SetBalerCountEvent = {};
SetBalerCountEvent_mt = Class(SetBalerCountEvent, Event);
InitEventClass(SetBalerCountEvent, "SetBalerCountEvent");

function SetBalerCountEvent:emptyNew()
    local self = Event:new(SetBalerCountEvent_mt);
    self.className = "SetBalerCountEvent";
    return self;
end;

function SetBalerCountEvent:new(vehicle, day, lifeTime)
    local self = SetBalerCountEvent:emptyNew();
	self.vehicle = vehicle;
	self.day = day;
	self.lifeTime = lifeTime;
    return self;
end;

function SetBalerCountEvent:writeStream(streamId, connection)
	streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteInt8(streamId, self.day);
	streamWriteInt8(streamId, self.lifeTime);
end;

function SetBalerCountEvent:readStream(streamId, connection)
	self.vehicle = networkGetObject(streamReadInt32(streamId));
	self.day = streamReadInt8(streamId);
	self.lifeTime = streamReadInt8(streamId);
	self:run(connection);
end;

function SetBalerCountEvent:run(connection)
	self.vehicle:setBaleCounter(self.day, self.lifeTime, true);
	if not connection:getIsServer() then
		g_server:broadcastEvent(SetBalerCountEvent:new(self.vehicle, self.day, self.lifeTime), nil, connection, self.vehicle);
	end;
end;

function SetBalerCountEvent.sendEvent(vehicle, day, lifeTime, noEventSend)
	if not noEventSend then
		if g_server ~= nil then
			g_server:broadcastEvent(SetBalerCountEvent:new(vehicle, day, lifeTime), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(SetBalerCountEvent:new(vehicle, day, lifeTime));
		end;
	end;
end;