SetBaleSizeEvent = {};
SetBaleSizeEvent_mt = Class(SetBaleSizeEvent, Event);
InitEventClass(SetBaleSizeEvent, "SetBaleSizeEvent");

function SetBaleSizeEvent:emptyNew()
    local self = Event:new(SetBaleSizeEvent_mt);
    self.className = "SetBaleSizeEvent";
    return self;
end;

function SetBaleSizeEvent:new(vehicle, sizeIndex)
    local self = SetBaleSizeEvent:emptyNew();
	self.vehicle = vehicle;
	self.sizeIndex = sizeIndex;
    return self;
end;

function SetBaleSizeEvent:writeStream(streamId, connection)
	streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteInt8(streamId, self.sizeIndex);
end;

function SetBaleSizeEvent:readStream(streamId, connection)
	self.vehicle = networkGetObject(streamReadInt32(streamId));
	self.sizeIndex = streamReadInt8(streamId);
	self:run(connection);
end;

function SetBaleSizeEvent:run(connection)
	self.vehicle:setBaleSize(self.sizeIndex, true);
	if not connection:getIsServer() then
		g_server:broadcastEvent(SetBaleSizeEvent:new(self.vehicle, self.sizeIndex), nil, connection, self.vehicle);
	end;
end;

function SetBaleSizeEvent.sendEvent(vehicle, sizeIndex, noEventSend)
	if not noEventSend then
		if g_server ~= nil then
			g_server:broadcastEvent(SetBaleSizeEvent:new(vehicle, sizeIndex), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(SetBaleSizeEvent:new(vehicle, sizeIndex));
		end;
	end;
end;