FoilStorageSetRoleEvent = {};
FoilStorageSetRoleEvent_mt = Class(FoilStorageSetRoleEvent, Event);
InitEventClass(FoilStorageSetRoleEvent, "FoilStorageSetRoleEvent");

function FoilStorageSetRoleEvent:emptyNew()
    local self = Event:new(FoilStorageSetRoleEvent_mt);
    self.className = "FoilStorageSetRoleEvent";
    return self;
end;

function FoilStorageSetRoleEvent:new(vehicle, storageIndex, holderIndex, visibility)
    local self = FoilStorageSetRoleEvent:emptyNew();
	self.vehicle = vehicle;
	self.storageIndex = storageIndex;
	self.holderIndex = holderIndex;
	self.visibility = visibility;
    return self;
end;

function FoilStorageSetRoleEvent:writeStream(streamId, connection)
	streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteInt8(streamId, self.storageIndex);
	streamWriteInt8(streamId, self.holderIndex);
	streamWriteBool(streamId, self.visibility);
end;

function FoilStorageSetRoleEvent:readStream(streamId, connection)
	self.vehicle = networkGetObject(streamReadInt32(streamId));
	self.storageIndex = streamReadInt8(streamId);
	self.holderIndex = streamReadInt8(streamId);
	self.visibility = streamReadBool(streamId);
	self:run(connection);
end;

function FoilStorageSetRoleEvent:run(connection)
	self.vehicle:foilStorageSetRole(self.storageIndex, self.holderIndex, self.visibility, true);
	if not connection:getIsServer() then
		g_server:broadcastEvent(FoilStorageSetRoleEvent:new(self.vehicle, self.storageIndex, self.holderIndex, self.visibility), nil, connection, self.vehicle);
	end;
end;

function FoilStorageSetRoleEvent.sendEvent(vehicle, storageIndex, holderIndex, visibility, noEventSend)
	if not noEventSend then
		if g_server ~= nil then
			g_server:broadcastEvent(FoilStorageSetRoleEvent:new(vehicle, storageIndex, holderIndex, visibility), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(FoilStorageSetRoleEvent:new(vehicle, storageIndex, holderIndex, visibility));
		end;
	end;
end;