-- author: rafftnix
-- date: 25.08.2015

-- fixes problems while loading savegame

local oldBaleLoadFromAttributesAndNodes = Bale.loadFromAttributesAndNodes;
Bale.loadFromAttributesAndNodes = function(self, xmlFile, key, resetVehicles)
	local filename = getXMLString(xmlFile, key.."#filename");
	if string.find (Utils.convertFromNetworkFilename(filename), Ultima.modDir) ~= nil then
		self.i3dFilename = Utils.convertFromNetworkFilename(filename);
		self.customEnvironment, self.baseDirectory = Utils.getModNameAndBaseDirectory(self.i3dFilename);
		local smallFileName = string.gsub(filename, "$moddir$"..tostring(self.customEnvironment).."/", "");
		local baleRoot = Utils.loadSharedI3DFile(smallFileName, self.baseDirectory, false, false);
		baleNode = getChildAt(baleRoot, 0);
		unlink(baleNode);
		delete(baleRoot);
		link(getRootNode(), baleNode);
		setRigidBodyType(baleNode, "Dynamic"); 
		self:setNodeId(baleNode);
		local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, key.."#position"));
		local rx, ry, rz = Utils.getVectorFromString(getXMLString(xmlFile, key.."#rotation"));
		setTranslation(baleNode, x, y, z);
		setRotation(baleNode, rx, ry, rz);
		return true;
	else
		return oldBaleLoadFromAttributesAndNodes(self, xmlFile, key, resetVehicles);
	end;
end;