SetWrapFoilLengthEvent = {};
SetWrapFoilLengthEvent_mt = Class(SetWrapFoilLengthEvent, Event);
InitEventClass(SetWrapFoilLengthEvent, "SetWrapFoilLengthEvent");

function SetWrapFoilLengthEvent:emptyNew()
    local self = Event:new(SetWrapFoilLengthEvent_mt);
    self.className = "SetWrapFoilLengthEvent";
    return self;
end;

function SetWrapFoilLengthEvent:new(vehicle, index, length)
    local self = SetWrapFoilLengthEvent:emptyNew();
	self.vehicle = vehicle;
	self.index = index;
	self.length = math.floor(length);
    return self;
end;

function SetWrapFoilLengthEvent:writeStream(streamId, connection)
	streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteInt8(streamId, self.index);
	streamWriteInt32(streamId, self.length);
end;

function SetWrapFoilLengthEvent:readStream(streamId, connection)
	self.vehicle = networkGetObject(streamReadInt32(streamId));
	self.index = streamReadInt8(streamId);
	self.length = streamReadInt32(streamId);
	self:run(connection);
end;

function SetWrapFoilLengthEvent:run(connection)
	self.vehicle:setWrapFoilLength(self.index, self.length, true);
	if not connection:getIsServer() then
		g_server:broadcastEvent(SetWrapFoilLengthEvent:new(self.vehicle, self.index, self.length), nil, nil, self.vehicle);
	end;
end;

function SetWrapFoilLengthEvent.sendEvent(vehicle, index, length, noEventSend)
	if not noEventSend then
		if g_server ~= nil then
			g_server:broadcastEvent(SetWrapFoilLengthEvent:new(vehicle, index, length), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(SetWrapFoilLengthEvent:new(vehicle, index, length));
		end;
	end;
end;