SetRoleVisibilityEvent = {};
SetRoleVisibilityEvent_mt = Class(SetRoleVisibilityEvent, Event);
InitEventClass(SetRoleVisibilityEvent, "SetRoleVisibilityEvent");

function SetRoleVisibilityEvent:emptyNew()
    local self = Event:new(SetRoleVisibilityEvent_mt);
    self.className = "SetRoleVisibilityEvent";
    return self;
end;

function SetRoleVisibilityEvent:new(vehicle, placeIndex, visibility)
    local self = SetRoleVisibilityEvent:emptyNew();
	self.vehicle = vehicle;
	self.placeIndex = placeIndex;
	self.visibility = visibility;
    return self;
end;

function SetRoleVisibilityEvent:writeStream(streamId, connection)
	streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteInt8(streamId, self.placeIndex);
	streamWriteBool(streamId, self.visibility);
end;

function SetRoleVisibilityEvent:readStream(streamId, connection)
	self.vehicle = networkGetObject(streamReadInt32(streamId));
	self.placeIndex = streamReadInt8(streamId);
	self.visibility = streamReadBool(streamId);
	self:run(connection);
end;

function SetRoleVisibilityEvent:run(connection)
	self.vehicle:setRoleVisibility(self.placeIndex, self.visibility, true);
	
	if not connection:getIsServer() then
		g_server:broadcastEvent(SetRoleVisibilityEvent:new(self.vehicle, self.placeIndex, self.visibility), nil, connection, self.vehicle);
	end;
end;

function SetRoleVisibilityEvent.sendEvent(vehicle, placeIndex, visibility, noEventSend)
	if not noEventSend then
		if g_server ~= nil then
			g_server:broadcastEvent(SetRoleVisibilityEvent:new(vehicle, placeIndex, visibility), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(SetRoleVisibilityEvent:new(vehicle, placeIndex, visibility));
		end;
	end;
end;