SetNetRoleOnStorageEvent = {};
SetNetRoleOnStorageEvent_mt = Class(SetNetRoleOnStorageEvent, Event);
InitEventClass(SetNetRoleOnStorageEvent, "SetNetRoleOnStorageEvent");

function SetNetRoleOnStorageEvent:emptyNew()
    local self = Event:new(SetNetRoleOnStorageEvent_mt);
    self.className = "SetNetRoleOnStorageEvent";
    return self;
end;

function SetNetRoleOnStorageEvent:new(vehicle, placeIndex, visibility)
    local self = SetNetRoleOnStorageEvent:emptyNew();
	self.vehicle = vehicle;
	self.placeIndex = placeIndex;
	self.visibility = visibility;
    return self;
end;

function SetNetRoleOnStorageEvent:writeStream(streamId, connection)
	streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteInt8(streamId, self.placeIndex);
	streamWriteBool(streamId, self.visibility);
end;

function SetNetRoleOnStorageEvent:readStream(streamId, connection)
	self.vehicle = networkGetObject(streamReadInt32(streamId));
	self.placeIndex = streamReadInt8(streamId);
	self.visibility = streamReadBool(streamId);
	self:run(connection);
end;

function SetNetRoleOnStorageEvent:run(connection)
	self.vehicle:setNetRoleOnStoragePlace(self.placeIndex, self.visibility, true);
	
	if not connection:getIsServer() then
		g_server:broadcastEvent(SetNetRoleOnStorageEvent:new(self.vehicle, self.placeIndex, self.visibility), nil, connection, self.vehicle);
	end;
end;

function SetNetRoleOnStorageEvent.sendEvent(vehicle, placeIndex, visibility, noEventSend)
	if not noEventSend then
		if g_server ~= nil then
			g_server:broadcastEvent(SetNetRoleOnStorageEvent:new(vehicle, placeIndex, visibility), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(SetNetRoleOnStorageEvent:new(vehicle, placeIndex, visibility));
		end;
	end;
end;