SetNetRoleFillStateEvent = {};
SetNetRoleFillStateEvent_mt = Class(SetNetRoleFillStateEvent, Event);
InitEventClass(SetNetRoleFillStateEvent, "SetNetRoleFillStateEvent");

function SetNetRoleFillStateEvent:emptyNew()
    local self = Event:new(SetNetRoleFillStateEvent_mt);
    self.className = "SetNetRoleFillStateEvent";
    return self;
end;

function SetNetRoleFillStateEvent:new(vehicle, length)
    local self = SetNetRoleFillStateEvent:emptyNew();
	self.vehicle = vehicle;
	self.length = math.floor(length);
    return self;
end;

function SetNetRoleFillStateEvent:writeStream(streamId, connection)
	streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteInt32(streamId, self.length);
end;

function SetNetRoleFillStateEvent:readStream(streamId, connection)
	self.vehicle = networkGetObject(streamReadInt32(streamId));
	self.length = streamReadInt32(streamId);
	self:run(connection);
end;

function SetNetRoleFillStateEvent:run(connection)
	self.vehicle:setNetRoleFillState(self.length);
end;