SetBalerStateEvent = {};
SetBalerStateEvent_mt = Class(SetBalerStateEvent, Event);
InitEventClass(SetBalerStateEvent, "SetBalerStateEvent");

function SetBalerStateEvent:emptyNew()
    local self = Event:new(SetBalerStateEvent_mt);
    self.className = "SetBalerStateEvent";
    return self;
end;

function SetBalerStateEvent:new(vehicle, state)
    local self = SetBalerStateEvent:emptyNew();
	self.vehicle = vehicle;
	self.state = state;
    return self;
end;

function SetBalerStateEvent:writeStream(streamId, connection)
	streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteInt8(streamId, self.state);
end;

function SetBalerStateEvent:readStream(streamId, connection)
	self.vehicle = networkGetObject(streamReadInt32(streamId));
	self.state = streamReadInt8(streamId);
	self:run(connection);
end;

function SetBalerStateEvent:run(connection)
	self.vehicle:setBalerState(self.state, true);
	if not connection:getIsServer() then
		g_server:broadcastEvent(SetBalerStateEvent:new(self.vehicle, self.state), nil, connection, self.vehicle);
	end;
end;

function SetBalerStateEvent.sendEvent(vehicle, state, noEventSend)
	if not noEventSend then
		if g_server ~= nil then
			g_server:broadcastEvent(SetBalerStateEvent:new(vehicle, state), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(SetBalerStateEvent:new(vehicle, state));
		end;
	end;
end;