SetBaleDropModeEvent = {};
SetBaleDropModeEvent_mt = Class(SetBaleDropModeEvent, Event);
InitEventClass(SetBaleDropModeEvent, "SetBaleDropModeEvent");

function SetBaleDropModeEvent:emptyNew()
    local self = Event:new(SetBaleDropModeEvent_mt);
    self.className = "SetBaleDropModeEvent";
    return self;
end;

function SetBaleDropModeEvent:new(vehicle, mode)
    local self = SetBaleDropModeEvent:emptyNew();
	self.vehicle = vehicle;
	self.mode = mode;
    return self;
end;

function SetBaleDropModeEvent:writeStream(streamId, connection)
	streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteInt8(streamId, self.mode);
end;

function SetBaleDropModeEvent:readStream(streamId, connection)
	self.vehicle = networkGetObject(streamReadInt32(streamId));
	self.mode = streamReadInt8(streamId);
	self:run(connection);
end;

function SetBaleDropModeEvent:run(connection)
	self.vehicle:setBaleDropMode(self.mode, true);
	if not connection:getIsServer() then
		g_server:broadcastEvent(SetBaleDropModeEvent:new(self.vehicle, self.mode), nil, connection, self.vehicle);
	end;
end;

function SetBaleDropModeEvent.sendEvent(vehicle, mode, noEventSend)
	if not noEventSend then
		if g_server ~= nil then
			g_server:broadcastEvent(SetBaleDropModeEvent:new(vehicle, mode), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(SetBaleDropModeEvent:new(vehicle, mode));
		end;
	end;
end;