PlayerTakeRoleEvent = {};
PlayerTakeRoleEvent_mt = Class(PlayerTakeRoleEvent, Event);
InitEventClass(PlayerTakeRoleEvent, "PlayerTakeRoleEvent");

function PlayerTakeRoleEvent:emptyNew()
    local self = Event:new(PlayerTakeRoleEvent_mt);
    self.className = "PlayerTakeRoleEvent";
    return self;
end;

function PlayerTakeRoleEvent:new(vehicle, player, take)
    local self = PlayerTakeRoleEvent:emptyNew();
	self.vehicle = vehicle;
	self.player = player;
	self.take = take;
    return self;
end;

function PlayerTakeRoleEvent:writeStream(streamId, connection)
	streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteInt32(streamId, networkGetObjectId(self.player));
	streamWriteBool(streamId, self.take);
end;

function PlayerTakeRoleEvent:readStream(streamId, connection)
	self.vehicle = networkGetObject(streamReadInt32(streamId));
	self.player = networkGetObject(streamReadInt32(streamId));
	self.take = streamReadBool(streamId);
	self:run(connection);
end;

function PlayerTakeRoleEvent:run(connection)
	if self.take then
		self.vehicle:playerTakeRole(self.player, true);
	else
		self.vehicle:playerRemoveRole(self.player, true);
	end;
	if not connection:getIsServer() then
		g_server:broadcastEvent(PlayerTakeRoleEvent:new(self.vehicle, self.player, self.take), nil, connection, self.vehicle);
	end;
end;

function PlayerTakeRoleEvent.sendEvent(vehicle, player, take, noEventSend)
	if not noEventSend then
		if g_server ~= nil then
			g_server:broadcastEvent(PlayerTakeRoleEvent:new(vehicle, player, take), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(PlayerTakeRoleEvent:new(vehicle, player, take));
		end;
	end;
end;