-- NI Modding
--
-- author  	Henly20 
-- date  	23-05-2013.
-- ni_modding@hotmail.com
-- http://nimodding.wordpress.com
--

krone395 = {}

function krone395.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(ImplementLinks, specializations) and SpecializationUtil.hasSpecialization(kroneWindrower, specializations);
end;

function krone395:load(xmlFile)

    self.setVehicleRpmUp = SpecializationUtil.callSpecializationsFunction("setVehicleRpmUp");
    self.saveMinRpm = 0; 
    self.printWarningTime = 0;

	self.animationSpeed = 0;
	self.animation.offsetTime = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.animation#offsetTime"), 3) * 1000;
	
    local windrowerStartSound = getXMLString(xmlFile, "vehicle.windrowerStartSound#file");
    if windrowerStartSound ~= nil and windrowerStartSound ~= "" then
        windrowerStartSound = Utils.getFilename(windrowerStartSound, self.baseDirectory);
        self.windrowerStartSound = createSample("windrowerStartSound");
        loadSample(self.windrowerStartSound, windrowerStartSound, false);
        self.windrowerStartSoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.windrowerStartSound#pitchOffset"), 1);
        self.windrowerStartSoundVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.windrowerStartSound#volume"), 1.0);
    end;
	
    local windrowerStopSound = getXMLString(xmlFile, "vehicle.windrowerStopSound#file");
    if windrowerStopSound ~= nil and windrowerStopSound ~= "" then
        windrowerStopSound = Utils.getFilename(windrowerStopSound, self.baseDirectory);
        self.windrowerStopSound = createSample("windrowerStopSound");
        loadSample(self.windrowerStopSound, windrowerStopSound, false);
        self.windrowerStopSoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehiclewindrowerStopSound#pitchOffset"), 1);
        self.windrowerStopSoundVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.windrowerSound#volume"), 1.0);
    end;
	
	local clientSoundFile = getXMLString(xmlFile, "vehicle.windrowerAISound#file");	
	if clientSoundFile ~= nil then
		clientSoundFile = Utils.getFilename(clientSoundFile, self.baseDirectory);
		self.windowerAISoundVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.windrowerAISound#volume"), 1.0);
        self.windowerAISoundRadius = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.windrowerAISound#radius"), 50);
        self.windowerAISoundInnerRadius = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.windrowerAISound#innerRadius"), 10);
        self.windrowerAISound = createAudioSource("windrowerAISound", clientSoundFile, self.windowerAISoundRadius, self.windowerAISoundInnerRadius, self.windowerAISoundVolume, 0);
        link(self.components[1].node, self.windrowerAISound);
        setVisibility(self.windrowerAISound, false);
	end;
	
    if self.isClient then
          local windrowerSound = getXMLString(xmlFile, "vehicle.windrowerSound#file");
          if windrowerSound ~= nil and windrowerSound ~= "" then
              windrowerSound = Utils.getFilename(windrowerSound, self.baseDirectory);
              self.windrowerSound = createSample("windrowerSound");
              self.windrowerSoundEnabled = false;
              loadSample(self.windrowerSound, windrowerSound, false);
              self.windrowerSoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.windrowerSound#pitchOffset"), 1);
              self.windrowerSoundVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.windrowerSound#volume"), 1.0);
         end;
     end;
	 
	  
	self.rowerParticleSystemsLeft = {};
      local i = 0;
      while true do
        local namei = string.format("vehicle.rowerParticleSystemsLeft.rowerParticleSystemsLeft(%d)", i);
		local nodei = Utils.indexToObject(self.components, getXMLString(xmlFile, namei .. "#index"));
		if nodei == nil then
			break;
		end; 
        Utils.loadParticleSystem(xmlFile, self.rowerParticleSystemsLeft, namei, nodei, false, nil, self.baseDirectory)		
		i = i +1;		
      end;	
	  
	self.soundOffset = 0;
	self.isTurnedOn = false;

end;

function krone395:delete()
	if self.rowerParticleSystemsLeft ~= nil then	
		Utils.deleteParticleSystem(self.rowerParticleSystemsLeft);
	end;
	
	if self.windrowerStartSound ~= nil then
        delete(self.windrowerStartSound);
		self.windrowerStartSound = nil;
    end;
	if self.windrowerStopSound ~= nil then
        delete(self.windrowerStopSound);
		self.windrowerStopSound = nil;
    end;
    if self.windrowerSound ~= nil then
        delete(self.windrowerSound);
    end;
end;

function krone395:readStream(streamId, connection)

end;

function krone395:writeStream(streamId, connection)

end;

function krone395:readUpdateStream(streamId, timestamp, connection)

end;

function krone395:writeUpdateStream(streamId, connection, dirtyMask)
 
end;

function krone395:mouseEvent(posX, posY, isDown, isUp, button)

end;

function krone395:keyEvent(unicode, sym, modifier, isDown)

end;
  
function krone395:update(dt)

    if self.isClient then
        if self:getIsActiveForInput() then
			if InputBinding.isPressed(InputBinding.IMPLEMENT_EXTRA) and self.PTOId then
				self.printWarningTime = self.time + 1000;
			end;	
        end;
    end;
end;

function krone395:updateTick(dt)
    if self.isClient then
		if self.attacherVehicle ~= nil then
			if self.PTOId or not self.attacherVehicle.isMotorStarted then -- PTO is detached, or engine is off.
				self:setIsTurnedOn(false);
			end;
		end;

		
	end;
	if self:getIsActive() then
		local isKeyEvent = false;	
		if self.isTurnedOn then
 			isKeyEvent = true;	
		else
 			isKeyEvent = false;	
		end;
		
		self:setVehicleRpmUp(dt, isKeyEvent);		
		if self.isTurnedOn and not self.PTOId then	
            if not self.animationEnabled then
                enableAnimTrack(self.animation.animCharSet, 0);
                self.animationEnabled = true;
			else
				if self.animationSpeed < (self.animation.speedScale - 0.01) then
					local newSpeed = Utils.getMovedLimitedValues({self.animationSpeed}, {self.animation.speedScale}, {0}, 1, self.animation.offsetTime, dt, false);
					self.animationSpeed = newSpeed[1];
					setAnimTrackSpeedScale(self.animation.animCharSet, 0, self.animationSpeed);
				end;
            end;		
        else
			if self.animationEnabled then
				if self.animationSpeed < 0.01 then
					disableAnimTrack(self.animation.animCharSet, 0);
					self.animationEnabled = false;
				else
					enableAnimTrack(self.animation.animCharSet, 0);
					local newSpeed = Utils.getMovedLimitedValues({self.animationSpeed}, {self.animation.speedScale}, {0}, 1, self.animation.offsetTime, dt, true);
					self.animationSpeed = newSpeed[1];
					setAnimTrackSpeedScale(self.animation.animCharSet, 0, self.animationSpeed);
				end;
			end;
		end;
		if self.isTurnedOn and self.movingDirection ~= 0 and self.lastAreaBiggerZero and self:isLowered(false) then
			Utils.setEmittingState(self.rowerParticleSystemsLeft, true);		
		else
			Utils.setEmittingState(self.rowerParticleSystemsLeft, false);			
		end;		
	end;

end;

function krone395:draw()
    if self.isClient then
		if self.printWarningTime > self.time then
			g_currentMission:addWarning(g_i18n:getText("turnON_Error"), 0.018, 0.033);
		end;
    end;

end;

function krone395:onDetach()
	if self.rowerParticleSystemsLeft ~= nil then
		Utils.setEmittingState(self.rowerParticleSystemsLeft, false);
	end; 
    for k, steerable in pairs(g_currentMission.steerables) do
        if self.attacherVehicleCopy == steerable then
            steerable.motor.minRpm = self.saveMinRpm;
            self.attacherVehicleCopy = nil;
        end;
    end;
end;

function krone395:onAttach(attacherVehicle)

    if self.attacherVehicleCopy == nil then
        self.attacherVehicleCopy = self.attacherVehicle;
    end;
    self.saveMinRpm = self.attacherVehicle.motor.minRpm;
end;

function krone395:onLeave()
	if self.rowerParticleSystemsLeft ~= nil then
		Utils.setEmittingState(self.rowerParticleSystemsLeft, false);
	end; 
end;

function krone395:onDeactivate()

end;

function krone395:onDeactivateSounds()

end;

function krone395:setIsTurnedOn(isTurnedOn, noEventSend)
	if not isTurnedOn then
		self.animationEnabled = true;
	end;
end;

function krone395:setVehicleRpmUp(dt, isActive)
    if self.attacherVehicle ~= nil and self.saveMinRpm ~= 0 then
        if dt ~= nil then
            if isActive == true then
                self.attacherVehicle.motor.minRpm = math.max(self.attacherVehicle.motor.minRpm-dt, -1000);
            else
                self.attacherVehicle.motor.minRpm = math.min(self.attacherVehicle.motor.minRpm+dt*2, self.saveMinRpm);
            end;
        else
            self.attacherVehicle.motor.minRpm = self.saveMinRpm;
        end;
        if self.attacherVehicle.isMotorStarted then
            local fuelUsed = 0.000000011*math.abs(self.attacherVehicle.motor.minRpm);
            self.attacherVehicle:setFuelFillLevel(self.attacherVehicle.fuelFillLevel-fuelUsed);
            g_currentMission.missionStats.fuelUsageTotal = g_currentMission.missionStats.fuelUsageTotal + fuelUsed;
            g_currentMission.missionStats.fuelUsageSession = g_currentMission.missionStats.fuelUsageSession + fuelUsed;
        end;
    end;
end;
