--
-- IndoorSound
-- Specialization for IndoorSound
--
-- @author  	Manuel Leithner (SFM-Modding)
-- @version 	v1.0
-- @date  		02/11/11
-- @history:	v1.0 - Initial version
--
-- free for noncommerical-usage
--

IndoorSound = {};

function IndoorSound.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Steerable, specializations);
end;

function IndoorSound:load(xmlFile)

	self.indoorSounds = {};
	self.indoorSounds.sounds = {};
	i = 0;
	while true do 
		local key = string.format("vehicle.indoorSounds.sound(%d)", i);
		if not hasXMLProperty(xmlFile, key .. "#id") then
			break;
		end;
		
		local id = getXMLString(xmlFile, key .. "#id");
		
		local sound = {};
		sound.id = self[id].sample;
		sound.name = id;
		if sound.id == nil then
			break;
		end;
		sound.isDynamic = Utils.getNoNil(getXMLBool(xmlFile, key.."#isDynamic"), false);
		sound.outdoor = self[id].volume;
		sound.indoorFactor = Utils.getNoNil(getXMLFloat(xmlFile, key .. "#percent"), 0.5);
		sound.indoor = sound.outdoor * sound.indoorFactor;
		table.insert(self.indoorSounds.sounds, sound);
		i = i + 1;
	end;
	
	self.indoorSounds.indoorCamIndex = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.indoorSounds#camIndex"), 2);	
	self.indoorSounds.lastCamIndex = 1;
end;

function IndoorSound:delete()
end;

function IndoorSound:readStream(streamId, connection)
end;

function IndoorSound:writeStream(streamId, connection)
end;

function IndoorSound:mouseEvent(posX, posY, isDown, isUp, button)
end;

function IndoorSound:keyEvent(unicode, sym, modifier, isDown)
end;

function IndoorSound:update(dt)
end;

function IndoorSound:updateTick(dt)
	if self:getIsActiveForInput(false) then

		local sound = self.indoorSounds;
		if self.isMotorStarted then
			if (self.camIndex == sound.indoorCamIndex or self.passengerPlayer == g_currentMission.player) and self.animationParts[9].clipStartTime and self.animationParts[10].clipStartTime then
				for _, sound in pairs(sound.sounds) do
					if sound.isDynamic then
						self[sound.name].volume = sound.indoor
					else
						setSampleVolume(sound.id, sound.indoor);	
					end;
				end;
				sound.lastCamIndex = self.camIndex;
			else
				for _, sound in pairs(sound.sounds) do
					if sound.isDynamic then
						self[sound.name].volume = sound.outdoor
					else
						setSampleVolume(sound.id, sound.outdoor);	
					end;
				end;			
				sound.lastCamIndex = self.camIndex;
			end;
		end;
	end;
end;

function IndoorSound:draw()	
end;