specialJoint = {};

function specialJoint.prerequisitesPresent(specializations)
return true;
end;

function specialJoint:load(xmlFile)

self.specialJoint = {};
self.specialJoint.index = getXMLInt(xmlFile, "vehicle.specialJoint#index");
self.specialJoint.node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.specialJoint#node"));
self.specialJoint.rotNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.specialJoint#rotationNode"));
self.specialJoint.rotNode2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.specialJoint#rotationNode2"));
local joint = self.attacherJoints[self.specialJoint.index];
self.specialJoint.rotNodeBackup = joint.rotationNode;
self.specialJoint.rotNode2Backup = joint.rotationNode2;
self.specialJoint.maxRotLimitBackup = joint.maxRotLimit;
self.specialJoint.backup = joint.jointTransform;
local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.specialJoint#maxRotLimit"));
self.specialJoint.maxRotLimit = {};
self.specialJoint.maxRotLimit[1] = math.rad(math.abs(Utils.getNoNil(x, 0)));
self.specialJoint.maxRotLimit[2] = math.rad(math.abs(Utils.getNoNil(y, 0)));
self.specialJoint.maxRotLimit[3] = math.rad(math.abs(Utils.getNoNil(z, 0)));
end;

function specialJoint:delete()
end;

function specialJoint:mouseEvent(posX, posY, isDown, isUp, button)
end;

function specialJoint:keyEvent(unicode, sym, modifier, isDown)
end;

function specialJoint:update(dt)
end;

function specialJoint:updateTick(dt)
end;

function specialJoint:draw()
end;

local oldVehicleAttachImplement = Vehicle.attachImplement;
Vehicle.attachImplement = function(self, object, jointIndex, noEventSend, index)
if self.specialJoint ~= nil then
if self.specialJoint.index == jointIndex and object.specialJoint ~= nil then
self.specialJoint.attachable = object;
local joint = self.attacherJoints[self.specialJoint.index];
joint.jointTransform = self.specialJoint.node;
joint.rotationNode = self.specialJoint.rotNode;
joint.rotationNode2 = self.specialJoint.rotNode2;
joint.maxRotLimit = self.specialJoint.maxRotLimit;
object.attacherJoint.node = object.specialJoint.node;
end;
end;
oldVehicleAttachImplement(self, object, jointIndex, noEventSend, index);
end;

local oldVehicleDetachImplement = Vehicle.detachImplement;
Vehicle.detachImplement = function(self, implementIndex, noEventSend)
local implement = self.attachedImplements[implementIndex];
local index = nil;
local object = nil;
if implement ~= nil then
index = implement.jointDescIndex;
object = implement.object;
end;
oldVehicleDetachImplement(self, implementIndex, noEventSend);

if implement ~= nil then
if self.specialJoint ~= nil then
if object.specialJoint ~= nil and self.specialJoint.index == index then
local joint = self.attacherJoints[self.specialJoint.index];
joint.jointTransform = self.specialJoint.backup;
joint.rotationNode = self.specialJoint.rotNodeBackup;
joint.rotationNode = self.specialJoint.rotNode2Backup;
joint.maxRotLimit = self.specialJoint.maxRotLimitBackup;
object.attacherJoint.node = object.specialJoint.backup;
end;
end;
end;
end;