SetPlaneEvent = {};
SetPlaneEvent_mt = Class(SetPlaneEvent, Event);

InitEventClass(SetPlaneEvent, "SetPlaneEvent");

function SetPlaneEvent:emptyNew()
    local self = Event:new(SetPlaneEvent_mt);
    self.className="SetPlaneEvent";
    return self;
end;

function SetPlaneEvent:new(vehicle, state)
    local self = SetPlaneEvent:emptyNew()
    self.vehicle = vehicle;
	self.state = state;
	return self;
end;

function SetPlaneEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.state = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function SetPlaneEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));	
	streamWriteBool(streamId, self.state);
end;

function SetPlaneEvent:run(connection)
	self.vehicle:setPlane(self.state, true);
	if not connection:getIsServer() then
		g_server:broadcastEvent(SetPlaneEvent:new(self.vehicle, self.state), nil, connection, self.object);
	end;
end;

function SetPlaneEvent.sendEvent(vehicle, state, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(SetPlaneEvent:new(vehicle, state), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(SetPlaneEvent:new(vehicle, state));
		end;
	end;
end;