MoveGateEvent = {};
MoveGateEvent_mt = Class(MoveGateEvent, Event);
InitEventClass(MoveGateEvent, "MoveGateEvent");

function MoveGateEvent:emptyNew()
    local self = Event:new(MoveGateEvent_mt);
    self.className = "MoveGateEvent";
    return self;
end;

function MoveGateEvent:new(object, gateIndex, animTime)
    local self = MoveGateEvent:emptyNew();
	self.object = object;
	self.gateIndex = gateIndex;
	self.animTime = animTime;
    return self;
end;

function MoveGateEvent:writeStream(streamId, connection)
	streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteInt8(streamId, self.gateIndex);
	streamWriteInt16(streamId, math.floor(self.animTime*30000));
end;

function MoveGateEvent:readStream(streamId, connection)
	self.object = networkGetObject(streamReadInt32(streamId));
	self.gateIndex = streamReadInt8(streamId);
	self.animTime = streamReadInt16(streamId)/30000;
	self:run(connection);
end;

function MoveGateEvent:run(connection)
	self.object:moveGate(self.gateIndex, self.animTime, true);
	if not connection:getIsServer() then
		g_server:broadcastEvent(MoveGateEvent:new(self.object, self.gateIndex, self.animTime), nil, connection, self.object);
	end;
end;

function MoveGateEvent.sendEvent(object, gateIndex, animTime, noEventSend)
	if not noEventSend then
		if g_server ~= nil then
			g_server:broadcastEvent(MoveGateEvent:new(object, gateIndex, animTime), nil, nil, object);
		else
			g_client:getServerConnection():sendEvent(MoveGateEvent:new(object, gateIndex, animTime));
		end;
	end;
end;