LockSteeringaxlesKrampe = {};

function LockSteeringaxlesKrampe.prerequisitesPresent(specializations)
    return true;
end;

function LockSteeringaxlesKrampe:load(xmlFile)
	self.lockAxles = SpecializationUtil.callSpecializationsFunction("lockAxles");
	
	self.enableIfReverse = Utils.getNoNil(getXMLBool(xmlFile, "vehicle.wheels.enableSteeringaxlesIfReverse"), true);
	
	for i=1, table.getn(self.wheels) do 
		self.wheels[i].backupScale = self.wheels[i].steeringAxleScale;
		self.wheels[i].backupMax = self.wheels[i].steeringAxleRotMax;
		self.wheels[i].backupMin = self.wheels[i].steeringAxleRotMin;
    end;
	
	if InputBinding.LOCK_AXLES == nil then
		InputBinding.LOCK_AXLES = InputBinding.IMPLEMENT_EXTRA3;
	end;
end;

function LockSteeringaxlesKrampe:readStream(streamId, connection)
	self:lockAxles(streamReadBool(streamId), true);
end;

function LockSteeringaxlesKrampe:writeStream(streamId, connection)
	streamWriteBool(streamId, self.lock);
end;

function LockSteeringaxlesKrampe:delete()
end;

function LockSteeringaxlesKrampe:mouseEvent(posX, posY, isDown, isUp, button)
end;

function LockSteeringaxlesKrampe:keyEvent(unicode, sym, modifier, isDown)
end;

function LockSteeringaxlesKrampe:update(dt)
	if self:getIsActiveForInput() then
		if InputBinding.hasEvent(InputBinding.LOCKSTEERING_Krampe) then
			self:lockAxles(not self.lock);			
		end;
	end;
	
	-- # Section from sven18koehler # --
	if self.updateSteeringAxleAngle and self.enableIfReverse then
		if self.attacherVehicle ~= nil and self.movingDirection < 0 then
			local x,y,z = worldDirectionToLocal(self.steeringAxleNode, localDirectionToWorld(self.attacherVehicle.steeringAxleNode, 0, 0, 1));
			local dot = z;
			dot = dot / Utils.vector2Length(x,z);
			local angle = math.acos(dot);
			if x < 0 then
				angle = -angle;
			end;
			local startSpeed = self.steeringAxleAngleScaleStart;
			local endSpeed = self.steeringAxleAngleScaleEnd;
			local scale = Utils.clamp(1 + (self.lastSpeed*-3600-startSpeed) * 1.0/(startSpeed-endSpeed), 0, 1);
			self.steeringAxleAngle = angle*scale;
		end;
	end;
	--#--
end;

function LockSteeringaxlesKrampe:updateTick(dt)
end;

function LockSteeringaxlesKrampe:lockAxles(lock, noEventSend)
	for i=1, table.getn(self.wheels) do 
		local wheel = self.wheels[i];
		if lock then 
			wheel.steeringAxleScale = 0;
			wheel.steeringAxleRotMax = 0;
			wheel.steeringAxleRotMin = 0;
		else
			wheel.steeringAxleScale = wheel.backupScale;
			wheel.steeringAxleRotMax = wheel.backupMax;
			wheel.steeringAxleRotMin = wheel.backupMin;
		end;
	end;
	self.lock = lock;
	LockSteeringaxlesKrampeEvent.sendEvent(self, self.lock, noEventSend);
end;

function LockSteeringaxlesKrampe:draw()
	if self.lock then
		g_currentMission:addHelpButtonText(g_i18n:getText("unlockSteeringaxles"), InputBinding.LOCKSTEERING_Krampe);
	else
		g_currentMission:addHelpButtonText(g_i18n:getText("lockSteeringaxles"), InputBinding.LOCKSTEERING_Krampe);
	end;
end;
						
						
						
--####	EVENT	####-- 
	
--@author	-	FIAT80-90DT																
--@date		-	28.08.11											

LockSteeringaxlesKrampeEvent = {};
LockSteeringaxlesKrampeEvent_mt = Class(LockSteeringaxlesKrampeEvent, Event);

InitEventClass(LockSteeringaxlesKrampeEvent, "LockSteeringaxlesKrampeEvent");

function LockSteeringaxlesKrampeEvent:emptyNew()
    local self = Event:new(LockSteeringaxlesKrampeEvent_mt);
    self.className="LockSteeringaxlesKrampeEvent";
    return self;
end;

function LockSteeringaxlesKrampeEvent:new(vehicle, lock)
    local self = LockSteeringaxlesKrampeEvent:emptyNew()
    self.vehicle = vehicle;
	self.lock = lock;
    return self;
end;

function LockSteeringaxlesKrampeEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
    self.vehicle = networkGetObject(id);
	
	self.lock = streamReadBool(streamId);
	self:run(connection);
end;

function LockSteeringaxlesKrampeEvent:run(connection)
	self.vehicle:lockAxles(self.lock, true);
	if not connection:getIsServer() then
        g_server:broadcastEvent(LockSteeringaxlesKrampeEvent:new(self.vehicle, self.lock), nil, connection, self.vehicle);
    end;
end;

function LockSteeringaxlesKrampeEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteBool(streamId, self.lock);
end;


function LockSteeringaxlesKrampeEvent.sendEvent(vehicle, lock, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(LockSteeringaxlesKrampeEvent:new(vehicle, lock), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(LockSteeringaxlesKrampeEvent:new(vehicle, lock));
		end;
	end;
end;