_=[[
author: igor29381

strings for xml:	  xml (     ,     )

<CargoUnits>
	<cargoUnit index=" " fruitType=" " />
	<cargoUnit index=" " fruitType=" " />
</CargoUnits>
]]

ShowCargoUnits2 = {};

function ShowCargoUnits2.prerequisitesPresent(specializations)
    return true;
end;

function ShowCargoUnits2:load(xmlFile)
	self.CargoUnits2 = {};
	local c = 0;
	while true do
		local baseString = string.format("vehicle.CargoUnits.cargoUnit(%d)#",c);
		local index = getXMLString(xmlFile,baseString.."index");
		local fruitType = getXMLString(xmlFile,baseString.."fruitType");
		if index == nil or fruitType == nil then break; end;
		local units = {};
		units.index = Utils.indexToObject(self.components, index);
		units.count = getNumOfChildren(units.index);
		units.fruitType = fruitType;
		table.insert(self.CargoUnits2, units);
		c = c + 1;
	end;
end;

function ShowCargoUnits2:delete()
end;

function ShowCargoUnits2:readStream(streamId, connection)
end;

function ShowCargoUnits2:writeStream(streamId, connection)
end;

function ShowCargoUnits2:mouseEvent(posX, posY, isDown, isUp, button)
end;

function ShowCargoUnits2:keyEvent(unicode, sym, modifier, isDown)
end;

function ShowCargoUnits2:update(dt)
	local FL = math.floor(self.fillLevel);
	local LFL = 0;
	if self.lastFillLevel ~= nil then LFL = math.floor(self.lastFillLevel); end;

	if FL ~= LFL then
		for _,units in ipairs(self.CargoUnits2) do
			if self.currentFillType == Fillable.fillTypeNameToInt[units.fruitType] then
				self.UnitsRootNode = units.index;
				self.UnitsCount = units.count;
			end;
		end;

		if self.UnitsCount ~= nil then
			for i=1, self.UnitsCount do
				local units = getChildAt(self.UnitsRootNode, i-1);
				setVisibility(units, false);
			end;
			local percentDecimal = self.fillLevel/self.capacity;
			local UnitsToShow = math.ceil(self.UnitsCount*percentDecimal);
			for i=1, UnitsToShow do
				local units = getChildAt(self.UnitsRootNode, i-1);
				setVisibility(units, true);
			end;
		end;
end;
--               if self.fillLevel == 0 then
--                return fruitType;
--	end;
	self.lastFillLevel = self.fillLevel;
end;

function ShowCargoUnits2:updateTick(dt)
	
end;

function ShowCargoUnits2:draw()
end;