_=[[
author: igor29381

strings for xml:	  xml (     ,     )

<CargoUnits>
	<cargoUnit index=" " fruitType=" " />
	<cargoUnit index=" " fruitType=" " />
</CargoUnits>
]]

ShowCargoUnits = {};

function ShowCargoUnits.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Trailer, specializations);
end;

function ShowCargoUnits:load(xmlFile)
	self.toSiloTrigger = ShowCargoUnits.toSiloTrigger;
	self.getCombine = Cutter.getCombine;
	self.CargoUnits = {};
	self.animParts = {};
	local c = 0;
	while true do
		local baseString = string.format("vehicle.CargoUnits.cargoUnit(%d)#",c);
		local index = getXMLString(xmlFile,baseString.."index");
		local fruitType = getXMLString(xmlFile,baseString.."fruitType");
		if index == nil or fruitType == nil then break; end;
		local units = {};
		units.index = Utils.indexToObject(self.components, index);
		units.count = getNumOfChildren(units.index);
		for i=1, units.count do
			setVisibility(getChildAt(units.index, i-1), false);
		end;
		units.fruitType = fruitType;
		table.insert(self.CargoUnits, units);
		c = c + 1;
	end;
	c = 0;
	while true do
		local baseString = string.format("vehicle.animParts.animPart(%d)#",c);
		local index = getXMLString(xmlFile,baseString.."index");
		if index == nil then break; end;
		local part = {};
		part.index = Utils.indexToObject(self.components, index);
		local rotMin = getXMLString(xmlFile,baseString.."rotMin");
		local rotMax = getXMLString(xmlFile,baseString.."rotMax");
		if rotMin and rotMax then
			part.rotMin = Utils.getRadiansFromString(rotMin, 3);
			part.rotMax = Utils.getRadiansFromString(rotMax, 3);
		end;
		part.moveTime = Utils.getNoNil(getXMLFloat(xmlFile,baseString.."moveTime"),1)*1000;
		table.insert(self.animParts,part);
		c = c + 1;
	end;
	self.isOpened = false;
	self.withInputLock = true;
end;

function ShowCargoUnits:delete()
end;

function ShowCargoUnits:readStream(streamId, connection)
end;

function ShowCargoUnits:writeStream(streamId, connection)
end;

function ShowCargoUnits:mouseEvent(posX, posY, isDown, isUp, button)
end;

function ShowCargoUnits:keyEvent(unicode, sym, modifier, isDown)
end;

function ShowCargoUnits:toSiloTrigger()
	if self.siloTrigger then
		if self.isOpened then
			self.siloTrigger.fillDone = false;
		else
			self.siloTrigger.fillDone = true;
			self.siloTrigger:stopFill();
		end;
	end;
end;

function ShowCargoUnits:update(dt)
	local FL = math.floor(self.fillLevel);
	local LFL = 0;
	if self.lastFillLevel then LFL = math.floor(self.lastFillLevel); end;
	if self:getIsActiveForInput() then
		if self.isOpened then
			g_currentMission:addHelpButtonText(g_i18n:getText("close_trailer"), InputBinding.IMPLEMENT_EXTRA2);
		else
			g_currentMission:addHelpButtonText(g_i18n:getText("open_trailer"), InputBinding.IMPLEMENT_EXTRA2);
		end;
		if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA2) then
			self.isOpened = not self.isOpened;
			if self.isServer then
				g_server:broadcastEvent(ShowCargoUnitsEvent:new(self.isOpened, self));
				self:toSiloTrigger();
			else
				g_client:getServerConnection():sendEvent(ShowCargoUnitsEvent:new(self.isOpened, self));
			end;
		end;
	end;
	local isOpened = self.isOpened;
	if FL ~= LFL or self.tipState == Trailer.TIPSTATE_OPENING or self.tipState == Trailer.TIPSTATE_OPEN then
		for _,units in pairs(self.CargoUnits) do
			if self.currentFillType == Fillable.fillTypeNameToInt[units.fruitType] then
				self.UnitsRootNode = units.index;
				self.UnitsCount = units.count;
			end;
		end;
		if self.UnitsCount then
			for i=1, self.UnitsCount do
				local units = getChildAt(self.UnitsRootNode, i-1);
				setVisibility(units, false);
			end;
			local percentDecimal = self.fillLevel/self.capacity;
			local UnitsToShow = math.ceil(self.UnitsCount*percentDecimal);
			for i=1, UnitsToShow do
				local units = getChildAt(self.UnitsRootNode, i-1);
				setVisibility(units, true);
			end;
		end;
		isOpened = true;
	end;
	self.lastFillLevel = self.fillLevel;
	if self:getIsActive() then
		for _,part in pairs(self.animParts) do
			local x, y, z = getRotation(part.index);
			local rot = {x,y,z};
			local newRot = Utils.getMovedLimitedValues(rot, part.rotMax, part.rotMin, 3, part.moveTime, dt, not isOpened);
			setRotation(part.index, unpack(newRot));
		end;
	end;
end;

function ShowCargoUnits:updateTick(dt)
end;

function ShowCargoUnits:draw()
-- if self.isClient then
--	if self.isOpened and self.lastSpeed * 3850 > 25 then
--                 g_currentMission:showBlinkingWarning(g_i18n:getText("helpTrailer"), 10);
--		else
--       end;
--     end;
end;

-----------------------

ShowCargoUnitsEvent = {};
ShowCargoUnitsEvent_mt = Class(ShowCargoUnitsEvent, Event);

InitEventClass(ShowCargoUnitsEvent, "ShowCargoUnitsEvent");

function ShowCargoUnitsEvent:emptyNew()
	local self = Event:new(ShowCargoUnitsEvent_mt);
    return self;
end;

function ShowCargoUnitsEvent:new(isOpened, object)
	local self = ShowCargoUnitsEvent:emptyNew();
	self.isOpened = isOpened;
	self.object = object;
	return self;
end;

function ShowCargoUnitsEvent:readStream(streamId, connection)
	local isOpened = streamReadBool(streamId);
    local object = networkGetObject(id);
	if object ~= nil then
		object.isOpened = isOpened;
		if object.isServer then
			object:toSiloTrigger();
		end;
	end;
end;

function ShowCargoUnitsEvent:writeStream(streamId, connection)
	streamWriteBool(streamId, self.isOpened);
	streamWriteInt32(streamId, networkGetObjectId(self.object));
end;
