HookLiftContainer = {
	prerequisitesPresent = function (specializations)
		return SpecializationUtil.hasSpecialization(AnimatedVehicle, specializations) and SpecializationUtil.hasSpecialization(Attachable, specializations)
	end
}
HookLiftContainer.load = function (self, xmlFile)
	self.toggleTipState = Utils.overwrittenFunction(self.toggleTipState, HookLiftContainer.toggleTipState)
	self.getAllowFillFromAir = Utils.overwrittenFunction(self.getAllowFillFromAir, HookLiftContainer.getAllowFillFromAir)
	self.getCanTipToGround = Utils.overwrittenFunction(self.getCanTipToGround, HookLiftContainer.getCanTipToGround)
	self.getCanTip = Utils.overwrittenFunction(self.getCanTip, HookLiftContainer.getCanTip)
	self.getEndTipIfEmpty = Utils.overwrittenFunction(self.getEndTipIfEmpty, HookLiftContainer.getEndTipIfEmpty)
	self.tiltContainerOnDischarge = Utils.getNoNil(getXMLBool(xmlFile, "vehicle.hookLiftContainer#tiltContainerOnDischarge"), true)
	self.canBeTippedManually = Utils.getNoNil(getXMLBool(xmlFile, "vehicle.hookLiftContainer#canBeTippedManually"), false)

	return 
end
HookLiftContainer.delete = function (self)
	return 
end
HookLiftContainer.mouseEvent = function (self, posX, posY, isDown, isUp, button)
	return 
end
HookLiftContainer.keyEvent = function (self, unicode, sym, modifier, isDown)
	return 
end
HookLiftContainer.update = function (self, dt)
	return 
end
HookLiftContainer.updateTick = function (self, dt)
	return 
end
HookLiftContainer.draw = function (self)
	return 
end
HookLiftContainer.onStartTip = function (self, tipTrigger, tipReferencePointIndex, noEventSend, isManuallyTipping)
	if self.isServer and self.currentTipReferencePointIndex ~= nil and self.currentTipReferencePointIndex ~= tipReferencePointIndex then
		return 
	end

	self.isManuallyTipping = isManuallyTipping

	if self.attacherVehicle ~= nil and self.attacherVehicle.startTipping ~= nil and self.tiltContainerOnDischarge then
		self.attacherVehicle:startTipping()
	end

	return 
end
HookLiftContainer.onEndTip = function (self, noEventSend)
	if self.attacherVehicle ~= nil and self.attacherVehicle.stopTipping ~= nil and self.tiltContainerOnDischarge then
		self.attacherVehicle:stopTipping()

		self.isManuallyTipping = false
	end

	return 
end
HookLiftContainer.getAllowFillFromAir = function (self, superFunc)
	if self.isManuallyTipping then
		return false
	end

	return superFunc(self)
end
HookLiftContainer.toggleTipState = function (self, superFunc, tipTrigger, tipReferencePointIndex, isManuallyTipping)
	if self.attacherVehicle ~= nil and self.attacherVehicle.isTippingAllowed ~= nil and not self.attacherVehicle:isTippingAllowed() then
		local t = self.attacherVehicle:getAnimationTime("unfoldHand")

		if t ~= 0 then
			self.attacherVehicle:setFoldDirection(-1)
		end

		return 
	end

	if self.isManuallyTipping and (self.tipState == Trailer.TIPSTATE_CLOSING or self.tipState == Trailer.TIPSTATE_CLOSED) then
		return 
	end

	self.isManuallyTipping = isManuallyTipping

	if superFunc ~= nil then
		superFunc(self, tipTrigger, tipReferencePointIndex, isManuallyTipping)
	end

	self.isManuallyTipping = isManuallyTipping and self.tipState == Trailer.TIPSTATE_OPENING

	return true
end
HookLiftContainer.getCanTipToGround = function (self, superFunc)
	if self.attacherVehicle ~= nil and self.attacherVehicle.isTippingAllowed ~= nil and not self.attacherVehicle:isTippingAllowed() then
		return false
	end

	if self.fillLevel == 0 and self.canBeTippedManually then
		return true
	end

	if superFunc ~= nil then
		return superFunc(self)
	end

	return true
end
HookLiftContainer.getCanTip = function (self, superFunc)
	if self.fillLevel == 0 and self.canBeTippedManually then
		return true
	end

	if superFunc ~= nil then
		return superFunc(self)
	end

	return true
end
HookLiftContainer.getEndTipIfEmpty = function (self, superFunc)
	if self.isManuallyTipping then
		return false
	end

	if superFunc ~= nil then
		return superFunc(self)
	end

	return true
end
--[[local modFilename, isMod, isDlc, dlcsDirectoryIndex = Utils.removeModDirectory(g_currentModDirectory)

if not isDlc or g_currentModName ~= "pdlc_itRunnerPack" then
	HookLiftContainer = nil
end]]

--if not _G.g_toggleTipEventManualTippingFixEnabled and isDlc and g_currentModName == "pdlc_itRunnerPack" then
if not _G.g_toggleTipEventManualTippingFixEnabled then
	_G.g_toggleTipEventManualTippingFixEnabled = true
	local oldTrailerToggleTipEventNew = TrailerToggleTipEvent.new
	TrailerToggleTipEvent.new = function (self, object, isStart, tipTrigger, tipReferencePointIndex, tipManually)
		local self = oldTrailerToggleTipEventNew(self, object, isStart, tipTrigger, tipReferencePointIndex, tipManually)
		self.tipManually = Utils.getNoNil(tipManually, Utils.getNoNil(object.isManuallyTipping, false))

		return self
	end
	local oldTrailerToggleTipEventReadStream = TrailerToggleTipEvent.readStream
	TrailerToggleTipEvent.readStream = function (self, streamId, connection)
		self.tipManually = streamReadBool(streamId)

		oldTrailerToggleTipEventReadStream(self, streamId, connection)

		return 
	end
	local oldTrailerToggleTipEventWriteStream = TrailerToggleTipEvent.writeStream
	TrailerToggleTipEvent.writeStream = function (self, streamId, connection)
		streamWriteBool(streamId, self.tipManually)
		oldTrailerToggleTipEventWriteStream(self, streamId, connection)

		return 
	end
	local oldTrailerToggleTipEventRun = TrailerToggleTipEvent.run
	TrailerToggleTipEvent.run = function (self, connection)
		if not connection.getIsServer(connection) then
			g_server:broadcastEvent(self, false, connection, self.object)
		end

		if self.isStart then
			self.object:onStartTip(self.tipTrigger, self.tipReferencePointIndex, true, self.tipManually)
		else
			self.object:onEndTip(true)
		end

		return 
	end
end

