RotationNodes = {}

function RotationNodes.prerequisitesPresent(specializations)
	return SpecializationUtil.hasSpecialization(Motorized, specializations)
end
function RotationNodes:load(xmlFile)
	self.ProtationNodes = {}
	local i = 0
	while true do
		local key = string.format("vehicle.ProtationNodes.rotationNode(%d)", i)
		if not hasXMLProperty(xmlFile, key) then
			break
		end
		local Pnode = Utils.indexToObject(self.components, getXMLString(xmlFile, key .. "#index"))
		local rotSpeed = math.rad(Utils.getNoNil(getXMLFloat(xmlFile, key .. "#rotSpeed"), 1) * 0.001)
		if Pnode ~= nil then
			table.insert(self.ProtationNodes, {Pnode = Pnode, rotSpeed = rotSpeed, rotation = 0})
		end
		i = i + 1
	end
	self.UrotationNodes = {}
	local i = 0
	while true do
		local key = string.format("vehicle.UrotationNodes.rotationNode(%d)", i)
		if not hasXMLProperty(xmlFile, key) then
			break
		end
		local Unode = Utils.indexToObject(self.components, getXMLString(xmlFile, key .. "#index"))
		local rotSpeed = math.rad(Utils.getNoNil(getXMLFloat(xmlFile, key .. "#rotSpeed"), 1) * 0.001)
		if Unode ~= nil then
			table.insert(self.UrotationNodes, {Unode = Unode, rotSpeed = rotSpeed, rotation = 0})
		end
		i = i + 1
	end	
	self.WrotationNodes = {}
	local i = 0
	while true do
		local key = string.format("vehicle.WrotationNodes.rotationNode(%d)", i)
		if not hasXMLProperty(xmlFile, key) then
			break
		end
		local Wnode = Utils.indexToObject(self.components, getXMLString(xmlFile, key .. "#index"))
		local rotSpeed = math.rad(Utils.getNoNil(getXMLFloat(xmlFile, key .. "#rotSpeed"), 1) * 0.001)
		if Wnode ~= nil then
			table.insert(self.WrotationNodes, {Wnode = Wnode, rotSpeed = rotSpeed, rotation = 0})
		end
		i = i + 1
	end	
end

function RotationNodes:delete()
end

function RotationNodes:mouseEvent(posX, posY, isDown, isUp, button)
end

function RotationNodes:keyEvent(unicode, sym, modifier, isDown)
end

function RotationNodes:update(dt)
end

function RotationNodes:updateTick(dt)
	if self.isMotorStarted then
		for _, Pnode in pairs(self.ProtationNodes) do
			Pnode.rotation = (Pnode.rotation + dt * Pnode.rotSpeed) % (2 * math.pi)
			setRotation(Pnode.Pnode, 0, 0, Pnode.rotation)  --- (Pnode.Pnode, , Y, Z)     
		end	
    end
	    if self.pipeIsUnloading then
			for _, Unode in pairs(self.UrotationNodes) do
				Unode.rotation = (Unode.rotation + dt * Unode.rotSpeed) % (2 * math.pi)
				setRotation(Unode.Unode, Unode.rotation, 0, 0)  ---    (Unode.Unode, , Y, Z)      (  Y -- setRotation(Unode.Unode, 0, Unode.rotation, 0)
			end	
	end				
	    if self:getIsActive() and self.isTurnedOn then
			for _, Wnode in pairs(self.WrotationNodes) do
				Wnode.rotation = (Wnode.rotation + dt * Wnode.rotSpeed) % (2 * math.pi)
				setRotation(Wnode.Wnode, Wnode.rotation, 0, 0)  ---    (Wnode.Wnode, , Y, Z)      (  Y -- setRotation(Wnode.Wnode, 0, Wnode.rotation, 0)
			end	
      end	
end

function RotationNodes:draw()
end
