--
-- @author:  	gEtOvEr@LSSA   edit: werik
-- @version 	v2.4edit
-- @date  	10/10/15

Lock = {};

function Lock.prerequisitesPresent(specializations)
    return true;
end;

function Lock:load(xmlFile)
      self.JointLock = false;
--      self.JointLockNo = self.time;
	self.movingFlag = self:getNextDirtyFlag();
end;

function Lock:readUpdateStream(streamId, timestamp, connection)
	if connection:getIsServer() then
		self.JointLock = streamReadBool(streamId);
	end;
end;

function Lock:writeUpdateStream(streamId, connection, dirtyMask)
	if not connection:getIsServer() then
		streamWriteBool(streamId, self.JointLock);
	end;
end;

function Lock:update(dt)
	local isActive = false;

	local jointDesc = self.componentJoints[1];
	local px, py, pz = getWorldTranslation(jointDesc.jointNode);
	local sx, sy, sz = project(px, py, pz);
	if not self:getIsActiveForInput() then
		if g_currentMission.player ~= nil then
			local pvx, pvy, pvz = getWorldTranslation(g_currentMission.player.rootNode);
			local farmerDistance = Utils.vector3Length(pvx-px, pvy-py, pvz-pz);
			if farmerDistance < 2.3 then
				isActive = true;
				if not self.JointLock then
					g_currentMission:addHelpButtonText(g_i18n:getText("Lock"), InputBinding.Lock);
				else
					g_currentMission:addHelpButtonText(g_i18n:getText("UnLock"), InputBinding.Lock);
				end;
			end;
		end;
	end;

	if isActive then
		if InputBinding.hasEvent(InputBinding.Lock) then
			local x,y,z = getRotation(self.components[1].node);
			local x1,y1,z1 = getRotation(self.components[2].node);
			if math.abs(y - y1) < 0.02 then
			if self.isServer then
				self.JointLock = not self.JointLock;
				self:raiseDirtyFlags(self.movingFlag);
				else
				g_client:getServerConnection():sendEvent(LockEvent:new(1, self));
	end;
			else
			if math.abs(y - y1) > 0.02 then
		if  not self.JointLock then
                           g_currentMission:showBlinkingWarning(g_i18n:getText("NoLock"), 1000);
		else
	        end;
                 end;
            end;
       end;
 end;
				if self.JointLock then
					setJointRotationLimit(self.componentJoints[1].jointIndex, 1, true, 0, 0);
				else
					setJointRotationLimit(self.componentJoints[1].jointIndex, 1, true, math.rad(-104), math.rad(104));
	        end;
end;

function Lock:updateTick()
end;

function Lock:draw()
end;

function Lock:delete()
end;

function Lock:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Lock:keyEvent(unicode, sym, modifier, isDown)
end;

LockEvent = {};
LockEvent_mt = Class(LockEvent, Event);

InitEventClass(LockEvent, "LockEvent");

function LockEvent:emptyNew()
	local self = Event:new(LockEvent_mt);
    return self;
end;

function LockEvent:new(numKey, object)
	local self = LockEvent:emptyNew();
	self.numKey = numKey;
	self.object = object;
	return self;
end;

function LockEvent:readStream(streamId, connection)
	local numKey = streamReadInt8(streamId);
	local id = streamReadInt32(streamId);
    local object = networkGetObject(id);
	if object ~= nil then
		if numKey == 1 then object.JointLock = not object.JointLock; end;
	end;
end;

function LockEvent:writeStream(streamId, connection)
	streamWriteInt8(streamId, self.numKey);
	streamWriteInt32(streamId, networkGetObjectId(self.object));
end;

function Lock:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	if not resetVehicles then
self.JointLock = Utils.getNoNil(getXMLBool(xmlFile, key.."#JointLock"), false);
	end;
	return BaseMission.VEHICLE_LOAD_OK;
end;

function Lock:getSaveAttributesAndNodes(nodeIdent)
	local JointLock = "false";
	if self.JointLock ~= nil and self.JointLock == true then
              JointLock = "true";
end;
	local attributes = 'JointLock="'..JointLock..'"';
	return attributes, nil;
end;

function Lock:validateAttacherJoint(trailerLow, jointDesc, dt)
    return true;
end;