--[[
FuelTrailerOverrides

Specialization to override the FuelTrailer.draw and IngameMap.createMapHotspot functions

Author:		Ifko[nator]
Version:	1.0
Date:		25.03.2015

History:	V 1.0 @ 25.03.2016 - intial release in FS 15
]]

FuelTrailerOverrides = {};

function FuelTrailerOverrides.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(FuelTrailer, specializations);
end;

function FuelTrailerOverrides:preLoad(xmlFile)
	FuelTrailer.draw = Utils.overwrittenFunction(FuelTrailer.draw, FuelTrailerOverrides.drawFuelTrailer);
	IngameMap.createMapHotspot = Utils.overwrittenFunction(IngameMap.createMapHotspot, FuelTrailerOverrides.createMapHotspotIngameMap);
end;

function FuelTrailerOverrides:createMapHotspotIngameMap(createMapHotspot, name, imageFilename, xMapPos, yMapPos, width, height, blinking, persistent, showName, objectId, hidable, renderLast)
	if imageFilename ~= "dataS2/menu/hud/hud_pda_spot_fuelStation.png" then --## dirty hack to stop load the fuel map icon for vehicles wich have this lua
		width = Utils.getNoNil(width, self.defaultHotspotWidth);
		height = Utils.getNoNil(height, self.defaultHotspotHeight);
		
		local mapHotspot = MapHotspot:new(name, imageFilename, xMapPos, yMapPos, width, height, blinking, persistent, showName, objectId, hidable, renderLast);

		table.insert(self.hotspots, mapHotspot);

		return mapHotspot;
	end;
end;

function FuelTrailerOverrides:drawFuelTrailer(draw)
	--## function is empty, to pre event from two 'first fill the tool' texts in the helpbox
end;

--## unused functions

function FuelTrailerOverrides:load(xmlFile)end;
function FuelTrailerOverrides:delete()end;
function FuelTrailerOverrides:mouseEvent(posX, posY, isDown, isUp, button)end;
function FuelTrailerOverrides:keyEvent(unicode, sym, modifier, isDown)end;
function FuelTrailerOverrides:update(dt)end;
function FuelTrailerOverrides:updateTick(dt)end;
function FuelTrailerOverrides:draw()end;