--
-- wheelDirtScale
--
-- author: upsidedown
-- date: 26.12.2013

-- NO RELEASE CANDIDATE!


wheelDirtScale = {};

function wheelDirtScale.prerequisitesPresent(specializations)
	return true; --SpecializationUtil.hasSpecialization(Steerable, specializations);
end;

function wheelDirtScale:load(xmlFile)
	local i=0;
    while true do
        local areaKey = string.format("vehicle.wheelDirtScale.object(%d)", i);
        if not hasXMLProperty(xmlFile, areaKey) then			
            break;
        end
		
        
		local object = Utils.indexToObject(self.components, getXMLString(xmlFile, areaKey .. "#index"));
		local wheelDirt = getXMLInt(xmlFile, areaKey .. "#dirtWheel");
		
		if self.DirtWheels ~= nil then
			if self.DirtWheels[wheelDirt] ~= nil then
				if self.DirtWheels[wheelDirt].scaleObjects == nil then
					self.DirtWheels[wheelDirt].scaleObjects = {};
				end;
				table.insert(self.DirtWheels[wheelDirt].scaleObjects,object);				
			end;
		else
			print("Warning: wheelDirtScale loaded before or without WheelDirtSpecialization!")
		end;
		i=i+1;
	end;
end;

function wheelDirtScale:delete()
	
end;

function wheelDirtScale:mouseEvent(posX, posY, isDown, isUp, button)
end;

function wheelDirtScale:keyEvent(unicode, sym, modifier, isDown)
end;

function wheelDirtScale:update(dt)
end;

function wheelDirtScale:updateTick(dt)
	if self:getIsActive() then
		for k, dirtWheel in pairs(self.DirtWheels) do
			local ratio = dirtWheel.timeOnDirtGround/8000;
			local scale = 0.9+ratio/10;
			if dirtWheel.scaleObjects ~= nil then
				for _,object in pairs(dirtWheel.scaleObjects) do
					setScale(object,scale,scale,scale);
				end;
			end;
		end;
	end;
end;


function wheelDirtScale:draw()
	
end;


function wheelDirtScale:onDeactivate()
	
end;