--
-- universalfederung
--
-- author: upsidedown
-- date: 16.03.2014

-- update auf universalfederung Author: Bayerbua
-- date: 04.06.2015


universalfederung = {};


function universalfederung.prerequisitesPresent(specializations)
	return true; --SpecializationUtil.hasSpecialization(Steerable, specializations);
end;

function universalfederung:load(xmlFile)
	
	self.universalfederung = {};
	local i=0;
    while true do
        local areaKey = string.format("vehicle.universalfederung.part(%d)", i);
        if not hasXMLProperty(xmlFile, areaKey) then			
            break;
        end
		
        local part = {};
		
		part.object = Utils.indexToObject(self.components, getXMLString(xmlFile, areaKey .. "#index"));	
		
		part.x0 = Utils.getNoNil(getXMLFloat(xmlFile, areaKey .. "#x0"),0);
		part.y0 = Utils.getNoNil(getXMLFloat(xmlFile, areaKey .. "#y0"),0);
		part.z0 = Utils.getNoNil(getXMLFloat(xmlFile, areaKey .. "#z0"),0);

		part.damp = getXMLFloat(xmlFile, areaKey .. "#damper")/100;
		part.spring = getXMLFloat(xmlFile, areaKey .. "#spring")/10000;
		
		part.minX = getXMLFloat(xmlFile, areaKey .. "#minX")
		part.maxX = getXMLFloat(xmlFile, areaKey .. "#maxX")
		part.minY = getXMLFloat(xmlFile, areaKey .. "#minY")
		part.maxY = getXMLFloat(xmlFile, areaKey .. "#maxY")
		part.minZ = getXMLFloat(xmlFile, areaKey .. "#minZ")
		part.maxZ = getXMLFloat(xmlFile, areaKey .. "#maxZ")
		
		part.lastV_X = 0;
		part.lastV_Y = 0;
		part.lastV_Z = 0;
		
		i = i + 1;
		self.universalfederung[i] = part;		
    end
	
end;

function universalfederung:delete()
	
end;

function universalfederung:mouseEvent(posX, posY, isDown, isUp, button)
end;

function universalfederung:keyEvent(unicode, sym, modifier, isDown)
end;

function universalfederung:update(dt)
		
end;

function universalfederung:updateTick(dt)
	if self:getIsActive() then		
		for _,part in pairs(self.universalfederung) do			
			local x,y,z = getTranslation(part.object);
			
			local wx,_,_ = getWorldTranslation(part.object);
			if part.lastX == nil then
				part.lastX = wx;
			end;
			
			local dx = wx - part.lastX;
			
			--reset to original coordinates:
			local newX = x - dx;
			
			--lets do some elementary physics:			
			local Fspring = -part.spring*(newX-part.x0);
			local Fdamp = -part.damp*part.lastV_X;
			
			local v = part.lastV_X + (Fspring+Fdamp)*dt
			part.lastV_X = v;
			
			newX = newX + v*dt;
			
			newX = Utils.clamp(newX,part.x0 + part.minX,part.x0 + part.maxX);
			setTranslation(part.object,newX,y,z);
			
			wx,_,_ = getWorldTranslation(part.object);
			part.lastX = wx;
		end;
	end;
	
	if self:getIsActive() then		
		for _,part in pairs(self.universalfederung) do			
			local x,y,z = getTranslation(part.object);
			
			local _,wy,_ = getWorldTranslation(part.object);
			if part.lastY == nil then
				part.lastY = wy;
			end;
			
			local dy = wy - part.lastY;
			
			--reset to original coordinates:
			local newY = y - dy;
			
			--lets do some elementary physics:			
			local Fspring = -part.spring*(newY-part.y0);
			local Fdamp = -part.damp*part.lastV_Y;
			
			local v = part.lastV_Y + (Fspring+Fdamp)*dt
			part.lastV_Y = v;
			
			newY = newY + v*dt;
			
			newY = Utils.clamp(newY,part.y0 + part.minY,part.y0 + part.maxY);
			setTranslation(part.object,x,newY,z);
			
			_,wy,_ = getWorldTranslation(part.object);
			part.lastY = wy;
		end;
	end;
	
	if self:getIsActive() then		
		for _,part in pairs(self.universalfederung) do			
			local x,y,z = getTranslation(part.object);
			
			local _,_,wz = getWorldTranslation(part.object);
			if part.lastZ == nil then
				part.lastZ = wz;
			end;
			
			local dz = wz - part.lastZ;
			
			--reset to original coordinates:
			local newZ = z - dz;
			
			--lets do some elementary physics:			
			local Fspring = -part.spring*(newZ-part.z0);
			local Fdamp = -part.damp*part.lastV_Z;
			
			local v = part.lastV_Z + (Fspring+Fdamp)*dt
			part.lastV_Z = v;
			
			newZ = newZ + v*dt;
			
			newZ = Utils.clamp(newZ,part.z0 + part.minZ,part.z0 + part.maxZ);
			setTranslation(part.object,x,y,newZ);
			
			_,_,wz = getWorldTranslation(part.object);
			part.lastZ = wz;
		end;
	end;
end;


function universalfederung:draw()
	
end;


function universalfederung:onDeactivate()
	
end;