--
-- sprayerApplicationRate
--
-- author: upsidedown
-- date: 22.05.2013
-- update: Bayerbua 07.02.2016
--


sprayerApplicationRate = {};

function sprayerApplicationRate.prerequisitesPresent(specializations)
	return true;
end;

function sprayerApplicationRate:load(xmlFile)
	

	self.sprayerWidth = 0;
	self.liter = 0;	
	self.sprayerHUD  = Overlay:new("Sprayeroverlay", Utils.getFilename("SprayerARHud.dds", self.baseDirectory.."scripts/"),  0.92, 0.057, 0.08, 0.030);
	
	self.AuslegerLI  = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.KotteFass.AuslegerLI#index"));
	self.AuslegerRE  = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.KotteFass.AuslegerRE#index"));
	self.ArmAussenLI = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.KotteFass.ArmAussenLI#index"));
	self.ArmAussenRE = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.KotteFass.ArmAussenRE#index"));
	self.appRate     = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.KotteFass.appRate#index"));
	
end;

function sprayerApplicationRate:delete()
	
end;

function sprayerApplicationRate:mouseEvent(posX, posY, isDown, isUp, button)
end;

function sprayerApplicationRate:keyEvent(unicode, sym, modifier, isDown)
end;

function sprayerApplicationRate:updateTick(dt)
	
end


function sprayerApplicationRate:update(dt)

	if self:getIsActive() then
	
		local lx, ly, lz 	= getRotation(self.AuslegerLI);
		local Alx, Aly, Alz = getRotation(self.ArmAussenLI);
		local rx, ry, rz 	= getRotation(self.AuslegerRE);
		local Arx, Ary, Arz = getRotation(self.ArmAussenRE);
		
		meter = 0;
		-- Berechnung Meter
		if ly == 0 then		
			meter1 = 10.15	--Schleppschlauch grosserArm LI
			liter1 = 50.75			
		else 
			meter1 = 8		-- Sprayer
			liter1 = 40		
		end;
		
		if Alz == 0 then	
			meter2 = 4.85	--Schleppschlauch kleinerArm LI
			liter2 = 24.26
		else
			meter2 = 0
			liter2 = 0
		end;
		
		if ry == 0 then
			meter3 = 10.15	--Schleppschlauch grosserArm RE
			liter3 = 50.75
		else
			meter3 = 8		-- Sprayer
			liter3 = 40		
		end;
	
		if Arz == 0 then	
			meter4 = 4.85	--Schleppschlauch kleinerArm RE
			liter4 =24.26
		else
			meter4 = 0
			liter4 = 0
		end;
		


		self.sprayerWidth = meter1 + meter2 + meter3 + meter4;	--Gesamt meter 30	
		self.liter = liter1 + liter2 + liter3 + liter4; --Gesamt liter/sec 150
		
		local kmh = 0;	
		if self.attacherVehicle ~= nil then
			if self.attacherVehicle.lastSpeed ~= nil and self.attacherVehicle.speedDisplayScale ~= nil then
				kmh = self.attacherVehicle.lastSpeed*self.attacherVehicle.speedDisplayScale*3800;
				if kmh < 0.1 then
					kmh = 0;
				end;
			end;
		end;
		
		
		self.sprayerAppRate = 0.0;
		
		local ax, ay, az 	= getRotation(self.appRate);
		if ay == 0 then		--Fakeeintrag appRate zur Anzeige Ein/Ausschalten
			self.sprayerAppRate = 0.0;
		else 
			self.sprayerAppRate = self.liter*36.0/(kmh*self.sprayerWidth);	
		end;
		
		if self.fillLevel < 1 then
			self.sprayerAppRate = 0.0;
		end;
	end;
end;



function sprayerApplicationRate:draw()
	
	self.sprayerHUD:render();
	setTextAlignment(RenderText.ALIGN_RIGHT); 
	setTextBold(true);
	local r = .8;
	local g = .8;
	local b = .8;
	if self.sprayerAppRate > 0 or self.sprayerAppRate < 0 then
		r = 0.8;
		g = 0;
		b = 0;

		if self.sprayerAppRate > 6 and self.sprayerAppRate < 32 then
			r = 0.8;
			g = .8;
			b = 0;
		end
		if self.sprayerAppRate > 9 and self.sprayerAppRate < 28 then
			r = 0;
			g = .8;
			b = 0;
		end
	end
	
	
	setTextColor(r,g,b,1);
	if self.sprayerAppRate ~= nil then
		renderText(0.958+ 0,0.06 + 0.008,0.012, string.format("%3.1f",self.sprayerAppRate));
	end
	
	setTextAlignment(RenderText.ALIGN_LEFT); 
	setTextBold(false);
	setTextColor(1,1,1,1);
	
end;


function sprayerApplicationRate:onDeactivate()
	
end;