-- 
-- slaveTranslations
--



slaveTranslations = {};

function slaveTranslations.prerequisitesPresent(specializations)
	return true; --SpecializationUtil.hasSpecialization(Steerable, specializations);
end;

function slaveTranslations:load(xmlFile)
	
	self.slaveTranslations = {};
	local i=0;
    while true do
        local areaKey = string.format("vehicle.slaveTranslations.part(%d)", i);
        if not hasXMLProperty(xmlFile, areaKey) then			
            break;
        end
		
        local slaveTranslation = {};
		
		slaveTranslation.master = Utils.indexToObject(self.components, getXMLString(xmlFile, areaKey .. "#master"));
		slaveTranslation.master2 = Utils.indexToObject(self.components, getXMLString(xmlFile, areaKey .. "#master2"));
		slaveTranslation.slave = Utils.indexToObject(self.components, getXMLString(xmlFile, areaKey .. "#slave"));	
		
		local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, areaKey .. "#offset"));
		
		local key_x, key_y, key_z = Utils.getVectorFromString(getXMLString(xmlFile, areaKey .. "#transMap"));
		
		local rat_x, rat_y, rat_z = Utils.getVectorFromString(getXMLString(xmlFile, areaKey .. "#ratio"));
		
		slaveTranslation.offset = {};
		slaveTranslation.offset[1] = Utils.getNoNil(x,0);
		slaveTranslation.offset[2] = Utils.getNoNil(y,0);
		slaveTranslation.offset[3] = Utils.getNoNil(z,0);
		
		slaveTranslation.transMap = {};
		slaveTranslation.transMap[1] = Utils.getNoNil(key_x,1);
		slaveTranslation.transMap[2] = Utils.getNoNil(key_y,2);
		slaveTranslation.transMap[3] = Utils.getNoNil(key_z,3);
		
		slaveTranslation.ratio = {};
		slaveTranslation.ratio[1] = Utils.getNoNil(rat_x,1);
		slaveTranslation.ratio[2] = Utils.getNoNil(rat_y,1);
		slaveTranslation.ratio[3] = Utils.getNoNil(rat_z,1);
				
        i = i + 1;
		self.slaveTranslations[i] = slaveTranslation;		
    end
	--print("slaveTranslations loaded: ",i)
end;

function slaveTranslations:delete()
	
end;

function slaveTranslations:mouseEvent(posX, posY, isDown, isUp, button)
end;

function slaveTranslations:keyEvent(unicode, sym, modifier, isDown)
end;

function slaveTranslations:update(dt)
	if self:getIsActive() then
		for i,slaveTranslation in pairs(self.slaveTranslations) do
			local r_slave = {getTranslation(slaveTranslation.master)};
			if slaveTranslation.master_2 ~= nil then 
				local master2_trans = {getTranslation(slaveTranslation.master2)};
				--print(i,"  ",table.getn(master2_trans))
				for k=1,3 do
					r_slave[k] = (r_slave[k] + master2_trans[k])*0.5;
				end;
			end;
			
			--print(rx," ",ry," ",rz)
			local ox,oy,oz = unpack(slaveTranslation.offset);
			
			local newTrans = {(r_slave[slaveTranslation.transMap[1]]-ox), (r_slave[slaveTranslation.transMap[2]]-oy), (r_slave[slaveTranslation.transMap[3]]-oz)}
			
			setTranslation(slaveTranslation.slave,unpack(newTrans));			
		end;
	end;	
end;

function slaveTranslations:updateTick(dt)
	
end;


function slaveTranslations:draw()
	
end;


function slaveTranslations:onDeactivate()
	
end;