--
-- fillerArmKotteBefueller
-- Specialization for fillerArmKotteBefueller
--
-- @author upsidedown
-- update Bayerbua
-- @date  13.07.2013


fillerArmKotteBefueller = {};

function fillerArmKotteBefueller.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Fillable, specializations);
end;


function fillerArmKotteBefueller:load(xmlFile)
		
		self.getIsPowerTakeoffActive = fillerArmKotteBefueller.getIsPowerTakeoffActive;
		

		local x, y = getScreenModeInfo(getScreenMode())
		local aspectRatio = x / y


		self.fillerArmKotteBefuellerNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.manurefillerArmKotteBefuellerFass#index"));
		--self.fillerArmKotteBefuellerTarget = nil;
		self.fillerArmKotteBefuellerReadyToOverload = false;
		self.fillerArmKotteBefuellerOverloadActive = false;
		self.manschetteKotteBefuellerCloseBy = false;
		self.fillerArmKotteBefuellerBlinkTimer = 0;
		self.fillerArmKotteBefuellerBlinkTimerSign = 1.0;
		
		local hudFactor = 0.95
		local path = Utils.getFilename("overlays/Befuellung_moeglich.dds", self.baseDirectory);
		self.fillerArmKotteBefuellerReadyOverlay = Overlay:new("hudReady", Utils.getFilename("overlays/Befuellung_moeglich.dds", self.baseDirectory),  0.97, 0.18, 0.025, 0.04);
		
		path = Utils.getFilename("overlays/Befuellung_laeuft.dds", self.baseDirectory);
		self.fillerArmKotteBefuellerActiveOverlay = Overlay:new("hudActive", Utils.getFilename("overlays/Befuellung_laeuft.dds", self.baseDirectory),  0.97, 0.18, 0.025, 0.04);
		
		path = Utils.getFilename("overlays/Kontakt.dds", self.baseDirectory);
		self.fillerArmKotteBefuellerContact = Overlay:new("hudActive", Utils.getFilename("overlays/Kontakt.dds", self.baseDirectory),  0.97, 0.18, 0.025, 0.04);
		
		path = Utils.getFilename("overlays/Befuellkreislauf_Blinkend.dds", self.baseDirectory);
		self.fillerArmKotteBefuellerActiveBlinkOverlay = Overlay:new("hudActive", Utils.getFilename("overlays/Befuellkreislauf_Blinkend.dds", self.baseDirectory),  0.97, 0.18, 0.025, 0.04);
		
		-- for anim = 6,10,1 do
				-- self:toggle(anim,false);
		-- end
		
end;

function fillerArmKotteBefueller:update(dt)	
    if self:getIsActiveForInput(true) then
		if self.fillerArmKotteBefuellerReadyToOverload then
			if InputBinding.hasEvent(InputBinding.Filling) then
				self.fillerArmKotteBefuellerOverloadActive = not self.fillerArmKotteBefuellerOverloadActive;
				if g_server ~= nil then
					g_server:broadcastEvent(fillerArmKotteBefuellerOverload_Event:new(self, self.fillerArmKotteBefuellerOverloadActive), nil, nil, self);
				else
					g_client:getServerConnection():sendEvent(fillerArmKotteBefuellerOverload_Event:new(self, self.fillerArmKotteBefuellerOverloadActive));
				end;			
			end;
		end
	end
end;

function fillerArmKotteBefueller:updateTick(dt)	
        self.manschetteKotteBefuellerInRange = false;
		self.manschetteKotteBefuellerCloseBy = false;
        local nearestDistance = 0.5;
        local px, py, pz = getWorldTranslation(self.fillerArmKotteBefuellerNode);
        for i=1, table.getn(g_currentMission.attachables) do
            if g_currentMission.attachables[i].manschetteKotteBefuellerNode2 ~= nil then
				local vx, vy, vz = getWorldTranslation(g_currentMission.attachables[i].manschetteKotteBefuellerNode1);
				local distance = Utils.vector3Length(px-vx, py-vy, pz-vz);
				if distance < nearestDistance then--closer than 0.5m: nearby HUD
					self.manschetteKotteBefuellerCloseBy = true;
					nearestDistance = distance;
				
					if nearestDistance < 0.1 then--within 10cm: contact
						--local attachable = g_currentMission.attachables[i];		
						--renderText(.402+ 0.085,0.5238 + 0.010,0.022, "in range");
						self.manschetteKotteBefuellerInRange = true;
						
						self.manschetteKotteBefueller = {};
						self.manschetteKotteBefueller.vehicle = g_currentMission.attachables[i];
						self.manschetteKotteBefueller.manschetteKotteBefuellerNode = g_currentMission.attachables[i].manschetteKotteBefuellerNode1;					
					end;
				end
			end;
        end;
		
		local delta = 0;
		self.fillerArmKotteBefuellerReadyToOverload = false;
		if self.manschetteKotteBefuellerInRange then
			if self.manschetteKotteBefueller.vehicle.currentFillType == Fillable.FILLTYPE_LIQUIDMANURE then
				if self.capacity ~= self.fillLevel then
					if self.manschetteKotteBefueller.vehicle.fillLevel > 0 then
						self.fillerArmKotteBefuellerReadyToOverload = true;
						if self.fillerArmKotteBefuellerOverloadActive then 
							delta = self.fillLitersPerSecond*dt/100;
							if self.manschetteKotteBefueller.vehicle.fillLevel < delta then
							delta = self.manschetteKotteBefueller.vehicle.fillLevel;
							end
							if self.fillLevel + delta > self.capacity then
								delta = self.capacity - self.fillLevel
							end
						end						
					end
				end
			end
		end
		
		if delta > 0 then
			self:setFillLevel(self.fillLevel + delta,self.manschetteKotteBefueller.vehicle.currentFillType)
			self.manschetteKotteBefueller.vehicle:setFillLevel(self.manschetteKotteBefueller.vehicle.fillLevel - delta,self.manschetteKotteBefueller.vehicle.currentFillType)
		else		    
			self.fillerArmKotteBefuellerOverloadActive = false;
		end
		
		
	
	if self:getIsActive() then
		self.fillerArmKotteBefuellerBlinkTimer = self.fillerArmKotteBefuellerBlinkTimer + self.fillerArmKotteBefuellerBlinkTimerSign*dt;
		if self.fillerArmKotteBefuellerBlinkTimer > 750 then
			self.fillerArmKotteBefuellerBlinkTimerSign = -1.0;
		elseif self.fillerArmKotteBefuellerBlinkTimer < 0 then
			self.fillerArmKotteBefuellerBlinkTimerSign = 1.0;
		end
	end;
	
end;

--function fillerArmKotteBefueller:fertilizerInRange(dt)
--end;

function fillerArmKotteBefueller:delete()
	
end;

function fillerArmKotteBefueller:mouseEvent(posX, posY, isDown, isUp, button)
end;

function fillerArmKotteBefueller:keyEvent(unicode, sym, modifier, isDown)
end;

function fillerArmKotteBefueller:draw()
	if self.manschetteKotteBefuellerCloseBy then
		if self.manschetteKotteBefuellerInRange then

			if self.fillerArmKotteBefuellerReadyToOverload then
				if self.fillerArmKotteBefuellerOverloadActive then
					self.fillerArmKotteBefuellerActiveOverlay:render();
					g_currentMission:addHelpButtonText(g_i18n:getText("fillerArmKotteBefuellerOverload"), InputBinding.Filling);
					if self.fillerArmKotteBefuellerBlinkTimerSign > 0 then
						self.fillerArmKotteBefuellerActiveBlinkOverlay:render();
					end;
					
					
					--g_currentMission:addHelpButtonText(g_i18n:getText("OVERCHARGE_3"), InputBinding.Filling);
				else
					g_currentMission:addHelpButtonText(g_i18n:getText("fillerArmKotteBefuellerOverload"), InputBinding.Filling);
					self.fillerArmKotteBefuellerActiveOverlay:render();
				end;
			else
				self.fillerArmKotteBefuellerContact:render();
			end;
		else
			self.fillerArmKotteBefuellerReadyOverlay:render();
		end;
		
		
	end;
		-- self.fillerArmKotteBefuellerReadyOverlay
		-- self.fillerArmKotteBefuellerActiveOverlay
		-- self.fillerArmKotteBefuellerContact
		-- self.fillerArmKotteBefuellerActiveBlinkOverlay	
end;

function fillerArmKotteBefueller:onAttach()
end; 	

function fillerArmKotteBefueller:onDetach()
end;



function fillerArmKotteBefueller:writeStream(streamId, connection)
    streamWriteBool(streamId, self.fillerArmKotteBefuellerOverloadActive);
	
end;


function fillerArmKotteBefueller:readStream(streamId, connection)
    self.fillerArmKotteBefuellerOverloadActive = streamReadBool(streamId);
   
end;




function fillerArmKotteBefueller:getIsPowerTakeoffActive()
	return self.isTurnedOn or self.fillerArmKotteBefuellerOverloadActive;
end;



fillerArmKotteBefuellerOverload_Event = {};
  fillerArmKotteBefuellerOverload_Event_mt = Class(fillerArmKotteBefuellerOverload_Event, Event);
  
 
  InitEventClass(fillerArmKotteBefuellerOverload_Event, "fillerArmKotteBefuellerOverload_Event");
  
  function fillerArmKotteBefuellerOverload_Event:emptyNew()
      local self = Event:new(fillerArmKotteBefuellerOverload_Event_mt);
      return self;
  end;
  
  function fillerArmKotteBefuellerOverload_Event:new(object, data)
      local self = fillerArmKotteBefuellerOverload_Event:emptyNew()
      self.data = data;
	  
      self.object = object;
      return self;
  end;
  
  function fillerArmKotteBefuellerOverload_Event:readStream(streamId, connection)
      local id = streamReadInt32(streamId);
      self.data = streamReadBool(streamId);
      
	  
	  self.object = networkGetObject(id);
      self:run(connection);
  end;
  
  function fillerArmKotteBefuellerOverload_Event:writeStream(streamId, connection)
      streamWriteInt32(streamId, networkGetObjectId(self.object));
	  streamWriteBool(streamId, self.data);

  end;
  
  function fillerArmKotteBefuellerOverload_Event:run(connection)
	  self.object.fillerArmKotteBefuellerOverloadActive = self.data;
	  
	  
      if not connection:getIsServer() then
          g_server:broadcastEvent(fillerArmKotteBefuellerOverload_Event:new(self.object, self.data), nil, connection, self.object);
      end;
  end;
  