--
-- Schleppschlauch
-- Specialization for Schleppschlauch
--
-- @author Bayerbua
-- @date	16.12.2015
--


Schleppschlauch = {};

function Schleppschlauch.prerequisitesPresent(specializations)
	return SpecializationUtil.hasSpecialization(Sprayer, specializations); 
end;

function Schleppschlauch:load(xmlFile)
	
	-- workAreas
	self.AreaStart = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Schleppschlauch.workAreaStart#index"));
	self.AreaWidth  = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Schleppschlauch.workAreaWidth#index"));
	self.AreaHeight = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Schleppschlauch.workAreaHeight#index"));
		
	self.AuslegerLI = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Schleppschlauch.AuslegerLI#index"));
	self.AuslegerRE = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Schleppschlauch.AuslegerRE#index"));
	self.ArmAussenLI = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Schleppschlauch.ArmAussenLI#index"));
	self.ArmAussenRE = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Schleppschlauch.ArmAussenRE#index"));
-----------------------------------------------------------------------------------------------------------------------------------------------------------------	
	-- AI Marker --
	self.aiLeftMarker  = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Schleppschlauch.aiLeftMarker#index"));
	self.aiRightMarker = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Schleppschlauch.aiRightMarker#index"));
-----------------------------------------------------------------------------------------------------------------------------------------------------------------	
	-- SprayValve fuer Sprayer
	self.SprayerValve = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Schleppschlauch.SprayerValve#index"));
-----------------------------------------------------------------------------------------------------------------------------------------------------------------		
	-- SprayValve fuer Schleppschlauch
	-- Duese_1 bis 9 --
	self.Valve1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Schleppschlauch.Valve1#index"));
	self.Valve2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Schleppschlauch.Valve2#index"));
	self.Valve3 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Schleppschlauch.Valve3#index"));
	self.Valve4 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Schleppschlauch.Valve4#index"));
	self.Valve5 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Schleppschlauch.Valve5#index"));
	self.Valve6 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Schleppschlauch.Valve6#index"));
	self.Valve7 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Schleppschlauch.Valve7#index"));
	self.Valve8 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Schleppschlauch.Valve8#index"));
	self.Valve9 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Schleppschlauch.Valve9#index"));
	
	-- Duese_10 bis 15 --
	self.Valve10 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Schleppschlauch.Valve10#index"));
	self.Valve11 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Schleppschlauch.Valve11#index"));
	self.Valve12 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Schleppschlauch.Valve12#index"));
	self.Valve13 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Schleppschlauch.Valve13#index"));
	self.Valve14 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Schleppschlauch.Valve14#index"));
	self.Valve15 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Schleppschlauch.Valve15#index"));
	self.Valve16 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Schleppschlauch.Valve16#index"));
	
	-- Duese_16 bis 42 --
	self.Valve17 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Schleppschlauch.Valve17#index"));
	self.Valve18 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Schleppschlauch.Valve18#index"));
	self.Valve19 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Schleppschlauch.Valve19#index"));
	self.Valve20 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Schleppschlauch.Valve20#index"));
	self.Valve21 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Schleppschlauch.Valve21#index"));
	self.Valve22 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Schleppschlauch.Valve22#index"));
	self.Valve23 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Schleppschlauch.Valve23#index"));
	self.Valve24 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Schleppschlauch.Valve24#index"));
	self.Valve25 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Schleppschlauch.Valve25#index"));
	self.Valve26 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Schleppschlauch.Valve26#index"));
	self.Valve27 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Schleppschlauch.Valve27#index"));
	self.Valve28 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Schleppschlauch.Valve28#index"));
	self.Valve29 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Schleppschlauch.Valve29#index"));
	self.Valve30 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Schleppschlauch.Valve30#index"));
	self.Valve31 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Schleppschlauch.Valve31#index"));
	self.Valve32 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Schleppschlauch.Valve32#index"));
	self.Valve33 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Schleppschlauch.Valve33#index"));
	self.Valve34 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Schleppschlauch.Valve34#index"));
	self.Valve35 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Schleppschlauch.Valve35#index"));
	self.Valve36 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Schleppschlauch.Valve36#index"));
	self.Valve37 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Schleppschlauch.Valve37#index"));
	self.Valve38 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Schleppschlauch.Valve38#index"));
	self.Valve39 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Schleppschlauch.Valve39#index"));
	self.Valve40 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Schleppschlauch.Valve40#index"));
	self.Valve41 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Schleppschlauch.Valve41#index"));
	self.Valve42 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Schleppschlauch.Valve42#index"));
	
	-- Duese_43 bis 48 --
	self.Valve43 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Schleppschlauch.Valve43#index"));
	self.Valve44 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Schleppschlauch.Valve44#index"));
	self.Valve45 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Schleppschlauch.Valve45#index"));
	self.Valve46 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Schleppschlauch.Valve46#index"));
	self.Valve47 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Schleppschlauch.Valve47#index"));
	self.Valve48 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Schleppschlauch.Valve48#index"));
	
	-- Duese_49 bis 54 --
	self.Valve49 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Schleppschlauch.Valve49#index"));
	self.Valve50 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Schleppschlauch.Valve50#index"));
	self.Valve51 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Schleppschlauch.Valve51#index"));
	self.Valve52 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Schleppschlauch.Valve52#index"));
	self.Valve53 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Schleppschlauch.Valve53#index"));
	self.Valve54 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Schleppschlauch.Valve54#index"));
	
	-- Duese_55 bis 81 --
	self.Valve55 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Schleppschlauch.Valve55#index"));
	self.Valve56 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Schleppschlauch.Valve56#index"));
	self.Valve57 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Schleppschlauch.Valve57#index"));
	self.Valve58 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Schleppschlauch.Valve58#index"));
	self.Valve59 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Schleppschlauch.Valve59#index"));
	self.Valve60 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Schleppschlauch.Valve60#index"));
	self.Valve61 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Schleppschlauch.Valve61#index"));
	self.Valve62 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Schleppschlauch.Valve62#index"));
	self.Valve63 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Schleppschlauch.Valve63#index"));
	self.Valve64 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Schleppschlauch.Valve64#index"));
	self.Valve65 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Schleppschlauch.Valve65#index"));
	self.Valve66 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Schleppschlauch.Valve66#index"));
	self.Valve67 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Schleppschlauch.Valve67#index"));
	self.Valve68 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Schleppschlauch.Valve68#index"));
	self.Valve69 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Schleppschlauch.Valve69#index"));
	self.Valve70 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Schleppschlauch.Valve70#index"));
	self.Valve71 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Schleppschlauch.Valve71#index"));
	self.Valve72 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Schleppschlauch.Valve72#index"));
	self.Valve73 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Schleppschlauch.Valve73#index"));
	self.Valve74 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Schleppschlauch.Valve74#index"));
	self.Valve75 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Schleppschlauch.Valve75#index"));
	self.Valve76 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Schleppschlauch.Valve76#index"));
	self.Valve77 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Schleppschlauch.Valve77#index"));
	self.Valve78 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Schleppschlauch.Valve78#index"));
	self.Valve79 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Schleppschlauch.Valve79#index"));
	self.Valve80 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Schleppschlauch.Valve80#index"));
	self.Valve81 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Schleppschlauch.Valve81#index"));
	
	-- Duese_82 bis 87 --
	self.Valve82 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Schleppschlauch.Valve82#index"));
	self.Valve83 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Schleppschlauch.Valve83#index"));
	self.Valve84 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Schleppschlauch.Valve84#index"));
	self.Valve85 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Schleppschlauch.Valve85#index"));
	self.Valve86 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Schleppschlauch.Valve86#index"));
	self.Valve87 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Schleppschlauch.Valve87#index"));
	
	-- Duese_88 bis 96 --
	self.Valve88 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Schleppschlauch.Valve88#index"));
	self.Valve89 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Schleppschlauch.Valve89#index"));
	self.Valve90 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Schleppschlauch.Valve90#index"));
	self.Valve91 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Schleppschlauch.Valve91#index"));
	self.Valve92 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Schleppschlauch.Valve92#index"));
	self.Valve93 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Schleppschlauch.Valve93#index"));
	self.Valve94 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Schleppschlauch.Valve94#index"));
	self.Valve95 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Schleppschlauch.Valve95#index"));
	self.Valve96 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Schleppschlauch.Valve96#index"));
end;


function Schleppschlauch:update(dt)	
	
	if self:getIsActive() then
		-- SprayValve fuer Sprayer
		setVisibility(self.SprayerValve, true);
		
		-- SprayValve fuer Schleppschlauch
		setVisibility(self.Valve1, false);
		setVisibility(self.Valve2, false);
		setVisibility(self.Valve3, false);
		setVisibility(self.Valve4, false);
		setVisibility(self.Valve5, false);
		setVisibility(self.Valve6, false);
		setVisibility(self.Valve7, false);
		setVisibility(self.Valve8, false);
		setVisibility(self.Valve9, false);
	
		-- Duese_10 bis 15 --
		setVisibility(self.Valve10, false);
		setVisibility(self.Valve11, false);
		setVisibility(self.Valve12, false);
		setVisibility(self.Valve13, false);
		setVisibility(self.Valve14, false);
		setVisibility(self.Valve15, false);
		setVisibility(self.Valve16, false);
	
		-- Duese_16 bis 42 --
		setVisibility(self.Valve17, false);
		setVisibility(self.Valve18, false);
		setVisibility(self.Valve19, false);
		setVisibility(self.Valve20, false);
		setVisibility(self.Valve21, false);
		setVisibility(self.Valve22, false);
		setVisibility(self.Valve23, false);
		setVisibility(self.Valve24, false);
		setVisibility(self.Valve25, false);
		setVisibility(self.Valve26, false);
		setVisibility(self.Valve27, false);
		setVisibility(self.Valve28, false);
		setVisibility(self.Valve29, false);
		setVisibility(self.Valve30, false);
		setVisibility(self.Valve31, false);
		setVisibility(self.Valve32, false);
		setVisibility(self.Valve33, false);
		setVisibility(self.Valve34, false);
		setVisibility(self.Valve35, false);
		setVisibility(self.Valve36, false);
		setVisibility(self.Valve37, false);
		setVisibility(self.Valve38, false);
		setVisibility(self.Valve39, false);
		setVisibility(self.Valve40, false);
		setVisibility(self.Valve41, false);
		setVisibility(self.Valve42, false);
	
		-- Duese_43 bis 48 --
		setVisibility(self.Valve43, false);
		setVisibility(self.Valve44, false);
		setVisibility(self.Valve45, false);
		setVisibility(self.Valve46, false);
		setVisibility(self.Valve47, false);
		setVisibility(self.Valve48, false);
	
		-- Duese_49 bis 54 --
		setVisibility(self.Valve49, false);
		setVisibility(self.Valve50, false);
		setVisibility(self.Valve51, false);
		setVisibility(self.Valve52, false);
		setVisibility(self.Valve53, false);
		setVisibility(self.Valve54, false);
	
		-- Duese_55 bis 81 --
		setVisibility(self.Valve55, false);
		setVisibility(self.Valve56, false);
		setVisibility(self.Valve57, false);
		setVisibility(self.Valve58, false);
		setVisibility(self.Valve59, false);
		setVisibility(self.Valve60, false);
		setVisibility(self.Valve61, false);
		setVisibility(self.Valve62, false);
		setVisibility(self.Valve63, false);
		setVisibility(self.Valve64, false);
		setVisibility(self.Valve65, false);
		setVisibility(self.Valve66, false);
		setVisibility(self.Valve67, false);
		setVisibility(self.Valve68, false);
		setVisibility(self.Valve69, false);
		setVisibility(self.Valve70, false);
		setVisibility(self.Valve71, false);
		setVisibility(self.Valve72, false);
		setVisibility(self.Valve73, false);
		setVisibility(self.Valve74, false);
		setVisibility(self.Valve75, false);
		setVisibility(self.Valve76, false);
		setVisibility(self.Valve77, false);
		setVisibility(self.Valve78, false);
		setVisibility(self.Valve79, false);
		setVisibility(self.Valve80, false);
		setVisibility(self.Valve81, false);
	
		-- Duese_82 bis 87 --
		setVisibility(self.Valve82, false);
		setVisibility(self.Valve83, false);
		setVisibility(self.Valve84, false);
		setVisibility(self.Valve85, false);
		setVisibility(self.Valve86, false);
		setVisibility(self.Valve87, false);
	
		-- Duese_88 bis 96 --
		setVisibility(self.Valve88, false);
		setVisibility(self.Valve89, false);
		setVisibility(self.Valve90, false);
		setVisibility(self.Valve91, false);
		setVisibility(self.Valve92, false);
		setVisibility(self.Valve93, false);
		setVisibility(self.Valve94, false);
		setVisibility(self.Valve95, false);
		setVisibility(self.Valve96, false);
		
		local lx, ly, lz = getRotation(self.AuslegerLI);
		local Alx, Aly, Alz = getRotation(self.ArmAussenLI);
		local rx, ry, rz = getRotation(self.AuslegerRE);
		local Arx, Ary, Arz = getRotation(self.ArmAussenRE);
		
		-- WorkArea Ausleger_LI----------------------------------------------------------
		if ly == 0 then
			setVisibility(self.SprayerValve, false);
			
			-- Duese_16 bis 42 --
			setVisibility(self.Valve17, true);
			setVisibility(self.Valve18, true);
			setVisibility(self.Valve19, true);
			setVisibility(self.Valve20, true);
			setVisibility(self.Valve21, true);
			setVisibility(self.Valve22, true);
			setVisibility(self.Valve23, true);
			setVisibility(self.Valve24, true);
			setVisibility(self.Valve25, true);
			setVisibility(self.Valve26, true);
			setVisibility(self.Valve27, true);
			setVisibility(self.Valve28, true);
			setVisibility(self.Valve29, true);
			setVisibility(self.Valve30, true);
			setVisibility(self.Valve31, true);
			setVisibility(self.Valve32, true);
			setVisibility(self.Valve33, true);
			setVisibility(self.Valve34, true);
			setVisibility(self.Valve35, true);
			setVisibility(self.Valve36, true);
			setVisibility(self.Valve37, true);
			setVisibility(self.Valve38, true);
			setVisibility(self.Valve39, true);
			setVisibility(self.Valve40, true);
			setVisibility(self.Valve41, true);
			setVisibility(self.Valve42, true);
	
			-- Duese_43 bis 48 --
			setVisibility(self.Valve43, true);
			setVisibility(self.Valve44, true);
			setVisibility(self.Valve45, true);
			setVisibility(self.Valve46, true);
			setVisibility(self.Valve47, true);
			setVisibility(self.Valve48, true);
					
			setTranslation(self.AreaStart, 10.15, 0, 0);
			setTranslation(self.AreaHeight, 10.15, 0, -1);
			
			setTranslation(self.aiLeftMarker, 10.15, 0, 0);
			if Alz == 0 then
				-- SprayValve fuer Schleppschlauch
				setVisibility(self.Valve1, true);
				setVisibility(self.Valve2, true);
				setVisibility(self.Valve3, true);
				setVisibility(self.Valve4, true);
				setVisibility(self.Valve5, true);
				setVisibility(self.Valve6, true);
				setVisibility(self.Valve7, true);
				setVisibility(self.Valve8, true);
				setVisibility(self.Valve9, true);
	
				-- Duese_10 bis 15 --
				setVisibility(self.Valve10, true);
				setVisibility(self.Valve11, true);
				setVisibility(self.Valve12, true);
				setVisibility(self.Valve13, true);
				setVisibility(self.Valve14, true);
				setVisibility(self.Valve15, true);
				setVisibility(self.Valve16, true);
			
				setTranslation(self.AreaStart, 15, 0, 0);
				setTranslation(self.AreaHeight, 15, 0, -1);
				
				setTranslation(self.aiLeftMarker, 15, 0, 0);
			else
			-- SprayValve fuer Schleppschlauch
				setVisibility(self.Valve1, false);
				setVisibility(self.Valve2, false);
				setVisibility(self.Valve3, false);
				setVisibility(self.Valve4, false);
				setVisibility(self.Valve5, false);
				setVisibility(self.Valve6, false);
				setVisibility(self.Valve7, false);
				setVisibility(self.Valve8, false);
				setVisibility(self.Valve9, false);
	
				-- Duese_10 bis 15 --
				setVisibility(self.Valve10, false);
				setVisibility(self.Valve11, false);
				setVisibility(self.Valve12, false);
				setVisibility(self.Valve13, false);
				setVisibility(self.Valve14, false);
				setVisibility(self.Valve15, false);
				setVisibility(self.Valve16, false);
				setTranslation(self.AreaStart, 10.15, 0, 0);
				setTranslation(self.AreaHeight, 10.15, 0, -1);
				
				setTranslation(self.aiLeftMarker, 10.15, 0, 0);
			end;
		else
			setTranslation(self.AreaStart, 0, 0, 0);
			setTranslation(self.AreaHeight, 0, 0, -1);
			
			setTranslation(self.aiLeftMarker, 0, 0, 0);
		end;
		
		-- WorkArea Ausleger_RE----------------------------------------------------------
		if ry == 0 then
			setVisibility(self.SprayerValve, false);
			
			-- Duese_49 bis 54 --
			setVisibility(self.Valve49, true);
			setVisibility(self.Valve50, true);
			setVisibility(self.Valve51, true);
			setVisibility(self.Valve52, true);
			setVisibility(self.Valve53, true);
			setVisibility(self.Valve54, true);
	
			-- Duese_55 bis 81 --
			setVisibility(self.Valve55, true);
			setVisibility(self.Valve56, true);
			setVisibility(self.Valve57, true);
			setVisibility(self.Valve58, true);
			setVisibility(self.Valve59, true);
			setVisibility(self.Valve60, true);
			setVisibility(self.Valve61, true);
			setVisibility(self.Valve62, true);
			setVisibility(self.Valve63, true);
			setVisibility(self.Valve64, true);
			setVisibility(self.Valve65, true);
			setVisibility(self.Valve66, true);
			setVisibility(self.Valve67, true);
			setVisibility(self.Valve68, true);
			setVisibility(self.Valve69, true);
			setVisibility(self.Valve70, true);
			setVisibility(self.Valve71, true);
			setVisibility(self.Valve72, true);
			setVisibility(self.Valve73, true);
			setVisibility(self.Valve74, true);
			setVisibility(self.Valve75, true);
			setVisibility(self.Valve76, true);
			setVisibility(self.Valve77, true);
			setVisibility(self.Valve78, true);
			setVisibility(self.Valve79, true);
			setVisibility(self.Valve80, true);
			setVisibility(self.Valve81, true);
			
			setTranslation(self.AreaWidth, -10.15, 0, 0);
			
			setTranslation(self.aiRightMarker, -10.15, 0, 0);
		
			if Arz == 0 then
				-- Duese_82 bis 87 --
				setVisibility(self.Valve82, true);
				setVisibility(self.Valve83, true);
				setVisibility(self.Valve84, true);
				setVisibility(self.Valve85, true);
				setVisibility(self.Valve86, true);
				setVisibility(self.Valve87, true);
	
				-- Duese_88 bis 96 --
				setVisibility(self.Valve88, true);
				setVisibility(self.Valve89, true);
				setVisibility(self.Valve90, true);
				setVisibility(self.Valve91, true);
				setVisibility(self.Valve92, true);
				setVisibility(self.Valve93, true);
				setVisibility(self.Valve94, true);
				setVisibility(self.Valve95, true);
				setVisibility(self.Valve96, true);
				
				setTranslation(self.AreaWidth, -15, 0, 0);
				
				setTranslation(self.aiRightMarker, -15, 0, 0);
			else
				-- Duese_82 bis 87 --
				setVisibility(self.Valve82, false);
				setVisibility(self.Valve83, false);
				setVisibility(self.Valve84, false);
				setVisibility(self.Valve85, false);
				setVisibility(self.Valve86, false);
				setVisibility(self.Valve87, false);
	
				-- Duese_88 bis 96 --
				setVisibility(self.Valve88, false);
				setVisibility(self.Valve89, false);
				setVisibility(self.Valve90, false);
				setVisibility(self.Valve91, false);
				setVisibility(self.Valve92, false);
				setVisibility(self.Valve93, false);
				setVisibility(self.Valve94, false);
				setVisibility(self.Valve95, false);
				setVisibility(self.Valve96, false);
				
				setTranslation(self.AreaWidth, -10.15, 0, 0);
				
				setTranslation(self.aiRightMarker, -10.15, 0, 0);
			end;
		else
			setTranslation(self.AreaWidth, 0, 0, 0);
			
			setTranslation(self.aiRightMarker, 0, 0, 0);
		end;
		
		-- Sprayermodus
		if ly < 0 and ry > 0 then
			setTranslation(self.aiLeftMarker, 8, 0, 0);
			setTranslation(self.aiRightMarker, -8, 0, 0);
			
			setTranslation(self.AreaStart, 8, 0, 0);
			setTranslation(self.AreaHeight, 8, 0, -1);
			setTranslation(self.AreaWidth, -8, 0, 0);
		end;
		
---------------------------------------------------------------------------------------------		
		
		-- Berechnung literPerSecond
		if ly == 0 then			
			liter1 = 50.75;	--Schleppschlauch grosserArm LI		
		else 	
			liter1 = 15;	-- Sprayer
		end;
		
		if Alz == 0 then		
			liter2 = 24.26;	--Schleppschlauch kleinerArm LI
		else
			liter2 = 0;
		end;
		
		if ry == 0 then	
			liter3 = 50.75;	--Schleppschlauch grosserArm RE
		else		
			liter3 = 15;	-- Sprayer
		end;
	
		if Arz == 0 then	
			liter4 = 24.26;	--Schleppschlauch kleinerArm RE
		else
			liter4 = 0;
		end;
		
		liters = liter1 + liter2 + liter3 + liter4; --Gesamt liter/sec 150
		Prozent = 0.9;  --1 ist 100% von liter/sec 150
		
		local fillType = self.attacherVehicle.currentFillType;
		if fillType ~= Fillable.FILLTYPE_UNKNOWN then
			local Rate = liters*Prozent;
			self.sprayLitersPerSecond[fillType] = Rate;
		end; 
		return self;
	end;
end;

function Schleppschlauch:updateTick(dt)	
end;

function Schleppschlauch:delete()
end;

function Schleppschlauch:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Schleppschlauch:keyEvent(unicode, sym, modifier, isDown)
end;

function Schleppschlauch:draw()
end;

