--
-- KotteFass
-- Specialization for KotteFass
--
-- @author mogli
-- @author Bayerbua
-- @date	18.08.2015
--


KotteFass = {};
KotteFass.doDebugPrint = false

Vehicle.registerJointType("KotteSchleppschlauch");


function KotteFass.debugPrint( ... )
	if KotteFass.doDebugPrint then
		print( ... )
	end
end

function KotteFass.prerequisitesPresent(specializations)
	return true
end;

function KotteFass:load(xmlFile)
	self.KotteFass = {}
	self.KotteFass.setHof     = KotteFass.setHof
	self.KotteFass.getHof     = KotteFass.getHof
	self.KotteFass.setStrasse = KotteFass.setStrasse
	self.KotteFass.getStrasse = KotteFass.getStrasse
	self.KotteFass.setFeld    = KotteFass.setFeld
	self.KotteFass.getFeld    = KotteFass.getFeld
	
	self.KotteFass.setEins    = KotteFass.setEins
	self.KotteFass.getEins    = KotteFass.getEins
	self.KotteFass.setZwei    = KotteFass.setZwei
	self.KotteFass.getZwei    = KotteFass.getZwei
	self.KotteFass.setDrei    = KotteFass.setDrei
	self.KotteFass.getDrei    = KotteFass.getDrei
	self.KotteFass.setVier    = KotteFass.setVier
	self.KotteFass.getVier    = KotteFass.getVier
	self.KotteFass.setFuenf   = KotteFass.setFuenf
	self.KotteFass.getFuenf   = KotteFass.getFuenf
	self.KotteFass.setSechs   = KotteFass.setSechs
	self.KotteFass.getSechs   = KotteFass.getSechs
	self.KotteFass.setSieben  = KotteFass.setSieben
	self.KotteFass.getSieben  = KotteFass.getSieben
	self.KotteFass.setAcht    = KotteFass.setAcht
	self.KotteFass.getAcht    = KotteFass.getAcht

	
	self.SchalterHSF						= Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.KotteFass.SchalterHSF#index"));
	self.TasteEins                      	= Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.KotteFass.TasteEins#index"));
	self.TasteZwei                      	= Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.KotteFass.TasteZwei#index"));
	self.TasteDrei                      	= Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.KotteFass.TasteDrei#index"));
	self.TasteVier                      	= Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.KotteFass.TasteVier#index"));
	self.TasteFuenf                      	= Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.KotteFass.TasteFuenf#index"));
	self.TasteSechs                      	= Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.KotteFass.TasteSechs#index"));
	self.TasteSieben                      	= Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.KotteFass.TasteSieben#index"));
	self.TasteAcht                      	= Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.KotteFass.TasteAcht#index"));

	self.Huds_fuer_Startbilder				= Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.KotteFass.Huds_fuer_Startbilder#index"));
	self.Huds_fuer_zusaetzEinstell			= Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.KotteFass.Huds_fuer_zusaetzEinstell#index"));
	
	self.Startbild_Hof_Rahmen_gruen			= Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.KotteFass.Startbild_Hof_Rahmen_gruen#index"));
	self.Startbild_Strasse_Rahmen_schwarz 	= Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.KotteFass.Startbild_Strasse_Rahmen_schwarz#index"));
	self.Startbild_Feld_Rahmen_orange      	= Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.KotteFass.Startbild_Feld_Rahmen_orange#index"));
	
	self.Reifendruckregelanlage_gruen      	= Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.KotteFass.Reifendruckregelanlage_gruen#index"));
	self.Reifendruckregelanlage_schwarz     = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.KotteFass.Reifendruckregelanlage_schwarz#index"));
	self.Reifendruckregelanlage_orange      = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.KotteFass.Reifendruckregelanlage_orange#index"));
	
	self.Rueckfahrkamera_gruen      		= Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.KotteFass.Rueckfahrkamera_gruen#index"));
	self.Rueckfahrkamera_schwarz    	 	= Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.KotteFass.Rueckfahrkamera_schwarz#index"));
	self.Rueckfahrkamera_orange      		= Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.KotteFass.Rueckfahrkamera_orange#index"));
	
	self.Wahlmoeglichkeit_Befuellung_gruen  = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.KotteFass.Wahlmoeglichkeit_Befuellung_gruen#index"));
	self.Wahlmoeglichkeit_Befuellung_orange = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.KotteFass.Wahlmoeglichkeit_Befuellung_orange#index"));
	
	self.Lenkmanagement_MSS_gruen  			= Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.KotteFass.Lenkmanagement_MSS_gruen#index"));
	self.Lenkmanagement_MSS_orange 			= Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.KotteFass.Lenkmanagement_MSS_orange#index"));
	
	self.Allgemeine_Daten_gruen      		= Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.KotteFass.Allgemeine_Daten_gruen#index"));
	self.Allgemeine_Daten_schwarz    	 	= Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.KotteFass.Allgemeine_Daten_schwarz#index"));
	self.Allgemeine_Daten_orange      		= Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.KotteFass.Allgemeine_Daten_orange#index"));
	
	self.Mauseigenschaften_gruen  			= Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.KotteFass.Mauseigenschaften_gruen#index"));
	self.Mauseigenschaften_orange 			= Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.KotteFass.Mauseigenschaften_orange#index"));
	
	self.Zusaetzliche_Einstell_gruen      	= Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.KotteFass.Zusaetzliche_Einstell_gruen#index"));
	self.Zusaetzliche_Einstell_schwarz    	= Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.KotteFass.Zusaetzliche_Einstell_schwarz#index"));
	self.Zusaetzliche_Einstell_orange      	= Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.KotteFass.Zusaetzliche_Einstell_orange#index"));
	
-----------------------------------------------------------------------------------------------------------------------------------------------------------------
	-- SprayValve fuer IC Animation
	self.SprayVAnim 				= Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.KotteFass.SprayVAnim#index"));
	self.SprayVAnimState 			= false
-----------------------------------------------------------------------------------------------------------------------------------------------------------------	
	-- Ampelstellungen für die Startbilder im IC
	self.AmpelRotSSRs 				= Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.KotteFass.AmpelRotSSRs#index"));
	self.AmpelGruenSSRs 			= Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.KotteFass.AmpelGruenSSRs#index"));
	self.AmpelRotSHRg 				= Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.KotteFass.AmpelRotSHRg#index"));
	self.AmpelGruenSHRg 			= Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.KotteFass.AmpelGruenSHRg#index"));
	
	self.AmpelRotSFRo 				= Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.KotteFass.AmpelRotSFRo#index"));
	self.AmpelOrangeSFRo 			= Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.KotteFass.AmpelOrangeSFRo#index"));
	self.AmpelGruenSFRo 			= Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.KotteFass.AmpelGruenSFRo#index"));
-----------------------------------------------------------------------------------------------------------------------------------------------------------------	
	-- Liftachse im IC
	self.RadLaMSSgruen 				= Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.KotteFass.RadLaMSSgruen#index"));
	self.RadLaMSSorange 			= Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.KotteFass.RadLaMSSorange#index"));
	self.ComplexSteeringLiftAxis 	= false
-----------------------------------------------------------------------------------------------------------------------------------------------------------------	

end;
-----------------------------------------------------------------------------
-- Hof Status - Gruen
function KotteFass:getHof()
	local x, y, z = getRotation(self.SchalterHSF);

	if x == not 90 then
		return true;
	else
		return false;
	end;
end;

function KotteFass:setHof( value )
	if value then
		setRotation(self.SchalterHSF, 90, 0, 0);
		setVisibility(self.Startbild_Hof_Rahmen_gruen, true);
		setVisibility(self.Startbild_Strasse_Rahmen_schwarz, false);
		setVisibility(self.Startbild_Feld_Rahmen_orange, false);
		setVisibility(self.Huds_fuer_Startbilder, true);
		setVisibility(self.Huds_fuer_zusaetzEinstell, false);
		
		setVisibility(self.Reifendruckregelanlage_gruen, false);
		setVisibility(self.Reifendruckregelanlage_schwarz, false);
		setVisibility(self.Reifendruckregelanlage_orange, false);
		
		setVisibility(self.Rueckfahrkamera_gruen, false);
		setVisibility(self.Rueckfahrkamera_schwarz, false);
		setVisibility(self.Rueckfahrkamera_orange, false);
		
		setVisibility(self.Wahlmoeglichkeit_Befuellung_gruen, false);
		setVisibility(self.Wahlmoeglichkeit_Befuellung_orange, false);
		
		setVisibility(self.Lenkmanagement_MSS_gruen, false);
		setVisibility(self.Lenkmanagement_MSS_orange, false);
		
		setVisibility(self.Allgemeine_Daten_gruen, false);
		setVisibility(self.Allgemeine_Daten_schwarz, false);
		setVisibility(self.Allgemeine_Daten_orange, false);
		
		setVisibility(self.Mauseigenschaften_gruen, false);
		setVisibility(self.Mauseigenschaften_orange, false);
		
		setVisibility(self.Zusaetzliche_Einstell_gruen, false);
		setVisibility(self.Zusaetzliche_Einstell_schwarz, false);
		setVisibility(self.Zusaetzliche_Einstell_orange, false);
	end;
end;
-----------------------------------------------------------------------------
-- Strasse Status - Schwarz
function KotteFass:getStrasse()
	local x, y, z = getRotation(self.SchalterHSF);

	if x == not 0 then
		return true;
	else
		return false;
	end;
end;

function KotteFass:setStrasse( value )
	if value then
		setRotation(self.SchalterHSF, 0, 0, 0);
		setVisibility(self.Startbild_Hof_Rahmen_gruen, false);
		setVisibility(self.Startbild_Strasse_Rahmen_schwarz, true);
		setVisibility(self.Startbild_Feld_Rahmen_orange, false);
		setVisibility(self.Huds_fuer_Startbilder, true);
		setVisibility(self.Huds_fuer_zusaetzEinstell, false);
		
		setVisibility(self.Reifendruckregelanlage_gruen, false);
		setVisibility(self.Reifendruckregelanlage_schwarz, false);
		setVisibility(self.Reifendruckregelanlage_orange, false);
		
		setVisibility(self.Rueckfahrkamera_gruen, false);
		setVisibility(self.Rueckfahrkamera_schwarz, false);
		setVisibility(self.Rueckfahrkamera_orange, false);
		
		setVisibility(self.Wahlmoeglichkeit_Befuellung_gruen, false);
		setVisibility(self.Wahlmoeglichkeit_Befuellung_orange, false);
		
		setVisibility(self.Lenkmanagement_MSS_gruen, false);
		setVisibility(self.Lenkmanagement_MSS_orange, false);
		
		setVisibility(self.Allgemeine_Daten_gruen, false);
		setVisibility(self.Allgemeine_Daten_schwarz, false);
		setVisibility(self.Allgemeine_Daten_orange, false);
		
		setVisibility(self.Mauseigenschaften_gruen, false);
		setVisibility(self.Mauseigenschaften_orange, false);
		
		setVisibility(self.Zusaetzliche_Einstell_gruen, false);
		setVisibility(self.Zusaetzliche_Einstell_schwarz, false);
		setVisibility(self.Zusaetzliche_Einstell_orange, false);
	end;
end;
-----------------------------------------------------------------------------
-- Feld Status - Orange
function KotteFass:getFeld()
	local x, y, z = getRotation(self.SchalterHSF);

	if x == not -90 then
		return true;
	else
		return false;
	end;
end;

function KotteFass:setFeld( value )
	if value then
		setRotation(self.SchalterHSF, -90, 0, 0);
		setVisibility(self.Startbild_Hof_Rahmen_gruen, false);
		setVisibility(self.Startbild_Strasse_Rahmen_schwarz, false);
		setVisibility(self.Startbild_Feld_Rahmen_orange, true);
		setVisibility(self.Huds_fuer_Startbilder, true);
		setVisibility(self.Huds_fuer_zusaetzEinstell, false);
		
		setVisibility(self.Reifendruckregelanlage_gruen, false);
		setVisibility(self.Reifendruckregelanlage_schwarz, false);
		setVisibility(self.Reifendruckregelanlage_orange, false);
		
		setVisibility(self.Rueckfahrkamera_gruen, false);
		setVisibility(self.Rueckfahrkamera_schwarz, false);
		setVisibility(self.Rueckfahrkamera_orange, false);
		
		setVisibility(self.Wahlmoeglichkeit_Befuellung_gruen, false);
		setVisibility(self.Wahlmoeglichkeit_Befuellung_orange, false);
		
		setVisibility(self.Lenkmanagement_MSS_gruen, false);
		setVisibility(self.Lenkmanagement_MSS_orange, false);
		
		setVisibility(self.Allgemeine_Daten_gruen, false);
		setVisibility(self.Allgemeine_Daten_schwarz, false);
		setVisibility(self.Allgemeine_Daten_orange, false);
		
		setVisibility(self.Mauseigenschaften_gruen, false);
		setVisibility(self.Mauseigenschaften_orange, false);
		
		setVisibility(self.Zusaetzliche_Einstell_gruen, false);
		setVisibility(self.Zusaetzliche_Einstell_schwarz, false);
		setVisibility(self.Zusaetzliche_Einstell_orange, false);
	end;
end;

-----------------------------------------------------------------------------


-- Taste Eins - Reifendruckregelanlage
function KotteFass:getEins()
	local tx, ty, tz = getTranslation(self.TasteEins);
	
	if tx == not 0 then
		return true;
	else
		return false;
	end;
end;

function KotteFass:setEins( value )
	local x, y, z = getRotation(self.SchalterHSF);
	
	-- Bereich Gruen
	if value and x == 90 then
		setVisibility(self.Reifendruckregelanlage_gruen, true);
		setVisibility(self.Startbild_Hof_Rahmen_gruen, false);
		setVisibility(self.Rueckfahrkamera_gruen, false);
		setVisibility(self.Wahlmoeglichkeit_Befuellung_gruen, false);
		setVisibility(self.Allgemeine_Daten_gruen, false);
		setVisibility(self.Mauseigenschaften_gruen, false);	
		setVisibility(self.Zusaetzliche_Einstell_gruen, false);
		setVisibility(self.Huds_fuer_Startbilder, false);
		setVisibility(self.Huds_fuer_zusaetzEinstell, false);	
	end;
	-- Bereich Schwarz
	if value and x == 0 then
		setVisibility(self.Reifendruckregelanlage_schwarz, true);
		setVisibility(self.Startbild_Strasse_Rahmen_schwarz, false);
		setVisibility(self.Rueckfahrkamera_schwarz, false);
		setVisibility(self.Lenkmanagement_MSS_gruen, false);
		setVisibility(self.Allgemeine_Daten_schwarz, false);
		setVisibility(self.Zusaetzliche_Einstell_schwarz, false);
		setVisibility(self.Huds_fuer_Startbilder, false);
		setVisibility(self.Huds_fuer_zusaetzEinstell, false);	
	end;
	-- Bereich Orange
	if value and x == -90 then
		setVisibility(self.Reifendruckregelanlage_orange, true);
		setVisibility(self.Startbild_Feld_Rahmen_orange, false);
		setVisibility(self.Rueckfahrkamera_orange, false);
		setVisibility(self.Wahlmoeglichkeit_Befuellung_orange, false);
		setVisibility(self.Lenkmanagement_MSS_orange, false);
		setVisibility(self.Allgemeine_Daten_orange, false);
		setVisibility(self.Mauseigenschaften_orange, false);
		setVisibility(self.Zusaetzliche_Einstell_orange, false);
		setVisibility(self.Huds_fuer_Startbilder, false);
		setVisibility(self.Huds_fuer_zusaetzEinstell, false);	
	end;
end;

-----------------------------------------------------------------------------

-- Taste Zwei - Rückfahrkamera
function KotteFass:getZwei()
	local tx, ty, tz = getTranslation(self.TasteZwei);
	
	if tx == not 0 then
		return true;
	else
		return false;
	end;
end;

function KotteFass:setZwei( value )
	local x, y, z = getRotation(self.SchalterHSF);
	
	-- Bereich Gruen
	if value and x == 90 then
		setVisibility(self.Rueckfahrkamera_gruen, true);
		setVisibility(self.Startbild_Hof_Rahmen_gruen, false);
		setVisibility(self.Reifendruckregelanlage_gruen, false);
		setVisibility(self.Wahlmoeglichkeit_Befuellung_gruen, false);
		setVisibility(self.Lenkmanagement_MSS_gruen, false);
		setVisibility(self.Allgemeine_Daten_gruen, false);
		setVisibility(self.Mauseigenschaften_gruen, false);
		setVisibility(self.Zusaetzliche_Einstell_gruen, false);
		setVisibility(self.Huds_fuer_Startbilder, false);
		setVisibility(self.Huds_fuer_zusaetzEinstell, false);	
	end;
	-- Bereich Schwarz
	if value and x == 0 then
		setVisibility(self.Rueckfahrkamera_schwarz, true);
		setVisibility(self.Startbild_Strasse_Rahmen_schwarz, false);
		setVisibility(self.Reifendruckregelanlage_schwarz, false);
		setVisibility(self.Allgemeine_Daten_schwarz, false);
		setVisibility(self.Zusaetzliche_Einstell_schwarz, false);
		setVisibility(self.Huds_fuer_Startbilder, false);
		setVisibility(self.Huds_fuer_zusaetzEinstell, false);	
	end;
	-- Bereich Orange
	if value and x == -90 then
		setVisibility(self.Rueckfahrkamera_orange, true);
		setVisibility(self.Startbild_Feld_Rahmen_orange, false);
		setVisibility(self.Reifendruckregelanlage_orange, false);
		setVisibility(self.Wahlmoeglichkeit_Befuellung_orange, false);
		setVisibility(self.Lenkmanagement_MSS_orange, false);
		setVisibility(self.Allgemeine_Daten_orange, false);
		setVisibility(self.Mauseigenschaften_orange, false);
		setVisibility(self.Zusaetzliche_Einstell_orange, false);
		setVisibility(self.Huds_fuer_Startbilder, false);
		setVisibility(self.Huds_fuer_zusaetzEinstell, false);	
	end;
end;

-----------------------------------------------------------------------------

-- Taste Drei - Wahlmoeglichkeit_Befuellung
function KotteFass:getDrei()
	local tx, ty, tz = getTranslation(self.TasteDrei);
	
	if tx == not 0 then
		return true;
	else
		return false;
	end;
end;

function KotteFass:setDrei( value )
	local x, y, z = getRotation(self.SchalterHSF);
	
	-- Bereich Gruen
	if value and x == 90 then
		setVisibility(self.Wahlmoeglichkeit_Befuellung_gruen, true);
		setVisibility(self.Startbild_Hof_Rahmen_gruen, false);
		setVisibility(self.Reifendruckregelanlage_gruen, false);
		setVisibility(self.Rueckfahrkamera_gruen, false);
		setVisibility(self.Lenkmanagement_MSS_gruen, false);
		setVisibility(self.Allgemeine_Daten_gruen, false);
		setVisibility(self.Mauseigenschaften_gruen, false);
		setVisibility(self.Zusaetzliche_Einstell_gruen, false);
		setVisibility(self.Huds_fuer_Startbilder, false);	
		setVisibility(self.Huds_fuer_zusaetzEinstell, false);	
	end;
	-- Bereich Schwarz
	if value and x == 0 then
	end;
	-- Bereich Orange
	if value and x == -90 then
		setVisibility(self.Wahlmoeglichkeit_Befuellung_orange, true);
		setVisibility(self.Startbild_Feld_Rahmen_orange, false);
		setVisibility(self.Reifendruckregelanlage_orange, false);
		setVisibility(self.Rueckfahrkamera_orange, false);
		setVisibility(self.Lenkmanagement_MSS_orange, false);
		setVisibility(self.Allgemeine_Daten_orange, false);
		setVisibility(self.Mauseigenschaften_orange, false);
		setVisibility(self.Zusaetzliche_Einstell_orange, false);
		setVisibility(self.Huds_fuer_Startbilder, false);
		setVisibility(self.Huds_fuer_zusaetzEinstell, false);	
	end;
end;

-----------------------------------------------------------------------------

-- Taste Vier - Lenkmanagement_MSS
function KotteFass:getVier()
	local tx, ty, tz = getTranslation(self.TasteVier);
	
	if tx == not 0 then
		return true;
	else
		return false;
	end;
end;

function KotteFass:setVier( value )
	local x, y, z = getRotation(self.SchalterHSF);
	
	-- Bereich Gruen
	if value and x == 90 then
		setVisibility(self.Lenkmanagement_MSS_gruen, true);
		setVisibility(self.Wahlmoeglichkeit_Befuellung_gruen, false);
		setVisibility(self.Startbild_Hof_Rahmen_gruen, false);
		setVisibility(self.Reifendruckregelanlage_gruen, false);
		setVisibility(self.Rueckfahrkamera_gruen, false);
		setVisibility(self.Allgemeine_Daten_gruen, false);
		setVisibility(self.Mauseigenschaften_gruen, false);	
		setVisibility(self.Zusaetzliche_Einstell_gruen, false);
		setVisibility(self.Huds_fuer_Startbilder, false);
		setVisibility(self.Huds_fuer_zusaetzEinstell, false);	
	end;
	-- Bereich Schwarz
	if value and x == 0 then
	end;
	-- Bereich Orange
	if value and x == -90 then
		setVisibility(self.Lenkmanagement_MSS_orange, true);
		setVisibility(self.Wahlmoeglichkeit_Befuellung_orange, false);
		setVisibility(self.Startbild_Feld_Rahmen_orange, false);
		setVisibility(self.Reifendruckregelanlage_orange, false);
		setVisibility(self.Rueckfahrkamera_orange, false);
		setVisibility(self.Allgemeine_Daten_orange, false);
		setVisibility(self.Mauseigenschaften_orange, false);
		setVisibility(self.Zusaetzliche_Einstell_orange, false);
		setVisibility(self.Huds_fuer_Startbilder, false);
		setVisibility(self.Huds_fuer_zusaetzEinstell, false);	
	end;
end;

-----------------------------------------------------------------------------

-- Taste Fuenf - Allgemeine_Daten
function KotteFass:getFuenf()
	local tx, ty, tz = getTranslation(self.TasteFuenf);
	
	if tx == not 0 then
		return true;
	else
		return false;
	end;
end;

function KotteFass:setFuenf( value )
	local x, y, z = getRotation(self.SchalterHSF);
	
	-- Bereich Gruen
	if value and x == 90 then
		setVisibility(self.Allgemeine_Daten_gruen, true);
		setVisibility(self.Rueckfahrkamera_gruen, false);
		setVisibility(self.Startbild_Hof_Rahmen_gruen, false);
		setVisibility(self.Reifendruckregelanlage_gruen, false);
		setVisibility(self.Wahlmoeglichkeit_Befuellung_gruen, false);
		setVisibility(self.Lenkmanagement_MSS_gruen, false);
		setVisibility(self.Mauseigenschaften_gruen, false);
		setVisibility(self.Zusaetzliche_Einstell_gruen, false);	
		setVisibility(self.Huds_fuer_Startbilder, false);
		setVisibility(self.Huds_fuer_zusaetzEinstell, false);	
	end;
	-- Bereich Schwarz
	if value and x == 0 then
		setVisibility(self.Allgemeine_Daten_schwarz, true);
		setVisibility(self.Rueckfahrkamera_schwarz, false);
		setVisibility(self.Startbild_Strasse_Rahmen_schwarz, false);
		setVisibility(self.Reifendruckregelanlage_schwarz, false);
		setVisibility(self.Zusaetzliche_Einstell_schwarz, false);
		setVisibility(self.Huds_fuer_Startbilder, false);
		setVisibility(self.Huds_fuer_zusaetzEinstell, false);	
	end;
	-- Bereich Orange
	if value and x == -90 then
		setVisibility(self.Allgemeine_Daten_orange, true);
		setVisibility(self.Rueckfahrkamera_orange, false);
		setVisibility(self.Startbild_Feld_Rahmen_orange, false);
		setVisibility(self.Reifendruckregelanlage_orange, false);
		setVisibility(self.Wahlmoeglichkeit_Befuellung_orange, false);
		setVisibility(self.Lenkmanagement_MSS_orange, false);
		setVisibility(self.Mauseigenschaften_orange, false);
		setVisibility(self.Zusaetzliche_Einstell_orange, false);
		setVisibility(self.Huds_fuer_Startbilder, false);	
		setVisibility(self.Huds_fuer_zusaetzEinstell, false);	
	end;
end;

-----------------------------------------------------------------------------

-- Taste Sechs - Mauseigenschaften
function KotteFass:getSechs()
	local tx, ty, tz = getTranslation(self.TasteSechs);
	
	if tx == not 0 then
		return true;
	else
		return false;
	end;
end;

function KotteFass:setSechs( value )
	local x, y, z = getRotation(self.SchalterHSF);
	
	-- Bereich Gruen
	if value and x == 90 then
		setVisibility(self.Mauseigenschaften_gruen, true);
		setVisibility(self.Allgemeine_Daten_gruen, false);
		setVisibility(self.Rueckfahrkamera_gruen, false);
		setVisibility(self.Startbild_Hof_Rahmen_gruen, false);
		setVisibility(self.Reifendruckregelanlage_gruen, false);
		setVisibility(self.Wahlmoeglichkeit_Befuellung_gruen, false);
		setVisibility(self.Lenkmanagement_MSS_gruen, false);
		setVisibility(self.Zusaetzliche_Einstell_gruen, false);	
		setVisibility(self.Huds_fuer_Startbilder, false);
		setVisibility(self.Huds_fuer_zusaetzEinstell, false);	
	end;
	-- Bereich Schwarz
	if value and x == 0 then
	end;
	-- Bereich Orange
	if value and x == -90 then
		setVisibility(self.Mauseigenschaften_orange, true);
		setVisibility(self.Allgemeine_Daten_orange, false);
		setVisibility(self.Rueckfahrkamera_orange, false);
		setVisibility(self.Startbild_Feld_Rahmen_orange, false);
		setVisibility(self.Reifendruckregelanlage_orange, false);
		setVisibility(self.Wahlmoeglichkeit_Befuellung_orange, false);
		setVisibility(self.Lenkmanagement_MSS_orange, false);
		setVisibility(self.Zusaetzliche_Einstell_orange, false);
		setVisibility(self.Huds_fuer_Startbilder, false);	
		setVisibility(self.Huds_fuer_zusaetzEinstell, false);	
	end;
end;

-----------------------------------------------------------------------------

-- Taste Sieben - Zusaetzliche_Einstell
function KotteFass:getSieben()
	local tx, ty, tz = getTranslation(self.TasteSieben);
	
	if tx == not 0 then
		return true;
	else
		return false;
	end;
end;

function KotteFass:setSieben( value )
	local x, y, z = getRotation(self.SchalterHSF);
	
	-- Bereich Gruen
	if value and x == 90 then
		setVisibility(self.Zusaetzliche_Einstell_gruen, true);
		setVisibility(self.Mauseigenschaften_gruen, false);
		setVisibility(self.Allgemeine_Daten_gruen, false);
		setVisibility(self.Rueckfahrkamera_gruen, false);
		setVisibility(self.Startbild_Hof_Rahmen_gruen, false);
		setVisibility(self.Reifendruckregelanlage_gruen, false);
		setVisibility(self.Wahlmoeglichkeit_Befuellung_gruen, false);
		setVisibility(self.Lenkmanagement_MSS_gruen, false);
		setVisibility(self.Huds_fuer_Startbilder, false);
		setVisibility(self.Huds_fuer_zusaetzEinstell, true);
	end;
	-- Bereich Schwarz
	if value and x == 0 then
		setVisibility(self.Zusaetzliche_Einstell_schwarz, true);
		setVisibility(self.Allgemeine_Daten_schwarz, false);
		setVisibility(self.Rueckfahrkamera_schwarz, false);
		setVisibility(self.Startbild_Strasse_Rahmen_schwarz, false);
		setVisibility(self.Reifendruckregelanlage_schwarz, false);
		setVisibility(self.Huds_fuer_Startbilder, false);
		setVisibility(self.Huds_fuer_zusaetzEinstell, true);	
	end;
	-- Bereich Orange
	if value and x == -90 then
		setVisibility(self.Zusaetzliche_Einstell_orange, true);
		setVisibility(self.Mauseigenschaften_orange, false);
		setVisibility(self.Allgemeine_Daten_orange, false);
		setVisibility(self.Rueckfahrkamera_orange, false);
		setVisibility(self.Startbild_Feld_Rahmen_orange, false);
		setVisibility(self.Reifendruckregelanlage_orange, false);
		setVisibility(self.Wahlmoeglichkeit_Befuellung_orange, false);
		setVisibility(self.Lenkmanagement_MSS_orange, false);
		setVisibility(self.Huds_fuer_Startbilder, false);
		setVisibility(self.Huds_fuer_zusaetzEinstell, true);	
	end;
end;

-----------------------------------------------------------------------------

-- Taste Acht - Return zu Startbilder
function KotteFass:getAcht()
	local tx, ty, tz = getTranslation(self.TasteAcht);
	
	if tx == not 0 then
		return true;
	else
		return false;
	end;
end;

function KotteFass:setAcht( value )
	local x, y, z = getRotation(self.SchalterHSF);
	
	-- Bereich Gruen
	if value and x == 90 then
		setVisibility(self.Startbild_Hof_Rahmen_gruen, true);
		setVisibility(self.Reifendruckregelanlage_gruen, false);
		setVisibility(self.Rueckfahrkamera_gruen, false);
		setVisibility(self.Wahlmoeglichkeit_Befuellung_gruen, false);
		setVisibility(self.Lenkmanagement_MSS_gruen, false);
		setVisibility(self.Allgemeine_Daten_gruen, false);
		setVisibility(self.Mauseigenschaften_gruen, false);
		setVisibility(self.Zusaetzliche_Einstell_gruen, false);
		setVisibility(self.Huds_fuer_Startbilder, true);
		setVisibility(self.Huds_fuer_zusaetzEinstell, false);	
	end;
	-- Bereich Schwarz
	if value and x == 0 then
		setVisibility(self.Startbild_Strasse_Rahmen_schwarz, true);	
		setVisibility(self.Reifendruckregelanlage_schwarz, false);
		setVisibility(self.Rueckfahrkamera_schwarz, false);
		setVisibility(self.Allgemeine_Daten_schwarz, false);
		setVisibility(self.Zusaetzliche_Einstell_schwarz, false);
		setVisibility(self.Huds_fuer_Startbilder, true);
		setVisibility(self.Huds_fuer_zusaetzEinstell, false);	
	end;
	-- Bereich Orange
	if value and x == -90 then
		setVisibility(self.Startbild_Feld_Rahmen_orange, true);
		setVisibility(self.Reifendruckregelanlage_orange, false);
		setVisibility(self.Rueckfahrkamera_orange, false);
		setVisibility(self.Wahlmoeglichkeit_Befuellung_orange, false);
		setVisibility(self.Lenkmanagement_MSS_orange, false);
		setVisibility(self.Allgemeine_Daten_orange, false);
		setVisibility(self.Mauseigenschaften_orange, false);
		setVisibility(self.Zusaetzliche_Einstell_orange, false);
		setVisibility(self.Huds_fuer_Startbilder, true);	
		setVisibility(self.Huds_fuer_zusaetzEinstell, false);
	end;
end;
-----------------------------------------------------------------------------


function KotteFass:update(dt)

	-- IC Ampelstellungen für die Startbilder im IC
	if self:getIsActive() then
		if self.fillLevel > 0 then
			setVisibility(self.AmpelRotSSRs, false);
			setVisibility(self.AmpelGruenSSRs, true);
			setVisibility(self.AmpelRotSHRg, false);
			setVisibility(self.AmpelGruenSHRg, true);
			setVisibility(self.AmpelRotSFRo, false);
			setVisibility(self.AmpelGruenSFRo, true);
		else
			setVisibility(self.AmpelRotSSRs, true);
			setVisibility(self.AmpelGruenSSRs, false);
			setVisibility(self.AmpelRotSHRg, true);
			setVisibility(self.AmpelGruenSHRg, false);
			setVisibility(self.AmpelRotSFRo, true);
			setVisibility(self.AmpelGruenSFRo, false);			
		end;
		if self.fillLevel < 500 then
			setVisibility(self.AmpelOrangeSFRo, true);
			rotate(self.AmpelOrangeSFRo, 0,0*dt,-0.1);
		else
			setVisibility(self.AmpelOrangeSFRo, false);
		end;
	end;

	-- SprayValve fuer IC Animation
	if self:getIsActiveForInput()then
		if InputBinding.hasEvent(InputBinding.Duengung) then
			self.SprayVAnimState = (not self.SprayVAnimState);
		end;
		if self.SprayVAnimState == true and self.fillLevel > 0 then
			setVisibility(self.SprayVAnim, true);
			rotate(self.SprayVAnim, 0,0*dt,-0.1);
		elseif
			self.fillLevel < 1 then
			setVisibility(self.SprayVAnim, false);
		else
			setVisibility(self.SprayVAnim, false);
		end;
	end;
		
	-- Liftachse im IC
	if self:getIsActiveForInput()then
		if InputBinding.hasEvent(InputBinding.ComplexSteeringLiftAxis) then
			self.ComplexSteeringLiftAxis = (not self.ComplexSteeringLiftAxis);
		end;
		local ax, ay, az = getTranslation(self.RadLaMSSgruen);
		local bx, by, bz = getTranslation(self.RadLaMSSorange);
	
		if self.complexSteeringTrailer.liftMode < 2 then
			setTranslation(self.RadLaMSSgruen, ax, 0.038, az);
			setTranslation(self.RadLaMSSorange, bx, 0.038, bz);

		else
			setTranslation(self.RadLaMSSgruen, ax, 0.034, az);
			setTranslation(self.RadLaMSSorange, bx, 0.034, bz);
		end;
	end;
end;


function KotteFass:updateTick(dt)
	
end;

function KotteFass:delete()
end;

function KotteFass:mouseEvent(posX, posY, isDown, isUp, button)
end;

function KotteFass:keyEvent(unicode, sym, modifier, isDown)
end;

function KotteFass:draw()
end;

