--
-- InteractiveWindows
-- Specialization for InteractiveWindows
--
-- @author  	Manuel Leithner (SFM-Modding)
-- @version 	v4.0
-- @date  		24/10/12
-- @history:	v1.0 - Initial version
--				v2.0 - converted to ls2011
--				v3.0 - converted to ls2013
--				v4.0 - by Mogli: several improvements
--
-- free for noncommerical-usage
--

InteractiveWindows = InteractiveControlBase.newSpecialization();

function InteractiveWindows.prerequisitesPresent(specializations)
    return InteractiveControlBase.prerequisitesPresent(specializations) and SpecializationUtil.hasSpecialization(AnimatedVehicle, specializations);
end;

function InteractiveWindows:load(xmlFile)
	local i=0;
	while true do
		local xmlName = string.format("vehicle.interactiveComponents.windows.window(%d)", i);	
		if not hasXMLProperty(xmlFile, xmlName) then
			break;
		end;
		local animation = getXMLString(xmlFile, xmlName .. "#animName");
		local event     = getXMLString(xmlFile, xmlName .. "#event");
		local setter    = getXMLString(xmlFile, xmlName .. "#setFunction");
		local getter    = getXMLString(xmlFile, xmlName .. "#getFunction");

		local window = Window:new(self, xmlFile, xmlName, animation, event, setter, getter);
		table.insert(self.interactiveObjects, window);
		i = i + 1;
	end;
end;



--
-- Window Class
-- Specifies an interactive window
--
-- SFM-Modding
-- @author  Manuel Leithner
-- @date  26/12/09
--

Window = {};

function Window:new(vehicle, xmlFile, xmlName, animation, event, setter, getter)

	local Window_mt = Class(Window, InteractiveComponentInterface);	
  local instance = InteractiveComponentInterface:new(vehicle, xmlFile, xmlName, Window_mt, event, setter, getter);
	instance.vehicle = vehicle;
	instance.animation = animation;
	Window.doAction( instance, true, instance.isOpen )
	return instance;
end;

function Window:update(dt)
	if     self.skipGetState then
		self.skipGetState = nil
	elseif self.vehicle ~= nil and type( self.getStateFunction ) == "function" then
		local newState = self.getStateFunction( self.vehicle )
		if ( self.isOpen and not ( newState ) ) or ( newState and not ( self.isOpen ) ) then
			Window.setState(self, true, newState)
		end
	end;
	InteractiveComponentInterface.update(self, dt);
end;

function Window:doAction(noEventSend, forceValue)
	Window.setState(self, noEventSend, forceValue)
	if self.vehicle ~= nil and type( self.setStateFunction ) == "function" then
		self.setStateFunction( self.vehicle, self.isOpen );
	end
	self.skipGetState = true
end;

function Window:setState(noEventSend, forceValue)
	InteractiveComponentInterface.doAction(self, noEventSend, forceValue);
	local dir = 1;
	if not self.isOpen  then
		dir = -1;
	end;
	self.vehicle:playAnimation(self.animation, dir, Utils.clamp(self.vehicle:getAnimationTime(self.animation), 0, 1), true);
end;

function Window:getSaveAttributes()
	if self.isOpen then
		return "isOpen=\""..tostring(self.isOpen).."\""
	end
	return ""
end

function Window:setSaveAttributes(xmlFile, xmlName)
	local isOpen = getXMLBool(xmlFile, xmlName .. "#isOpen")
	if isOpen ~= nil then
		Window.doAction(self, true, isOpen)
	end
end
