Einblendung = {};

function Einblendung.prerequisitesPresent(specializations)
    return true;
end;
function Einblendung:load(xmlFile)

	self.setblends1Visibility = SpecializationUtil.callSpecializationsFunction("setblends1Visibility");
	
      self.blends1 = {};
      local i = 0;
      while true do
          local key = string.format("vehicle.blends1.blend1(%d)", i);
          if not hasXMLProperty(xmlFile, key) then
              break;
          end;
          local node = Utils.indexToObject(self.components, getXMLString(xmlFile, key.."#index"));
		  local visStart = Utils.getNoNil(getXMLBool(xmlFile, key.."#visStart"),false);
          if node ~= nil then
              setVisibility(node, visStart);
              table.insert(self.blends1, {node=node});
          end;
          i = i + 1;
      end;
end;
function Einblendung:delete()
end;
function Einblendung:readStream(streamId, connection)
	self.isLoading = true;
	local visibility = streamReadBool(streamId);
	self:setblends1Visibility(visibility, true);
end;

function Einblendung:writeStream(streamId, connection)
	streamWriteBool(streamId, self.blends1Active);
end;
function Einblendung:mouseEvent(posX, posY, isDown, isUp, button)
end;
function Einblendung:keyEvent(unicode, sym, modifier, isDown)
end;
function Einblendung:update(dt)

      if self:getIsActiveForInput() and self.isClient then
          if InputBinding.hasEvent(InputBinding.EinblendungEins) then
              self:setblends1Visibility(not self.blends1Active);
          end;
	end;
end;
function Einblendung:onLeave()
end;
function Einblendung:draw()
end;
function Einblendung:setblends1Visibility(visibility, noEventSend)
      if visibility ~= self.blends1Active then
  
          if noEventSend == nil or noEventSend == false then
              if g_server ~= nil then
                  g_server:broadcastEvent(Setblends1Event:new(self, visibility), nil, nil, self);
              else
                  g_client:getServerConnection():sendEvent(Setblends1Event:new(self, visibility));
              end;
          end;
  
          self.blends1Active = visibility;
  
          for _, blend1 in pairs(self.blends1) do
             setVisibility(blend1.node, visibility);
          end;
          for _,v in pairs(self.specializations) do
              if v.setblend1Visibility ~= nil then
                 v.setblend1Visibility(self, visibility);
              end;
          end;
      end;
end;


