--
-- KirovetsK700A
-- Specialization for KirovetsK700A
--
-- @author  	Manuel Leithner (SFM-Modding)
-- @version 	v2.0
-- @date  		15/10/10
-- @history:	v1.0 - Initial version
--				v2.0 - added network support, changed update to updateTick
--

KirovetsK700A = {};

function KirovetsK700A.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(ArticulatedAxis, specializations);
end;

function KirovetsK700A:load(xmlFile)
	local shaftCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.drivingPowerShafts#count"), 0);
    self.drivingPowerShafts = {};
    for i=1, shaftCount do
		local shaft = {};
        local shaftName = string.format("vehicle.drivingPowerShafts.powerShaft%d", i);
		shaft.node = Utils.indexToObject(self.components, getXMLString(xmlFile, shaftName .. "#index"));		
		shaft.trans = Utils.getNoNil(getXMLFloat(xmlFile, shaftName .. "#translation"), 0);
		local x,y,z = getTranslation(getParent(shaft.node));
		shaft.orgTrans = {x,y,z};
		shaft.rot = Utils.degToRad(Utils.getNoNil(getXMLFloat(xmlFile, shaftName .. "#rotation"), 0));	
		shaft.speedFactor = Utils.getNoNil(getXMLFloat(xmlFile, shaftName .. "#speedFactor"), 2);
		table.insert(self.drivingPowerShafts, shaft);        
    end;
	
    if not self.isServer then
		self.articulatedAxis = {};
		self.articulatedAxis.rotSpeed = math.rad(getXMLFloat(xmlFile, "vehicle.articulatedAxis#rotSpeed"));
		self.articulatedAxis.rotMax = math.rad(getXMLFloat(xmlFile, "vehicle.articulatedAxis#rotMax"));
		self.articulatedAxis.rotMin = math.rad(getXMLFloat(xmlFile, "vehicle.articulatedAxis#rotMin"));
    end;
end;

function KirovetsK700A:delete()
end;

function KirovetsK700A:readStream(streamId, connection)
end;

function KirovetsK700A:writeStream(streamId, connection)
end;

function KirovetsK700A:mouseEvent(posX, posY, isDown, isUp, button)
end;

function KirovetsK700A:keyEvent(unicode, sym, modifier, isDown)
end;

function KirovetsK700A:update(dt)
end;

function KirovetsK700A:updateTick(dt)

	if self:getIsActive() then
		local steeringAngle;
		if self.isServer then
			steeringAngle = self.articulatedAxis.curRot;
		else
			steeringAngle = self.rotatedTime * self.articulatedAxis.rotSpeed;
			if steeringAngle > self.articulatedAxis.rotMax then
				steeringAngle = self.articulatedAxis.rotMax;
			elseif steeringAngle < self.articulatedAxis.rotMin then
				steeringAngle = self.articulatedAxis.rotMin;
			end;
		end;
	
		for _, shaft in pairs(self.drivingPowerShafts) do
			local x,y,z = getRotation(self.wheels[1].driveNode);
			setRotation(shaft.node, 0 ,0, x*shaft.speedFactor);

			if shaft.trans ~= 0 then
				local newTrans = shaft.trans * steeringAngle/self.articulatedAxis.rotMax;
				local x,y,z = unpack(shaft.orgTrans);
				setTranslation(getParent(shaft.node), x + newTrans,y,z);
			end;
			if shaft.rot ~= 0 then
				newRot = shaft.rot * steeringAngle/self.articulatedAxis.rotMax;
				setRotation(getParent(shaft.node), 0, newRot, 0);
			end;			
		end;		
	end;
end;

function KirovetsK700A:draw()	
end;