-- xyzspain

terragatorSpreader = {};

function terragatorSpreader.prerequisitesPresent(specializations)
  -- return SpecializationUtil.hasSpecialization(Motorized, specializations);
 
   return true;
end;

function terragatorSpreader:load(xmlFile)
-- desplazamiento de conjuntos
	self.setHydraulicDirection = SpecializationUtil.callSpecializationsFunction("setHydraulicDirection");
	
	local hydraulicsCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.hydraulics#count"), 0);	
	self.hydraulics = {};	
	for i=1, hydraulicsCount do
		local hydraulicName = string.format("vehicle.hydraulics.hydraulic%d", i);		
		self.hydraulics[i] = {};		
		self.hydraulics[i].node = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#index"));
		self.hydraulics[i].punch = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#punch"));
		self.hydraulics[i].translationPunch = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#punchFixpoint"));
		self.hydraulics[i].fixPoint = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#fixpoint"));	
		local ax, ay, az;		
		if self.hydraulics[i].punch ~= nil then
			ax, ay, az = getWorldTranslation(self.hydraulics[i].punch);
		else
			ax, ay, az = getWorldTranslation(self.hydraulics[i].node);
		end;
		local bx, by, bz = getWorldTranslation(self.hydraulics[i].translationPunch);		
		self.hydraulics[i].punchDistance = Utils.vector3Length(ax-bx, ay-by, az-bz);
		self.hydraulics[i].doScale = Utils.getNoNil(getXMLBool(xmlFile, hydraulicName .. "#doScale"), false);
	end;
	-------------------
	 self.keys = {};
    local i=0;
    while true do
        local baseName = string.format("vehicle.keys.input(%d)", i);
        local inputName = getXMLString(xmlFile, baseName.. "#name");
        if inputName == nil then
            break;
        end;
        local inputKey = getXMLString(xmlFile, baseName.. "#key");
        if Input[inputKey] == nil then
            print("Error: invalid key '" .. inputKey .. "'  for input event '" .. inputName .. "'");
            break;
        end;
        self.keys[inputName] = Input[inputKey];
        i = i+1;
    end;
	
			-------------------------
		---------flashlights
	self.FlashLightLeft = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.indexl#index"));
    self.FlashLightRight = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.indexr#index"));	 
	
	
	
	
    self.flashLightLeftActive = false;
    self.flashLightRightActive = false;
    self.flash = false;
    self.flashRight = false;
    self.flashLeft = false;
    self.delayOnLeft = 0;
    self.delayOffLeft = 0;
    self.delayOnRight = 0;
    self.delayOffRight = 0;
    self.delayOn = 0;
    self.delayOff = 0;
   
    turnSoundFile = Utils.getFilename("sounds/turn.wav", self.baseDirectory);
    self.turnSoundId = createSample("turnSound");
    loadSample(self.turnSoundId, turnSoundFile, false);
	-------------------
	---brake light and sound
	self.lightsbrake = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.brake#index"));

	self.braking = false;
	local brakeSound = getXMLString(xmlFile, "vehicle.brakeSound#file");
    if brakeSound ~= nil and brakeSound ~= "" then
	brakeSound = Utils.getFilename(brakeSound, self.baseDirectory);
        self.brakeSound = createSample("brakeSound");
        loadSample(self.brakeSound, brakeSound, false);
    end;
	

	
	-------------	cardans------
	self.numCardans = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.cardans#count"), 0); 
	self.cardans = {}; 
 for i=1, self.numCardans do 
     local partnamei = string.format("vehicle.cardans.part" .. "%d", i); 
     self.cardans[i] = {}; 
     self.cardans[i].index = Utils.indexToObject(self.components, getXMLString(xmlFile, partnamei.."#index")); 
   
 end;
			---emision de particulas ruedas

self.wheelParticleSystems = {};
    local psFile = getXMLString(xmlFile, "vehicle.wheelParticleSystems#file");
    if psFile ~= nil then
        local i=0;
        while true do
            local baseName = string.format("vehicle.wheelParticleSystems.wheelParticleSystem(%d)", i);
            local node = getXMLString(xmlFile, baseName.. "#node");
            if node == nil then
                break;
            end;
            node = Utils.indexToObject(self.components, node);
			self.wheelParticleSystems.node = node;
            if node ~= nil then
                local wheelParticleSystem = {};
                wheelParticleSystem.particleSystems = {};
                Utils.loadParticleSystem(xmlFile, wheelParticleSystem.particleSystems, "vehicle.wheelParticleSystems", node, false, nil, self.baseDirectory);
                table.insert(self.wheelParticleSystems, wheelParticleSystem);
            end;
            i = i+1;
        end;
    end;
---------------------------
		 local rotationPartNodeLeftDoor = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotationPartLeftDoor#index"));
    if rotationPartNodeLeftDoor ~= nil then
        self.rotationPartLeftDoor = {};
        self.rotationPartLeftDoor.node = rotationPartNodeLeftDoor;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartLeftDoor#minRot"));
        self.rotationPartLeftDoor.minRot = {};
        self.rotationPartLeftDoor.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartLeftDoor.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartLeftDoor.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartLeftDoor#maxRot"));
        self.rotationPartLeftDoor.maxRot = {};
        self.rotationPartLeftDoor.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartLeftDoor.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartLeftDoor.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartLeftDoor.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartLeftDoor#rotTime"), 2)*1000;
        self.rotationPartLeftDoor.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartLeftDoor#touchRotLimit"), 10));
    end;
	
	local rotationPartNodeBrake = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotationPartBrake#index"));
    if rotationPartNodeBrake ~= nil then
        self.rotationPartBrake = {};
        self.rotationPartBrake.node = rotationPartNodeBrake;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartBrake#minRot"));
        self.rotationPartBrake.minRot = {};
        self.rotationPartBrake.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartBrake.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartBrake.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartBrake#maxRot"));
        self.rotationPartBrake.maxRot = {};
        self.rotationPartBrake.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartBrake.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartBrake.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartBrake.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartBrake#rotTime"), 2)*1000;
        self.rotationPartBrake.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartBrake#touchRotLimit"), 10));
    end;
	
	local rotationPartNodeClucth = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotationPartClucth#index"));
    if rotationPartNodeClucth ~= nil then
        self.rotationPartClucth = {};
        self.rotationPartClucth.node = rotationPartNodeClucth;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartClucth#minRot"));
        self.rotationPartClucth.minRot = {};
        self.rotationPartClucth.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartClucth.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartClucth.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartClucth#maxRot"));
        self.rotationPartClucth.maxRot = {};
        self.rotationPartClucth.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartClucth.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartClucth.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartClucth.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartClucth#rotTime"), 2)*1000;
        self.rotationPartClucth.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartClucth#touchRotLimit"), 10));
    end;
	
	---------------mirros with activation 
	local mirrorLeftNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.mirrorLeft#index"));
        self.mirrorLeft = {};
          self.mirrorLeft.node = mirrorLeftNode;


	local mirrorLeft1Node = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.mirrorLeft1#index"));
        self.mirrorLeft1 = {};
          self.mirrorLeft1.node = mirrorLeft1Node;

	local mirrorRightNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.mirrorRight#index"));
        self.mirrorRight = {};
          self.mirrorRight.node = mirrorRightNode;
	
	local mirrorRight1Node = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.mirrorRight1#index"));
        self.mirrorRight1 = {};
          self.mirrorRight1.node = mirrorRight1Node;
	
	local headSupportNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.headSupport#index"));
        self.headSupport = {};
          self.headSupport.node = headSupportNode;
local count = getXMLInt(xmlFile, "vehicle.rotationParts#count");
	if count ~= nil then
		self.rotationParts = {}
		local rotationPart = self.rotationParts;
		for i=1, count do
			local varName = string.format("rotationPart" .. "%d", i);
			rotationPart[varName] = {};
			local rotationPartname = string.format("vehicle.rotationParts.rotationPart" .. "%d", i);
			rotationPart[varName].index = Utils.indexToObject(self.components, getXMLString(xmlFile, rotationPartname .. "#index"));
			local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, rotationPartname .. "#minRot"));
			rotationPart[varName].minRot = {};
			rotationPart[varName].minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
			rotationPart[varName].minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
			rotationPart[varName].minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
			local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, rotationPartname .. "#maxRot"));
			rotationPart[varName].maxRot = {};
			rotationPart[varName].maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
			rotationPart[varName].maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
			rotationPart[varName].maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

			rotationPart[varName].rotTime = Utils.getNoNil(getXMLInt(xmlFile, rotationPartname .. "#rotTime"), 2)*1000;	
			rotationPart[varName].touchRotLimit = Utils.getNoNil(getXMLInt(xmlFile, rotationPartname .. "#touchRotLimit"), 1)/1000;	
		end;
	end;
	
	self.indoorCamIndex = 2;
	self.outdoorCamIndex = 1;
	--------------------
	-------------WIPER
	local rotationPartNodeWischer = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartWischer#index"));
    if rotationPartNodeWischer ~= nil then
        self.rotationPartWischer = {};
        self.rotationPartWischer.node = rotationPartNodeWischer;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartWischer#minRot"));
        self.rotationPartWischer.minRot = {};
        self.rotationPartWischer.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartWischer.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartWischer.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartWischer#maxRot"));
        self.rotationPartWischer.maxRot = {};
        self.rotationPartWischer.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartWischer.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartWischer.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartWischer.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartWischer#rotTime"), 2)*1000;
        self.rotationPartWischer.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartWischer#touchRotLimit"), 10));
    end;
	
	local rotationPartNodeWischerblatt = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartWischerblatt#index"));
    if rotationPartNodeWischerblatt ~= nil then
        self.rotationPartWischerblatt = {};
        self.rotationPartWischerblatt.node = rotationPartNodeWischerblatt;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartWischerblatt#minRot"));
        self.rotationPartWischerblatt.minRot = {};
        self.rotationPartWischerblatt.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartWischerblatt.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartWischerblatt.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartWischerblatt#maxRot"));
        self.rotationPartWischerblatt.maxRot = {};
        self.rotationPartWischerblatt.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartWischerblatt.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartWischerblatt.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartWischerblatt.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartWischerblatt#rotTime"), 2)*1000;
        self.rotationPartWischerblatt.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartWischerblatt#touchRotLimit"), 10));
    end;
	local rotationPartNodeWischer1 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartWischer1#index"));
    if rotationPartNodeWischer1 ~= nil then
        self.rotationPartWischer1 = {};
        self.rotationPartWischer1.node = rotationPartNodeWischer1;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartWischer1#minRot"));
        self.rotationPartWischer1.minRot = {};
        self.rotationPartWischer1.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartWischer1.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartWischer1.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartWischer1#maxRot"));
        self.rotationPartWischer1.maxRot = {};
        self.rotationPartWischer1.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartWischer1.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartWischer1.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartWischer1.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartWischer1#rotTime"), 2)*1000;
        self.rotationPartWischer1.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartWischer1#touchRotLimit"), 10));
    end;
	  self.delayWischer1 = 0;
		self.delayWischer2 = 0;
		
	self.controlpath = Utils.getFilename("assets/menu.dds", self.baseDirectory);
   
    
    self.hudTerragatorSpreaderWidth = 0.526;
    self.hudTerragatorSpreaderHeight = 0.320;
    self.hudTerragatorSpreaderPoxX = 0;
    self.hudTerragatorSpreaderPoxY = 0;
    self.hudTerragatorSpreaderOverlay = Overlay:new("hudTerragatorSpreader", self.controlpath, self.hudTerragatorSpreaderPoxX, self.hudTerragatorSpreaderPoxY, self.hudTerragatorSpreaderWidth, self.hudTerragatorSpreaderHeight);
     self.bcActive = false;
	
	-------------------	
--[[	self.sprayParticleSystems = {}; --ps1
    local sprayParticleSystemCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.sprayParticleSystems#count"), 0);
    for i=1, sprayParticleSystemCount do
        local namei = string.format("vehicle.sprayParticleSystems.part%d", i);
		local nodei = Utils.indexToObject(self.components, getXMLString(xmlFile, namei .. "#index"));
        Utils.loadParticleSystem(xmlFile, self.sprayParticleSystems, namei, nodei, false, nil, self.baseDirectory)			
    end;
	self.extraParticles=false;--]]
	
end;

function terragatorSpreader:delete()
    if self.brakePlaying ~= nil then
        stopSample(self.brakeSoundId);
    end;
    if self.hudRogatorSprayerOverlay ~= nil then
        self.hudRogatorSprayerOverlay:delete();
    end;
    for _, entry in ipairs(self.wheelParticleSystems) do
        Utils.deleteParticleSystem(entry.particleSystems);
        entry.isActive = false;
    end;
    
end;

function terragatorSpreader:mouseEvent(posX, posY, isDown, isUp, button)
end;


function terragatorSpreader:onLeave()
  self.flashLightRightActive = false;
	self.flashLightLeftActive = false;
	setVisibility(self.FlashLightRight, false);
	setVisibility(self.FlashLightLeft, false);
	setVisibility(self.lightsbrake, false);
	self.extraParticles=false;
	--[[Utils.setEmittingState(self.sprayParticleSystems, false)--]]
end;
function terragatorSpreader:onEnter()
	self.flashLightRightActive = false;
	self.flashLightLeftActive = false;
	setVisibility(self.FlashLightRight, false);
	setVisibility(self.FlashLightLeft, false);
	setVisibility(self.lightsbrake, false);
	self.extraParticles=false;
	--[[Utils.setEmittingState(self.sprayParticleSystems, false)--]]
	
end;
function terragatorSpreader:keyEvent(unicode, sym, modifier, isDown)
 
end;
function terragatorSpreader:update(dt)
	
if self:getIsActive() then 
	


	
	
---flashlights
	
	if InputBinding.hasEvent (InputBinding.FLASH_LEFT)  then
		self.flashLeft = not self.flashLeft;
		self.delayOnLeft = 10;
		self.flashRight = false;
		self.flash = false;
		self.flashLightRightActive = false;
	end;

	if InputBinding.hasEvent (InputBinding.FLASH_RIGHT)  then
		self.flashRight = not self.flashRight;
		self.delayOnRight = 10;
		self.flashLeft = false;
		self.flash = false;
		self.flashLightLeftActive = false;
	end;
	if InputBinding.hasEvent (InputBinding.WARNINGS) then
		self.flash = not self.flash;
		self.flashRight = false;
		self.flashLeft = false;
		self.delayOn = 20;
		self.flashLightRightActive = false;
		self.flashLightLeftActive = false;
	end;
	
	if self.FlashLightLeft ~= nil then
            if self.flashLightLeftActive then
            	setVisibility(self.FlashLightLeft, self.flashLightLeftActive);
			
	    else
            	setVisibility(self.FlashLightLeft, self.flashLightLeftActive);
			
	    end;
        end;

	if self.FlashLightRight ~= nil then
            if self.FlashLightRightActive then
            	setVisibility(self.FlashLightRight, self.flashLightRightActive);
				
	    else
            	setVisibility(self.FlashLightRight, self.flashLightRightActive);
				
	    end;
        end;

	if self.flashLeft then
		if self.delayOnLeft >= -1 then
			self.delayOnLeft = self.delayOnLeft -dt;
		end;
		if not self.flashLightLeftActive then
			if self.delayOnLeft < 0 then
				self.delayOffLeft = 200;
				self.flashLightLeftActive = true;
				playSample(self.turnSoundId, 1, 0.7, 0);
			end;
		end;
		if self.delayOffLeft >= 0 then
			self.delayOffLeft = self.delayOffLeft -dt;
		end;
		if self.flashLightLeftActive then
			if self.delayOffLeft < 0 then
				self.delayOnLeft = 200;
				self.flashLightLeftActive = false;
			end;
		end;
	end;

	if self.flashRight then
		if self.delayOnRight >= 0 then
			self.delayOnRight = self.delayOnRight -dt;
		end;
		if not self.flashLightRightActive then
			if self.delayOnRight < 0 then
				self.delayOffRight = 200;
				self.flashLightRightActive = true;
				playSample(self.turnSoundId, 1, 0.7, 0);
			end;
		end;
		if self.delayOffRight >= 0 then
			self.delayOffRight = self.delayOffRight -dt;
		end;
		if self.flashLightRightActive then
			if self.delayOffRight < 0 then
				self.delayOnRight = 200;
				self.flashLightRightActive = false;
			end;
		end;
	end;

	if self.flash then
		if self.delayOn >= 0 then
			self.delayOn = self.delayOn -dt;
		end;
		if not self.flashLightRightActive then
			if self.delayOn < 0 then
				self.delayOff = 200;
				self.flashLightRightActive = true;
				self.flashLightLeftActive = true;
				playSample(self.turnSoundId, 1, 0.7, 0);
			end;
		end;
		if self.delayOff >= 0 then
			self.delayOff = self.delayOff -dt;
		end;
		if self.flashLightRightActive then
			if self.delayOff < 0 then
				self.delayOn = 200;
				self.flashLightLeftActive = false;
				self.flashLightRightActive = false;
			end;
		end;
	end;

	if not self.flashLeft and not self.flashRight then
		if not self.flash then
			self.flashLightRightActive = false;
			self.flashLightLeftActive = false;
		end;
	end;
		
	if not self.flash and not self.flashLeft then
		if not self.flashRight then
			self.flashLightRightActive = false;
		end;
	end;

	if not self.flash and not self.flashRight then
		if not self.flashLeft then
			self.flashLightLeftActive = false;
		end;
	end;
	
	
	--------------------brake------------------------
   inputAxis_2 = InputBinding.getAnalogInputAxis(InputBinding.AXIS_MOVE_FORWARD_VEHICLE);

        if InputBinding.isAxisZero(inputAxisY) then
        inputAxis_2 = InputBinding.getDigitalInputAxis(InputBinding.AXIS_MOVE_FORWARD_VEHICLE);
        end;
	
		if (self.movingDirection*self.lastSpeed*(-inputAxis_2)) < -0.001 then
			setVisibility(self.lightsbrake, true);
			
			-- if not self.brakeSoundRunning then
					-- playSample(self.brakeSound, 1, 1, 0);
					-- self.brakeSoundRunning = true;
					
				-- end;
			self.braking = true;
			
			self.rotationMaxBrake=true;
		else
		     setVisibility(self.lightsbrake, false);
			self.rotationMaxBrake=false;
	
			self.braking = false;
			self.brakeSoundRunning = false;	
		
		end;
-----  cardans ----
		local zRot = (self.lastSpeed*self.movingDirection*1000)/2
				for i=1, self.numCardans do 
				rotate(self.cardans[i].index,0, 0, zRot);
				end; 
	---particulas ruedas

	local dens = 0; local dens1; local dens2; local dens3;
		 local x,y,z = getWorldTranslation(self.wheels[1].repr);
		 local x1,y1,z1 = getWorldTranslation(self.wheels[2].repr);
		 local x2,y2,z2 = getWorldTranslation(self.wheels[3].repr);
		local id = g_currentMission.terrainDetailId;
		local xx, zz, widthX, widthZ, heightX, heightZ = Utils.getXZWidthAndHeight(id, x, z, x1, z1, x2, z2);
		dens1 = getDensityParallelogram(id, xx, zz, widthX, widthZ, heightX, heightZ, g_currentMission.cultivatorChannel, 1);
		dens2 = getDensityParallelogram(id, xx, zz, widthX, widthZ, heightX, heightZ, g_currentMission.sowingChannel, 1);
		dens3 = getDensityParallelogram(id, xx, zz, widthX, widthZ, heightX, heightZ, g_currentMission.ploughChannel, 1);
		if g_currentMission.environment.lastRainScale <= 0.1 and g_currentMission.environment.timeSinceLastRain > 30 then
			dens = dens1+dens2+dens3;
		end;
		if dens > 0 and self.lastSpeed*self.speedDisplayScale*3600 > 4 then
			
			
			for k=1, 3 do
				Utils.setEmittingState(self.wheelParticleSystems[k].particleSystems, self.wheels[k].hasGroundContact);
			end;
		else
			for i=1, table.getn(self.wheelParticleSystems) do
				Utils.setEmittingState(self.wheelParticleSystems[i].particleSystems, false);
			end;
		
		end;	
			if InputBinding.hasEvent (InputBinding.INFOHUD) then
				self.bcActive = not self.bcActive;
			end;
		--------left door
	
	if InputBinding.isPressed (InputBinding.LEFT_DOOR) and InputBinding.isPressed(InputBinding.ACTIVATION) then
		self.rotationMaxLeftDoor = not self.rotationMaxLeftDoor;	
	end;	
	--- clucth
	if InputBinding.isPressed (InputBinding.SPEED_LEVEL1) or InputBinding.isPressed(InputBinding.SPEED_LEVEL2) or InputBinding.isPressed(InputBinding.SPEED_LEVEL3) or InputBinding.isPressed(InputBinding.SPEED_LEVEL4) then
		self.rotationMaxClucth=true;
	else
		self.rotationMaxClucth=false;
	end;

-----------------mirrors
			if InputBinding.isPressed (InputBinding.MIRRORS_UP) and InputBinding.isPressed(InputBinding.ACTIVATION_MIRRORS) then
				self.down=not self.down;
			end;
			if InputBinding.isPressed (InputBinding.MIRRORS_DOWN) and InputBinding.isPressed(InputBinding.ACTIVATION_MIRRORS) then
				self.up=not self.up;
			end;
			if InputBinding.isPressed (InputBinding.MIRRORS_LEFT) and InputBinding.isPressed(InputBinding.ACTIVATION_MIRRORS) then
				self.left=not self.left;
			end;
			if InputBinding.isPressed (InputBinding.MIRRORS_RIGHT) and InputBinding.isPressed(InputBinding.ACTIVATION_MIRRORS) then
				self.right=not self.right;
			end;
			if InputBinding.isPressed (InputBinding.MIRRORS_LEFT1) and InputBinding.isPressed(InputBinding.ACTIVATION_MIRRORS) then
				self.left1=not self.left1;
			end;
			if InputBinding.isPressed (InputBinding.MIRRORS_RIGHT1) and InputBinding.isPressed(InputBinding.ACTIVATION_MIRRORS) then
				self.right1=not self.right1;
			end;
	
			-- if InputBinding.isPressed (InputBinding.MIRRORS_ON) and InputBinding.isPressed(InputBinding.ACTIVATION_MIRRORS) then
				-- self.mirror=not self.mirror;
			-- end;
	if self.camIndex == self.indoorCamIndex or self.camIndex == self.outdoorCamIndex then
				local indoorCam = self.cameras[self.indoorCamIndex];
				local outdoorCam = self.cameras[self.outdoorCamIndex];
		if self.camIndex == self.indoorCamIndex then
		self.mirror=true
		elseif self.camIndex == self.outdoorCamIndex then
		self.mirror=false
		end;
		
			setVisibility(self.mirrorLeft.node, self.mirror);
			setVisibility(self.mirrorRight.node, self.mirror);
			setVisibility(self.mirrorLeft1.node, self.mirror);
			setVisibility(self.mirrorRight1.node, self.mirror);
			setVisibility(self.headSupport.node, not self.mirror);
	end;
	
	---- wiper
	if g_currentMission.environment.lastRainScale <= 0.1 and g_currentMission.environment.timeSinceLastRain > 30 then
			self.rainWarning = false;
		else
			self.rainWarning = true;
		end;
		
		if self.rainWarning and self.isMotorStarted then
			if self.delayWischer1 >= 0 then
				self.delayWischer1 = self.delayWischer1 -dt;
			end;
			if self.delayWischer2 >= 0 then
				self.delayWischer2 = self.delayWischer2 -dt;
			end;
			if not self.rotationMaxWischer then
				if self.delayWischer1 < 0 then
					self.delayWischer2 = 1000;
					self.rotationMaxWischer = true;
					self.rotationMaxWischer1 = true;
					self.rotationMaxWischerblatt = true;
				end;
			end;
			if self.rotationMaxWischer then
				if self.delayWischer2 < 0 then
					self.delayWischer1 = 1000;
					self.rotationMaxWischer = false;
					self.rotationMaxWischer1 = false;
					self.rotationMaxWischerblatt = false;
				end;
			end;
		else
			self.rotationMaxWischer = false;
			self.rotationMaxWischer1 = false;
			self.rotationMaxWischerblatt = false;
		end;
				---particulas
		
--[[		if self.fillLevel~=0 then
		-- renderText(0.1, 0.20, 0.03," fillLevel ok ");
		
			if InputBinding.hasEvent (InputBinding.IMPLEMENT_EXTRA)  then
			self.extraParticles = not self.extraParticles;	
			end;
			if self.extraParticles then 
				Utils.setEmittingState(self.sprayParticleSystems, true)
					-- renderText(0.1, 0.10, 0.03," true ");
			elseif not self.extraParticles  then
				Utils.setEmittingState(self.sprayParticleSystems, false)
					-- renderText(0.1, 0.10, 0.03," false ");
			end;
		elseif  self.fillLevel==0 then
			Utils.setEmittingState(self.sprayParticleSystems, false)
			-- renderText(0.1, 0.20, 0.03," fillLevel no ");
		end;--]]
	
end;-----active

	if self.rotationPartWischer ~= nil then
		local x, y, z = getRotation(self.rotationPartWischer.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartWischer.maxRot, self.rotationPartWischer.minRot, 3, self.rotationPartWischer.rotTime, dt, not self.rotationMaxWischer);
		setRotation(self.rotationPartWischer.node, unpack(newRot));
	end;  
    if self.rotationPartWischerblatt ~= nil then
		local x, y, z = getRotation(self.rotationPartWischerblatt.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartWischerblatt.maxRot, self.rotationPartWischerblatt.minRot, 3, self.rotationPartWischerblatt.rotTime, dt, not self.rotationMaxWischerblatt);
		setRotation(self.rotationPartWischerblatt.node, unpack(newRot));
	end;
	if self.rotationPartWischer1 ~= nil then
		local x, y, z = getRotation(self.rotationPartWischer1.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartWischer1.maxRot, self.rotationPartWischer1.minRot, 3, self.rotationPartWischer1.rotTime, dt, not self.rotationMaxWischer1);
		setRotation(self.rotationPartWischer1.node, unpack(newRot));
	end;  

		if self.down then
			local rotationPart = self.rotationParts.rotationPart5;
			local rot = {getRotation(rotationPart.index)};
			local newRot = Utils.getMovedLimitedValues(rot, rotationPart.maxRot, rotationPart.minRot, 3, rotationPart.rotTime, dt, true);
			setRotation(rotationPart.index, unpack(newRot));
			local rotationPart = self.rotationParts.rotationPart6;
			local rot = {getRotation(rotationPart.index)};
			local newRot = Utils.getMovedLimitedValues(rot, rotationPart.maxRot, rotationPart.minRot, 3, rotationPart.rotTime, dt, true);
			setRotation(rotationPart.index, unpack(newRot));
			
	    end;		
		if self.up then
			local rotationPart = self.rotationParts.rotationPart5;
			local rot = {getRotation(rotationPart.index)};
			local newRot = Utils.getMovedLimitedValues(rot, rotationPart.maxRot, rotationPart.minRot, 3, rotationPart.rotTime, dt, false);
			setRotation(rotationPart.index, unpack(newRot));
			local rotationPart = self.rotationParts.rotationPart6;
			local rot = {getRotation(rotationPart.index)};
			local newRot = Utils.getMovedLimitedValues(rot, rotationPart.maxRot, rotationPart.minRot, 3, rotationPart.rotTime, dt, false);
			setRotation(rotationPart.index, unpack(newRot));
			
	    end;  		

		if self.left then
			local rotationPart = self.rotationParts.rotationPart3;
			local rot = {getRotation(rotationPart.index)};
			local newRot = Utils.getMovedLimitedValues(rot, rotationPart.maxRot, rotationPart.minRot, 3, rotationPart.rotTime, dt, true);
			setRotation(rotationPart.index, unpack(newRot));
			local rotationPart = self.rotationParts.rotationPart4;
			local rot = {getRotation(rotationPart.index)};
			local newRot = Utils.getMovedLimitedValues(rot, rotationPart.maxRot, rotationPart.minRot, 3, rotationPart.rotTime, dt, true);
			setRotation(rotationPart.index, unpack(newRot));
			
	    end;		
		if self.right then
			local rotationPart = self.rotationParts.rotationPart3;
			local rot = {getRotation(rotationPart.index)};
			local newRot = Utils.getMovedLimitedValues(rot, rotationPart.maxRot, rotationPart.minRot, 3, rotationPart.rotTime, dt, false);
			setRotation(rotationPart.index, unpack(newRot));
			local rotationPart = self.rotationParts.rotationPart4;
			local rot = {getRotation(rotationPart.index)};
			local newRot = Utils.getMovedLimitedValues(rot, rotationPart.maxRot, rotationPart.minRot, 3, rotationPart.rotTime, dt, false);
			setRotation(rotationPart.index, unpack(newRot));
			
	    end;  		
			if self.left1 then
			local rotationPart = self.rotationParts.rotationPart1;
			local rot = {getRotation(rotationPart.index)};
			local newRot = Utils.getMovedLimitedValues(rot, rotationPart.maxRot, rotationPart.minRot, 3, rotationPart.rotTime, dt, true);
			setRotation(rotationPart.index, unpack(newRot));
			local rotationPart = self.rotationParts.rotationPart2;
			local rot = {getRotation(rotationPart.index)};
			local newRot = Utils.getMovedLimitedValues(rot, rotationPart.maxRot, rotationPart.minRot, 3, rotationPart.rotTime, dt, true);
			setRotation(rotationPart.index, unpack(newRot));
			
	    end;		
		if self.right1 then
			local rotationPart = self.rotationParts.rotationPart1;
			local rot = {getRotation(rotationPart.index)};
			local newRot = Utils.getMovedLimitedValues(rot, rotationPart.maxRot, rotationPart.minRot, 3, rotationPart.rotTime, dt, false);
			setRotation(rotationPart.index, unpack(newRot));
			local rotationPart = self.rotationParts.rotationPart2;
			local rot = {getRotation(rotationPart.index)};
			local newRot = Utils.getMovedLimitedValues(rot, rotationPart.maxRot, rotationPart.minRot, 3, rotationPart.rotTime, dt, false);
			setRotation(rotationPart.index, unpack(newRot));
			
	    end;  		






		if self.rotationPartClucth ~= nil then
			local x, y, z = getRotation(self.rotationPartClucth.node);
			local rot = {x,y,z};
			local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartClucth.maxRot, self.rotationPartClucth.minRot, 3, self.rotationPartClucth.rotTime, dt, not self.rotationMaxClucth);
			setRotation(self.rotationPartClucth.node, unpack(newRot));
		end;
	if self.rotationPartBrake ~= nil then
			local x, y, z = getRotation(self.rotationPartBrake.node);
			local rot = {x,y,z};
			local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartBrake.maxRot, self.rotationPartBrake.minRot, 3, self.rotationPartBrake.rotTime, dt, not self.rotationMaxBrake);
			setRotation(self.rotationPartBrake.node, unpack(newRot));
		end;
		
	   if self.rotationPartLeftDoor ~= nil then
		   local x, y, z = getRotation(self.rotationPartLeftDoor.node);
		   local rot = {x,y,z};
		   local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartLeftDoor.maxRot, self.rotationPartLeftDoor.minRot, 3, self.rotationPartLeftDoor.rotTime, dt, not self.rotationMaxLeftDoor);
		   setRotation(self.rotationPartLeftDoor.node, unpack(newRot));
        end;
	
	-- juntas

			for i, jointDesc in pairs(self.componentJoints) do
	   setJointFrame(self.componentJoints[i].jointIndex, 0, self.componentJoints[i].jointNode);
	end;
		self:setHydraulicDirection();



end;
function terragatorSpreader:draw()
 if self.hudTerragatorSpreaderOverlay ~= nil then
  if self.bcActive then
    self.hudTerragatorSpreaderOverlay:render();
  end;
end;
		if self.bcActive then	
			g_currentMission:addExtraPrintText("Kp0: INFO Off");
		else
			g_currentMission:addExtraPrintText("Kp0: INFO On");
		end;  
end;
function terragatorSpreader:setHydraulicDirection()
		for i=1, table.getn(self.hydraulics) do
		local ax, ay, az = getWorldTranslation(self.hydraulics[i].node);
		local bx, by, bz = getWorldTranslation(self.hydraulics[i].fixPoint);
		local x, y, z = worldDirectionToLocal(getParent(self.hydraulics[i].node), bx-ax, by-ay, bz-az);
		
		setDirection(self.hydraulics[i].node, x, y, z, 0, 1, 0);
		local distance = Utils.vector3Length(ax-bx, ay-by, az-bz);
		if self.hydraulics[i].doScale then
			local xScale, yScale, zScale = getScale(self.hydraulics[i].node);
			local newScale = yScale * (distance / self.hydraulics[i].punchDistance);
			setScale(self.hydraulics[i].node, 1, 1, newScale);
		else
			if self.hydraulics[i].punch ~= nil then
				setTranslation(self.hydraulics[i].punch, 0, 0, distance-self.hydraulics[i].punchDistance);
			end;
		end;
	
	end;
end;

function key_convert(key)
    if key ~= nil then 
	    local keyname = "";
	    if key > 32 and key < 123 then
	    	keyname = string.upper(string.char(key));
	    elseif key > 255 and key < 266 then
	    	keyname = "NUM "..string.char(key-208);
	    else 
	    	keyname = "";
	    end;
	    return(keyname);
	  end;
end;