_=[[
====================================================================================================================

universalAttacher - Landwirtschaftssimulator 15
Specialization zum Fixieren von Objekten
Original Name: objectAttacher

@autor Geri-G

====================================================================================================================
Dieses Skript fixiert alles auf einem Fahrzeug oder Anhaenger.
Alle moeglichen Ballen, Paletten, Fahrzeuge, Geraete usw., also alles das in der vehicles.xml gespeichert wird.
====================================================================================================================
Changelog 1: edited by PeterJ - euroDZN

16/11/2012
07/02/2013 - made FillablePallet compatible

--------------------------------------------------------------------------------------------------------------------
Changelog 2: edited by modall

Version 2.0 2015-01-13
universell gemacht durch Loeschen der Kriterien "bales" und "varBody"
inputBindings und Text angepasst

====================================================================================================================
Um dieses Skript einzubauen muss man Eintragen in
====================================================================================================================
vehicle.i3d:
------------
Set aus 4 Knoten, "baleCastPoints", auf die spaeter in myvehicle.xml Bezug genommen wird.
====================================================================================================================
moddesc.xml:
------------
<l10n>
     <text name="universalAttacher">         <en>Lock</en>       <de>Sperre</de>       </text>
     <text name="universalAttacherAttach">   <en>Lock</en>       <de>Sperren</de>      </text>
     <text name="universalAttacherDetach">   <en>UnLock</en>     <de>Entsperren</de>   </text>
</l10n>

<specializations>
     <specialization name="universalAttacher"   className="universalAttacher"   filename="universalAttacher.lua"/>
</specializations>

<vehicleTypes>
     <type name="myvehicletypename" className="Vehicle" filename="$dataS/scripts/vehicles/Vehicle.lua">
          <specialization name="universalAttacher"/>
     </type>
</vehicleTypes>

<inputBindings>
     <input name="universalAttacher" key1="KEY_lctrl KEY_KP_plus" button="" />
</inputBindings>	
====================================================================================================================
myvehicle.xml:
------------
<baleCastPoints allowVehicleAttachment="true" >
     <baleCastPoint frontRight="0>16|0" backLeft="0>16|2" attacherNode="0>" highOffset="4" />
     <baleCastPoint frontRight="0>16|1" backLeft="0>16|3" attacherNode="0>" highOffset="4" />
</baleCastPoints>
====================================================================================================================



====================================================================================================================

universalAttacher - Farming Simulator 15
Specialization for attaching objects
original name: objectAttacher

@author Geri-G

====================================================================================================================
This script attaches anything to your vehicle or trailer.
All kinds of Bales, Pallets, Vehicles, Implements etc., anything that is actually saved in vehicles.xml.
====================================================================================================================
Changelog 1: edited by PeterJ - euroDZN

16/11/2012
07/02/2013 - made FillablePallet compatible

--------------------------------------------------------------------------------------------------------------------
Changelog 2: edited by modall

Version 2.0 2015-01-13
made universal by deleting usage criteria "bales" and "varBody"
replaced inputBindings and text

====================================================================================================================
To use this script you need to add the following to
====================================================================================================================
vehicle.i3d:
------------
Set of 4 nodes, "baleCastPoints", later referred to in myvehicle.xml
====================================================================================================================
moddesc.xml:
------------
<l10n>
     <text name="universalAttacher">         <en>Lock</en>       <de>Sperre</de>       </text>
     <text name="universalAttacherAttach">   <en>Lock</en>       <de>Sperren</de>      </text>
     <text name="universalAttacherDetach">   <en>UnLock</en>     <de>Entsperren</de>   </text>
</l10n>

<specializations>
     <specialization name="universalAttacher"   className="universalAttacher"   filename="universalAttacher.lua"/>
</specializations>

<vehicleTypes>
     <type name="myvehicletypename" className="Vehicle" filename="$dataS/scripts/vehicles/Vehicle.lua">
          <specialization name="universalAttacher"/>
     </type>
</vehicleTypes>

<inputBindings>
     <input name="universalAttacher" key1="KEY_lctrl KEY_KP_plus" button="" />
</inputBindings>	
====================================================================================================================
myvehicle.xml:
------------
<baleCastPoints allowVehicleAttachment="true" >
     <baleCastPoint frontRight="0>16|0" backLeft="0>16|2" attacherNode="0>" highOffset="4" />
     <baleCastPoint frontRight="0>16|1" backLeft="0>16|3" attacherNode="0>" highOffset="4" />
</baleCastPoints>
====================================================================================================================
]]

universalAttacher1 = {};

function universalAttacher1.prerequisitesPresent(specializations)
    return true;
end;

function universalAttacher1:load(xmlFile)

	self.setIsBaleAttached1 = SpecializationUtil.callSpecializationsFunction("setIsBaleAttached1");
	self.searchObjects1 = universalAttacher1.searchObjects1;
	self.attachobjects1 = universalAttacher1.attachobjects1;
	self.detachobjects1 = universalAttacher1.detachobjects1;
	self.OrientJoint1 = universalAttacher1.OrientJoint1;
	self.isObjectInRange1 = universalAttacher1.isObjectInRange1;
	
	self.place1 = {};
	local i=0;
	while true do
		local basename = string.format("vehicle.baleCastPoints1.baleCastPoint1(%d)",i);
		local place1 = {};
		place1.node1 = Utils.indexToObject(self.components, getXMLString(xmlFile,basename.."#frontRight1"));
		if place1.node1 == nil then
			break;
		end;
		place1.node2 = Utils.indexToObject(self.components, getXMLString(xmlFile,basename.."#backLeft1"));
		place1.attacherNode1 = Utils.indexToObject(self.components, Utils.getNoNil(getXMLString(xmlFile,basename.."#attacherNode1"),"0>"));
		place1.highOffset = Utils.getNoNil(getXMLFloat(xmlFile,basename.."#highOffset1"),4);
		table.insert(self.place1,place1);
		i=i+1;
	end;
	local area1 = table.getn(self.place1);
	if area1 > 0 then
		self.useuniversalAttacher1 = true;
	end;
	self.allowVehicleAttachment1 = getXMLBool(xmlFile,"vehicle.baleCastPoints1#allowVehicleAttachment1");
	self.Attachedobjects1 = {};
	self.objectsAttached1 = false;
	self.isBaleAttach1 = false;	
end;

function universalAttacher1:delete()
end;

function universalAttacher1:readStream(streamId, connection)
	local baleAttach1 = streamReadBool(streamId);
	self:setIsBaleAttached1(baleAttach1, true);			
end;

function universalAttacher1:writeStream(streamId, connection)
    streamWriteBool(streamId, self.isBaleAttach1);
end;

function universalAttacher1:keyEvent(unicode, sym, modifier, isDown)
end;

function universalAttacher1:mouseEvent(posX, posY, isDown, isUp, button)
end;

function universalAttacher1:update(dt)
	if self:getIsActiveForInput() then
		if self.fillLevel == 0 and self.useuniversalAttacher1 then
			if InputBinding.hasEvent(InputBinding.universalAttacher1) then
				self:setIsBaleAttached1(not self.isBaleAttach1);
				end;
		end;
	end;
end;

function universalAttacher1:updateTick(dt)
end;

function universalAttacher1:draw()
	if self:getIsActive() then
		if self.fillLevel == 0 and self.useuniversalAttacher1 then
			if self.isBaleAttach1 then
				g_currentMission:addHelpButtonText(g_i18n:getText("universalAttacher1Detach"), InputBinding.universalAttacher1);
			else
				g_currentMission:addHelpButtonText(g_i18n:getText("universalAttacher1Attach"), InputBinding.universalAttacher1);
			end;
		end;
	end;
end;

function universalAttacher1:isObjectInRange1(place1,object1)
	local Xmax, Ymax, Zmax = getWorldTranslation(place1.node1);
		  Xmax, Ymax, Zmax = worldToLocal(place1.attacherNode1,Xmax, Ymax, Zmax);
		  
	local Xmin, Ymin, Zmin = getWorldTranslation(place1.node2);	
		  Xmin, Ymin, Zmin = worldToLocal(place1.attacherNode1,Xmin, Ymin, Zmin);
	
	local Xt, Yt, Zt = getWorldTranslation(object1);
		  Xt, Yt, Zt = worldToLocal(place1.attacherNode1,Xt, Yt, Zt);
		
	if (Xt < math.max(Xmax,Xmin) and Xt > math.min(Xmax,Xmin)) and (Zt < math.max(Zmax,Zmin) and Zt > math.min(Zmax,Zmin)) and (Yt<= ((Ymax+Ymin)/2)+place1.highOffset and Yt>= (Ymax+Ymin)/2) then
		return true;
	else
		return false;
	end;
end;

function universalAttacher1:setIsBaleAttached1(baleAttach1, noEventSend)
	SetBaleAttachEvent1.sendEvent(self, baleAttach1, noEventSend)
	self.isBaleAttach1 = baleAttach1;
	
	if baleAttach1 then
		self:searchObjects1();
	else
		self:detachobjects1();
	end;
end;


function universalAttacher1:searchObjects1()
	for index,item in pairs(g_currentMission.itemsToSave) do
			if item.item.isAttached == nil then
				for k,v in pairs(self.place1) do
					local isInRange1 = self:isObjectInRange1(v,item.item.nodeId);			
					local is1stAttached1 = false;
					if isInRange1 then
						is1stAttached1 = self:attachobjects1(v,item.item.nodeId,item.item);
					end;
					if is1stAttached1 then
						self.objectsAttached1 = true;
					end;
				end;
			end;
	end;
	if self.allowVehicleAttachment1 == true then
		for k,v in pairs(g_currentMission.vehicles) do
			if v ~= self and v ~= self.attacherVehicle then
				local is1stAttached1 = false;
				for index,components in pairs(v.components) do		
					for k1,v1 in pairs(self.place1) do
						local isInRange1 = self:isObjectInRange1(v1,components.node);	
						if isInRange1 then	
							is1stAttached1 = self:attachobjects1(v1,components.node);
						end;
					end;
				end;
				if is1stAttached1 then
					self.objectsAttached1 = true;
				end;
			end;
		end;
	end;
end;

function universalAttacher1:OrientJoint1(Source1, Target1)	
	local xw, yw, zw = getWorldTranslation(Source1);		
	local x,y,z = worldToLocal(getParent(Target1), xw, yw, zw);	
	setTranslation(Target1, x,y,z);			
	
	local zX, zY, zZ = localDirectionToWorld(Source1, 0,0,1);
	local zX, zY, zZ = worldDirectionToLocal(getParent(Target1), zX, zY, zZ);
	local yX, yY, yZ = localDirectionToWorld(Source1, 0,1,0);
	local yX, yY, yZ = worldDirectionToLocal(getParent(Target1), yX, yY, yZ);
	setDirection(Target1, zX, zY, zZ, yX, yY, yZ);
	return false;
end;

function universalAttacher1:attachobjects1(place1,object1,baleT1)
	local attachedobject = {};
	attachedobject.object1 = object1;
	if self.isServer then
		attachedobject.AT1 = createTransformGroup("AT1");
		link(place1.attacherNode1,attachedobject.AT1);
		
		self:OrientJoint1(object1,attachedobject.AT1);

		local constr = JointConstructor:new();					
		constr:setActors(place1.attacherNode1, object1);
		constr:setJointTransforms(attachedobject.AT1,  object1);
		for i=1, 3 do
			constr:setTranslationLimit(i-1, true, 0, 0);
			constr:setRotationLimit(i-1,0,0);
		end;
		attachedobject.JointIndex = constr:finalize();
		
		if baleT1 ~= nil then
			attachedobject.baleT1 = baleT1;
			baleT1.isAttached = true;
		end;
	end;

	table.insert(self.Attachedobjects1, attachedobject);
	return true;
end;

function universalAttacher1:detachobjects1()
	if self.isServer then
		for k,v in pairs(self.Attachedobjects1) do
			removeJoint(v.JointIndex);
			delete(v.AT1);
			v.JointIndex = nil;
			if v.baleT1 ~= nil then
				v.baleT1.isAttached = nil;
			end;
		end;
	end;
	
	self.Attachedobjects1 = nil;
	self.Attachedobjects1 = {};
	self.objectsAttached1 = false;
end;

function universalAttacher1:onAttach(attacherVehicle)
	if self.isServer then
		for index,item in pairs(g_currentMission.itemsToSave) do
			if item.item.isAttached == nil then
				for k,v in pairs(self.place1) do
					local isInRange1 = self:isObjectInRange1(v,item.item.nodeId);
					if isInRange1 then
						self:setIsBaleAttached1(true);
					end;
				end;
			end;
		end;
		if self.allowVehicleAttachment1 == true then
			for k,v in pairs(g_currentMission.vehicles) do
				if v ~= self and v ~= self.attacherVehicle then
					for index,components in pairs(v.components) do		
						for k1,v1 in pairs(self.place1) do
							local isInRange1 = self:isObjectInRange1(v1,components.node);	
							if isInRange1 then
								self:setIsBaleAttached1(true);
							end;
						end;
					end;
				end;
			end;
		end;
	end;
end;

function universalAttacher1:onDetach()
	if self.isServer then
		self:setIsBaleAttached1(false);
	end;
end;



SetBaleAttachEvent1 = {};
SetBaleAttachEvent1_mt = Class(SetBaleAttachEvent1, Event);
  
InitEventClass(SetBaleAttachEvent1, "SetBaleAttachEvent1");
  
function SetBaleAttachEvent1:emptyNew()
     local self = Event:new(SetBaleAttachEvent1_mt);
      self.className="SetBaleAttachEvent1";
      return self;
end;
  
function SetBaleAttachEvent1:new(object1, baleAttach1)
      local self = SetBaleAttachEvent1:emptyNew()
      self.object1 = object1;
      self.baleAttach1 = baleAttach1;
      return self;
end;
  
function SetBaleAttachEvent1:readStream(streamId, connection)
      local id = streamReadInt32(streamId);
      self.baleAttach1 = streamReadBool(streamId);
      self.object1 = networkGetObject(id);
      self:run(connection);
end;
  
function SetBaleAttachEvent1:writeStream(streamId, connection)
      streamWriteInt32(streamId, networkGetObjectId(self.object1));
      streamWriteBool(streamId, self.baleAttach1);
end;
  
function SetBaleAttachEvent1:run(connection)
      if not connection:getIsServer() then
         g_server:broadcastEvent(self, false, connection, self.object1);
      end;
      self.object1:setIsBaleAttached1(self.baleAttach1, true);
end;
  
function SetBaleAttachEvent1.sendEvent(vehicle, baleAttach1, noEventSend)
      if baleAttach1 ~= vehicle.isBaleAttach1 then
          if noEventSend == nil or noEventSend == false then
              if g_server ~= nil then
                  g_server:broadcastEvent(SetBaleAttachEvent1:new(vehicle, baleAttach1), nil, nil, vehicle);
              else
                  g_client:getServerConnection():sendEvent(SetBaleAttachEvent1:new(vehicle, baleAttach1));
              end;
          end;
      end;
end;

