_=[[
====================================================================================================================

universalAttacher - Landwirtschaftssimulator 15
Specialization zum Fixieren von Objekten
Original Name: objectAttacher

@autor Geri-G

====================================================================================================================
Dieses Skript fixiert alles auf einem Fahrzeug oder Anhaenger.
Alle moeglichen Ballen, Paletten, Fahrzeuge, Geraete usw., also alles das in der vehicles.xml gespeichert wird.
====================================================================================================================
Changelog 1: edited by PeterJ - euroDZN

16/11/2012
07/02/2013 - made FillablePallet compatible

--------------------------------------------------------------------------------------------------------------------
Changelog 2: edited by modall

Version 2.0 2015-01-13
universell gemacht durch Loeschen der Kriterien "bales" und "varBody"
inputBindings und Text angepasst

====================================================================================================================
Um dieses Skript einzubauen muss man Eintragen in
====================================================================================================================
vehicle.i3d:
------------
Set aus 4 Knoten, "baleCastPoints", auf die spaeter in myvehicle.xml Bezug genommen wird.
====================================================================================================================
moddesc.xml:
------------
<l10n>
     <text name="universalAttacher">         <en>Lock</en>       <de>Sperre</de>       </text>
     <text name="universalAttacherAttach">   <en>Lock</en>       <de>Sperren</de>      </text>
     <text name="universalAttacherDetach">   <en>UnLock</en>     <de>Entsperren</de>   </text>
</l10n>

<specializations>
     <specialization name="universalAttacher"   className="universalAttacher"   filename="universalAttacher.lua"/>
</specializations>

<vehicleTypes>
     <type name="myvehicletypename" className="Vehicle" filename="$dataS/scripts/vehicles/Vehicle.lua">
          <specialization name="universalAttacher"/>
     </type>
</vehicleTypes>

<inputBindings>
     <input name="universalAttacher" key1="KEY_lctrl KEY_KP_plus" button="" />
</inputBindings>	
====================================================================================================================
myvehicle.xml:
------------
<baleCastPoints allowVehicleAttachment="true" >
     <baleCastPoint frontRight="0>16|0" backLeft="0>16|2" attacherNode="0>" highOffset="4" />
     <baleCastPoint frontRight="0>16|1" backLeft="0>16|3" attacherNode="0>" highOffset="4" />
</baleCastPoints>
====================================================================================================================



====================================================================================================================

universalAttacher - Farming Simulator 15
Specialization for attaching objects
original name: objectAttacher

@author Geri-G

====================================================================================================================
This script attaches anything to your vehicle or trailer.
All kinds of Bales, Pallets, Vehicles, Implements etc., anything that is actually saved in vehicles.xml.
====================================================================================================================
Changelog 1: edited by PeterJ - euroDZN

16/11/2012
07/02/2013 - made FillablePallet compatible

--------------------------------------------------------------------------------------------------------------------
Changelog 2: edited by modall

Version 2.0 2015-01-13
made universal by deleting usage criteria "bales" and "varBody"
replaced inputBindings and text

====================================================================================================================
To use this script you need to add the following to
====================================================================================================================
vehicle.i3d:
------------
Set of 4 nodes, "baleCastPoints", later referred to in myvehicle.xml
====================================================================================================================
moddesc.xml:
------------
<l10n>
     <text name="universalAttacher">         <en>Lock</en>       <de>Sperre</de>       </text>
     <text name="universalAttacherAttach">   <en>Lock</en>       <de>Sperren</de>      </text>
     <text name="universalAttacherDetach">   <en>UnLock</en>     <de>Entsperren</de>   </text>
</l10n>

<specializations>
     <specialization name="universalAttacher"   className="universalAttacher"   filename="universalAttacher.lua"/>
</specializations>

<vehicleTypes>
     <type name="myvehicletypename" className="Vehicle" filename="$dataS/scripts/vehicles/Vehicle.lua">
          <specialization name="universalAttacher"/>
     </type>
</vehicleTypes>

<inputBindings>
     <input name="universalAttacher" key1="KEY_lctrl KEY_KP_plus" button="" />
</inputBindings>	
====================================================================================================================
myvehicle.xml:
------------
<baleCastPoints allowVehicleAttachment="true" >
     <baleCastPoint frontRight="0>16|0" backLeft="0>16|2" attacherNode="0>" highOffset="4" />
     <baleCastPoint frontRight="0>16|1" backLeft="0>16|3" attacherNode="0>" highOffset="4" />
</baleCastPoints>
====================================================================================================================
]]





universalAttacher = {};

function universalAttacher.prerequisitesPresent(specializations)
    return true;
end;

function universalAttacher:load(xmlFile)

	self.setIsBaleAttached = SpecializationUtil.callSpecializationsFunction("setIsBaleAttached");
	self.searchObjects = universalAttacher.searchObjects;
	self.attachobjects = universalAttacher.attachobjects;
	self.detachobjects = universalAttacher.detachobjects;
	self.OrientJoint = universalAttacher.OrientJoint;
	self.isObjectInRange = universalAttacher.isObjectInRange;
	
	self.place = {};
	local i=0;
	while true do
		local basename = string.format("vehicle.baleCastPoints.baleCastPoint(%d)",i);
		local place = {};
		place.node1 = Utils.indexToObject(self.components, getXMLString(xmlFile,basename.."#frontRight"));
		if place.node1 == nil then
			break;
		end;
		place.node2 = Utils.indexToObject(self.components, getXMLString(xmlFile,basename.."#backLeft"));
		place.attacherNode = Utils.indexToObject(self.components, Utils.getNoNil(getXMLString(xmlFile,basename.."#attacherNode"),"0>"));
		place.highOffset = Utils.getNoNil(getXMLFloat(xmlFile,basename.."#highOffset"),4);
		table.insert(self.place,place);
		i=i+1;
	end;
	local area = table.getn(self.place);
	if area > 0 then
		self.useuniversalAttacher = true;
	end;
	self.allowVehicleAttachment = getXMLBool(xmlFile,"vehicle.baleCastPoints#allowVehicleAttachment");
	self.Attachedobjects = {};
	self.objectsAttached = false;
	self.isBaleAttach = false;	
end;

function universalAttacher:delete()
end;

function universalAttacher:readStream(streamId, connection)
	local baleAttach = streamReadBool(streamId);
	self:setIsBaleAttached(baleAttach, true);			
end;

function universalAttacher:writeStream(streamId, connection)
    streamWriteBool(streamId, self.isBaleAttach);
end;

function universalAttacher:keyEvent(unicode, sym, modifier, isDown)
end;

function universalAttacher:mouseEvent(posX, posY, isDown, isUp, button)
end;

function universalAttacher:update(dt)
	if self:getIsActiveForInput() then
		if self.fillLevel == 0 and self.useuniversalAttacher then
			if InputBinding.hasEvent(InputBinding.universalAttacher) then
				self:setIsBaleAttached(not self.isBaleAttach);
				end;
		end;
	end;
end;

function universalAttacher:updateTick(dt)
end;

function universalAttacher:draw()
	if self:getIsActive() then
		if self.fillLevel == 0 and self.useuniversalAttacher then
			if self.isBaleAttach then
				g_currentMission:addHelpButtonText(g_i18n:getText("universalAttacherDetach"), InputBinding.universalAttacher);
			else
				g_currentMission:addHelpButtonText(g_i18n:getText("universalAttacherAttach"), InputBinding.universalAttacher);
			end;
		end;
	end;
end;

function universalAttacher:isObjectInRange(place,object)
	local Xmax, Ymax, Zmax = getWorldTranslation(place.node1);
		  Xmax, Ymax, Zmax = worldToLocal(place.attacherNode,Xmax, Ymax, Zmax);
		  
	local Xmin, Ymin, Zmin = getWorldTranslation(place.node2);	
		  Xmin, Ymin, Zmin = worldToLocal(place.attacherNode,Xmin, Ymin, Zmin);
	
	local Xt, Yt, Zt = getWorldTranslation(object);
		  Xt, Yt, Zt = worldToLocal(place.attacherNode,Xt, Yt, Zt);
		
	if (Xt < math.max(Xmax,Xmin) and Xt > math.min(Xmax,Xmin)) and (Zt < math.max(Zmax,Zmin) and Zt > math.min(Zmax,Zmin)) and (Yt<= ((Ymax+Ymin)/2)+place.highOffset and Yt>= (Ymax+Ymin)/2) then
		return true;
	else
		return false;
	end;
end;

function universalAttacher:setIsBaleAttached(baleAttach, noEventSend)
	SetBaleAttachEvent.sendEvent(self, baleAttach, noEventSend)
	self.isBaleAttach = baleAttach;
	
	if baleAttach then
		self:searchObjects();
	else
		self:detachobjects();
	end;
end;

function universalAttacher:searchObjects()
	for index,item in pairs(g_currentMission.itemsToSave) do
			if item.item.isAttached == nil then
				for k,v in pairs(self.place) do
					local isInRange = self:isObjectInRange(v,item.item.nodeId);			
					local is1stAttached = false;
					if isInRange then
						is1stAttached = self:attachobjects(v,item.item.nodeId,item.item);
					end;
					if is1stAttached then
						self.objectsAttached = true;
					end;
				end;
			end;
	end;
	if self.allowVehicleAttachment == true then
		for k,v in pairs(g_currentMission.vehicles) do
			if v ~= self and v ~= self.attacherVehicle then
				local is1stAttached = false;
				for index,components in pairs(v.components) do		
					for k1,v1 in pairs(self.place) do
						local isInRange = self:isObjectInRange(v1,components.node);	
						if isInRange then	
							is1stAttached = self:attachobjects(v1,components.node);
						end;
					end;
				end;
				if is1stAttached then
					self.objectsAttached = true;
				end;
			end;
		end;
	end;
end;


function universalAttacher:OrientJoint(Source, Target)	
	local xw, yw, zw = getWorldTranslation(Source);		
	local x,y,z = worldToLocal(getParent(Target), xw, yw, zw);	
	setTranslation(Target, x,y,z);			
	
	local zX, zY, zZ = localDirectionToWorld(Source, 0,0,1);
	local zX, zY, zZ = worldDirectionToLocal(getParent(Target), zX, zY, zZ);
	local yX, yY, yZ = localDirectionToWorld(Source, 0,1,0);
	local yX, yY, yZ = worldDirectionToLocal(getParent(Target), yX, yY, yZ);
	setDirection(Target, zX, zY, zZ, yX, yY, yZ);
	return false;
end;

function universalAttacher:attachobjects(place,object,baleT)
	local attachedobject = {};
	attachedobject.object = object;
	if self.isServer then
		attachedobject.AT = createTransformGroup("AT");
		link(place.attacherNode,attachedobject.AT);
		
		self:OrientJoint(object,attachedobject.AT);

		local constr = JointConstructor:new();					
		constr:setActors(place.attacherNode, object);
		constr:setJointTransforms(attachedobject.AT,  object);
		for i=1, 3 do
			constr:setTranslationLimit(i-1, true, 0, 0);
			constr:setRotationLimit(i-1,0,0);
		end;
		attachedobject.JointIndex = constr:finalize();
		
		if baleT ~= nil then
			attachedobject.baleT = baleT;
			baleT.isAttached = true;
		end;
	end;

	table.insert(self.Attachedobjects, attachedobject);
	return true;
end;

function universalAttacher:detachobjects()
	if self.isServer then
		for k,v in pairs(self.Attachedobjects) do
			removeJoint(v.JointIndex);
			delete(v.AT);
			v.JointIndex = nil;
			if v.baleT ~= nil then
				v.baleT.isAttached = nil;
			end;
		end;
	end;
	
	self.Attachedobjects = nil;
	self.Attachedobjects = {};
	self.objectsAttached = false;
end;

function universalAttacher:onAttach(attacherVehicle)
	if self.isServer then
		for index,item in pairs(g_currentMission.itemsToSave) do
			if item.item.isAttached == nil then
				for k,v in pairs(self.place) do
					local isInRange = self:isObjectInRange(v,item.item.nodeId);
					if isInRange then
						self:setIsBaleAttached(true);
					end;
				end;
			end;
		end;
		if self.allowVehicleAttachment == true then
			for k,v in pairs(g_currentMission.vehicles) do
				if v ~= self and v ~= self.attacherVehicle then
					for index,components in pairs(v.components) do		
						for k1,v1 in pairs(self.place) do
							local isInRange = self:isObjectInRange(v1,components.node);	
							if isInRange then
								self:setIsBaleAttached(true);
							end;
						end;
					end;
				end;
			end;
		end;
	end;
end;

function universalAttacher:onDetach()
	if self.isServer then
		self:setIsBaleAttached(false);
	end;
end;



SetBaleAttachEvent = {};
SetBaleAttachEvent_mt = Class(SetBaleAttachEvent, Event);
  
InitEventClass(SetBaleAttachEvent, "SetBaleAttachEvent");
  
function SetBaleAttachEvent:emptyNew()
     local self = Event:new(SetBaleAttachEvent_mt);
      self.className="SetBaleAttachEvent";
      return self;
end;
  
function SetBaleAttachEvent:new(object, baleAttach)
      local self = SetBaleAttachEvent:emptyNew()
      self.object = object;
      self.baleAttach = baleAttach;
      return self;
end;
  
function SetBaleAttachEvent:readStream(streamId, connection)
      local id = streamReadInt32(streamId);
      self.baleAttach = streamReadBool(streamId);
      self.object = networkGetObject(id);
      self:run(connection);
end;
  
function SetBaleAttachEvent:writeStream(streamId, connection)
      streamWriteInt32(streamId, networkGetObjectId(self.object));
      streamWriteBool(streamId, self.baleAttach);
end;
  
function SetBaleAttachEvent:run(connection)
      if not connection:getIsServer() then
         g_server:broadcastEvent(self, false, connection, self.object);
      end;
      self.object:setIsBaleAttached(self.baleAttach, true);
end;
  
function SetBaleAttachEvent.sendEvent(vehicle, baleAttach, noEventSend)
      if baleAttach ~= vehicle.isBaleAttach then
          if noEventSend == nil or noEventSend == false then
              if g_server ~= nil then
                  g_server:broadcastEvent(SetBaleAttachEvent:new(vehicle, baleAttach), nil, nil, vehicle);
              else
                  g_client:getServerConnection():sendEvent(SetBaleAttachEvent:new(vehicle, baleAttach));
              end;
          end;
      end;
end;

