--
-- @author:  	gEtOvEr@LSSA   edit: werik
-- @version 	v2.2beta-edit
-- @date  	10/11/13

Lock = {};

function Lock.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Attachable, specializations);
end;

function Lock:load(xmlFile)

	local rotationPartNoderichag = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.richag#index"));
    if rotationPartNoderichag ~= nil then
        self.rotationPartrichag = {};
        self.rotationPartrichag.node = rotationPartNoderichag;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.richag#minRot"));
        self.rotationPartrichag.minRot = {};
        self.rotationPartrichag.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartrichag.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartrichag.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.richag#maxRot"));
        self.rotationPartrichag.maxRot = {};
        self.rotationPartrichag.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartrichag.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartrichag.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartrichag.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.richag#rotTime"), 2)*1000;
        self.rotationPartrichag.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.richag#touchRotLimit"), 10));
    end;
      self.JointLock = false;
      self.JointLockNo = self.time;
end;

function Lock:update(dt)
	local isActive = false;

	local jointDesc = self.componentJoints[1];
	local px, py, pz = getWorldTranslation(jointDesc.jointNode);
	local sx, sy, sz = project(px, py, pz);
	if not self:getIsActiveForInput() then
		if g_currentMission.player ~= nil then
			local pvx, pvy, pvz = getWorldTranslation(g_currentMission.player.rootNode);
			local farmerDistance = Utils.vector3Length(pvx-px, pvy-py, pvz-pz);
			if farmerDistance < 2 then
				isActive = true;
				if not self.JointLock then
					g_currentMission:addHelpButtonText(g_i18n:getText("Lock"), InputBinding.Lock);
				else
					g_currentMission:addHelpButtonText(g_i18n:getText("UnLock"), InputBinding.Lock);
				end;
			end;
		end;
	end;

	if isActive then
		if InputBinding.hasEvent(InputBinding.Lock) then
			local x,y,z = getRotation(self.components[1].node);
			local x1,y1,z1 = getRotation(self.components[2].node);
			if math.abs(y - y1) < 0.01 then
				self.JointLock = not self.JointLock;
				if self.JointLock then
					setJointRotationLimit(self.componentJoints[1].jointIndex, 1, true, 0, 0);
		                                          self.rotationMaxrichag = true;
				else
					setJointRotationLimit(self.componentJoints[1].jointIndex, 1, true, math.rad(-120), math.rad(120));
		                                          self.rotationMaxrichag = false;	
				end;
			else
				if sz <= 1 then
					self.JointLockNo = self.time+5000;
				end;
			end;
		end;
		if self.JointLockNo > self.time then
                           g_currentMission:addWarning(g_i18n:getText("NoLock"));
		else
	        end;
	end;

	if self.rotationPartrichag ~= nil then
		local x, y, z = getRotation(self.rotationPartrichag.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartrichag.maxRot, self.rotationPartrichag.minRot, 3, self.rotationPartrichag.rotTime, dt, not self.rotationMaxrichag);
		setRotation(self.rotationPartrichag.node, unpack(newRot));
	end;
end;

function Lock:updateTick()
end;

function Lock:draw()
end;

function Lock:delete()
end;

function Lock:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Lock:keyEvent(unicode, sym, modifier, isDown)
end;