-- attachVehciles
-- Specialization for Tieflader.
-- @ Geri-G, ls-modsource.com
-- @ date : 22/02/2010
---modificacion xyzspain para self.setJointRotLimit especializacion

attachVehciles = {};

function attachVehciles.prerequisitesPresent(specializations)
    return true;
end;

function attachVehciles:load(xmlFile)
	self.GetVehiclesInRange = attachVehciles.GetVehiclesInRange;
	self.attachVehicles = attachVehciles.attachVehicles;
	self.detachVehicles = attachVehciles.detachVehicles;
	self.Attachers={};
	self.PF={};
	local Parent = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Attacher#ParentIndex"));
	local Parent2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Attacher#PlaceFinderParent"));
	local numAttachers = getNumOfChildren(Parent);
	local numPlaceFinders = getNumOfChildren(Parent2);
	for i=1, numAttachers do
		self.Attachers[i] = {};
		self.Attachers[i].node = getChildAt(Parent, i-1);
		self.Attachers[i].attachedObject = nil;
	end;	
	for j=1, numPlaceFinders do
		self.PF[j] = {};
		self.PF[j].Transform = getChildAt(Parent2, j-1);
	end;
	self.once = true;
	---------
	self.setJointRotLimit = SpecializationUtil.callSpecializationsFunction("setJointRotLimit");
	self.firstDo = {};
	self.arm = {};
	------
end;

function attachVehciles:delete()

end;

function attachVehciles:mouseEvent(posX, posY, isDown, isUp, button)
end;

function attachVehciles:keyEvent(unicode, sym, modifier, isDown)
end;
function attachVehciles:update(dt)
	if self:getIsActive() then	
	---renderText(0.1, 0.05, 0.03,"foldAnimTime: ".. string.format("%1d",self.foldAnimTime));
		---renderText(0.1, 0.1, 0.03,"foldMoveDirection: ".. string.format("%1d",self.foldMoveDirection));
	
		if self.foldAnimTime == 0 then
            local nearestVehicles = {};
            if self.once then
				self.nearestVehicles = {self:GetVehiclesInRange()};
				self.once = false;
			end;
			for i = 1, table.getn(self.nearestVehicles) do
				self:attachVehicles(self.nearestVehicles[i], i);
			end;
        else
			self.once = true;
			for i = 1, table.getn(self.nearestVehicles) do
				self:detachVehicles(self.nearestVehicles[i], i);
			end;	
        end;
	end;

--- asignacion de ejes de libertad  de rotacion segun condiciones de emsamblage  0 x, 2 y ,1 z 
	self:setJointRotLimit(self.componentJoints[3],0, 8, 1000,  self.foldAnimTime == 0, 0,dt);
	self:setJointRotLimit(self.componentJoints[4],0, 8, 1000,  self.foldAnimTime == 0, 0,dt);

	
end;

function attachVehciles:draw()

end;
function attachVehciles:attachVehicles(node, k)
	if self.Attachers[k].node ~= nil and self.Attachers[k].attachedObject == nil then 			
		--JointTranslation Anpassung an das Objekt
		local xw, yw, zw = getWorldTranslation(node.components[1].node);		
		local x,y,z = worldToLocal(getParent(self.Attachers[k].node), xw, yw, zw);	
		setTranslation(self.Attachers[k].node, x,y,z);			
		--JointRotation Anpassung an das Objekt
		local zX, zY, zZ = localDirectionToWorld(node.components[1].node, 0,0,1);
		local zX, zY, zZ = worldDirectionToLocal(getParent(self.Attachers[k].node), zX, zY, zZ);
		local yX, yY, yZ = localDirectionToWorld(node.components[1].node, 0,1,0);
		local yX, yY, yZ = worldDirectionToLocal(getParent(self.Attachers[k].node), yX, yY, yZ);
		setDirection(self.Attachers[k].node, zX, zY, zZ, yX, yY, yZ);
		
		if node.enterReferenceNode == nil then
			node:onAttach(self);
		end;
		--anhaengen
		local constr = JointConstructor:new();					
		constr:setActors(self.components[1].node, node.components[1].node);
		constr:setJointTransforms(self.Attachers[k].node,  node.components[1].node);
		for i=1, 3 do		                    
			constr:setTranslationLimit(i-1, true, 0, 0);
			constr:setRotationLimit(i-1, 0, 0);
		end;		
		self.Attachers[k].attachedObject = constr:finalize();
	end;
end;
function attachVehciles:detachVehicles(node, k)
	if self.Attachers[k].attachedObject ~= nil then	
		node.attacherVehicle = nil;
		
		if node.enterReferenceNode == nil then
			node:onDetach(self);
		end;		
		removeJoint(self.Attachers[k].attachedObject);
		self.Attachers[k].attachedObject = nil;
		
		setTranslation(self.Attachers[k].node,0,0,0);
		setRotation(self.Attachers[k].node,0,0,0);
	end;
end;
function attachVehciles:GetVehiclesInRange()
	local nearestNode = {};
	local nearestDistance = 4;
	for u,obj in pairs(self.PF) do
		local px, py, pz = getWorldTranslation(obj.Transform);
		
		for k,v in pairs(g_currentMission.vehicles) do
			if v ~= self and v ~= self.attacherVehicle and v.attacherVehicle == nil then
				local x,y,z = getWorldTranslation(v.components[1].node);
				local distance = Utils.vector3Length(px-x, py-y, pz-z);
				if distance < nearestDistance then
					if table.getn(nearestNode)+1 <= table.getn(self.Attachers) then
						nearestNode[table.getn(nearestNode)+1] = v;
						print("eingetragen");
					end;
				end;
			end;
		end;
	end;
	return unpack(nearestNode)
end;
function attachVehciles:setJointRotLimit(nodei, up, down, speed, value, axle, dt)

	if not self.firstDo[nodei] then
		self.firstDo[nodei] = true;
		self.arm[nodei] = {0}; 
	end; 
	x, y, z = getRotation(nodei);
	rot = {x,y,z};	
	newRotLimit = {}; 
	newRotLimit[nodei] = {0,0,0};
	newRotLimit[nodei] = Utils.getMovedLimitedValues(self.arm[nodei], {down}, {up}, 1, speed * 2, dt, value);
	if math.abs(newRotLimit[nodei][1] - self.arm[nodei][1]) > 0.001 then
		local joint = nodei;
		setJointRotationLimit(joint.jointIndex, axle, true, Utils.degToRad(-newRotLimit[nodei][1]), Utils.degToRad(newRotLimit[nodei][1]));
	end;
	self.arm[nodei] = newRotLimit[nodei];			
end;
