--
-- InteractiveButtons
-- Specialization for an interactive control button
--
-- @author  	Manuel Leithner (SFM-Modding)
-- @version 	v2.1
-- @date  		29/08/11
-- @history:	v1.0 - Initial version
--				v2.0 - converted to ls2011
--				v2.1 - improvements
--
-- free for noncommerical-usage
--

InteractiveButtons = {};

function InteractiveButtons.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(InteractiveControl, specializations);
end;

function InteractiveButtons:load(xmlFile)
	self.cpState0 = Utils.indexToObject(self.components, getXMLString(xmlFile,"vehicle.CommandCenter.Monitory.Monitor1#node"));
	self.cpState1 = Utils.indexToObject(self.components, getXMLString(xmlFile,"vehicle.CommandCenter.Monitory.Monitor2#node"));
	self.cpState2 = Utils.indexToObject(self.components, getXMLString(xmlFile,"vehicle.CommandCenter.Monitory.Monitor1_tuplaky#node"));
	self.cpState3 = Utils.indexToObject(self.components, getXMLString(xmlFile,"vehicle.CommandCenter.Monitory.Monitor1_zaplneni#node"));
	self.cpState4 = Utils.indexToObject(self.components, getXMLString(xmlFile,"vehicle.CommandCenter.Monitory.Monitor1_svetla#node"));
	self.cpState5 = Utils.indexToObject(self.components, getXMLString(xmlFile,"vehicle.CommandCenter.Monitory.Monitor2_tuplaky#node"));
	self.cpState6 = Utils.indexToObject(self.components, getXMLString(xmlFile,"vehicle.CommandCenter.Monitory.Monitor2_svetla#node"));
	setVisibility(self.cpState0, true);
	setVisibility(self.cpState1, true);
	setVisibility(self.cpState2, false);
	setVisibility(self.cpState3, false);
	setVisibility(self.cpState4, false);
	setVisibility(self.cpState5, false);
	setVisibility(self.cpState6, false);
	self.cpBackupPos = {0.0,0.0,0.0};
	self.cpHiddenPos = {0.0,0.0,5.0};
	setTranslation(self.cpState0, unpack(self.cpBackupPos));
	setTranslation(self.cpState1, unpack(self.cpBackupPos));
	setTranslation(self.cpState2, unpack(self.cpHiddenPos));
	setTranslation(self.cpState3, unpack(self.cpHiddenPos));
	setTranslation(self.cpState4, unpack(self.cpHiddenPos));
	setTranslation(self.cpState5, unpack(self.cpHiddenPos));
	setTranslation(self.cpState6, unpack(self.cpHiddenPos));
	self.LoogleCZIC = {};
	-- Info for inmplement control (original script used in driveControl, modified)
	local joints = {};
	for k,joint in pairs(self.attacherJoints) do
		if joint.jointType == Vehicle.JOINTTYPE_IMPLEMENT or joint.jointType == Vehicle.JOINTTYPE_CUTTER or joint.jointType == Vehicle.JOINTTYPE_CUTTERHARVESTER then
			if joint.allowsLowering then
				table.insert(joints,k);
			end;
		end;
	end;
	
	if table.getn(joints) > 0 and table.getn(joints) < 3 then
		local pos = {};
		for _,index in pairs(joints) do
			local x,y,z = getWorldTranslation(self.attacherJoints[index].jointTransform);
			local rx,ry,rz = worldToLocal(self.rootNode,x,y,z);
			pos[index] = rz;
		end;
		if table.getn(joints) == 1 then
			if pos[joints[1]] > 0 then
				self.LoogleCZIC.front = joints[1];
			else
				self.LoogleCZIC.back = joints[1];
			end;
		elseif table.getn(joints) == 2 then
			if pos[joints[1]] >  pos[joints[2]] then
				self.LoogleCZIC.front = joints[1];
				self.LoogleCZIC.back = joints[2];				
			else
				self.LoogleCZIC.front = joints[2];
				self.LoogleCZIC.back = joints[1];							
			end;
		end;
	end;
	
	joints = {};
	for k,joint in pairs(self.attacherJoints) do
		if joint.jointType == Vehicle.JOINTTYPE_TRAILER then --or joint.jointType == Vehicle.JOINTTYPE_TRAILERLOW then			
			table.insert(joints,k);			
		end;
	end;

	if table.getn(joints) == 1 then
		self.LoogleCZIC.back2 = joints[1];
	elseif table.getn(joints) == 2 then
		local pos = {};
		for _,index in pairs(joints) do
			local x,y,z = getWorldTranslation(self.attacherJoints[index].jointTransform);
			local rx,ry,rz = worldToLocal(self.rootNode,x,y,z);
			pos[index] = rz;
		end;
		if pos[joints[1]] >  pos[joints[2]] then
			self.LoogleCZIC.back2 = pos[joints[2]];
		else
			self.LoogleCZIC.back2 = pos[joints[1]];
		end;
	end;

	
	joints = {};
	for k,joint in pairs(self.attacherJoints) do
		if joint.jointType == Vehicle.JOINTTYPE_TRAILERLOW then --or joint.jointType == Vehicle.JOINTTYPE_TRAILERLOW then			
			table.insert(joints,k);			
		end;
	end;

	if table.getn(joints) == 1 then
		self.LoogleCZIC.back3 = joints[1];
	elseif table.getn(joints) == 2 then
		local pos = {};
		for _,index in pairs(joints) do
			local x,y,z = getWorldTranslation(self.attacherJoints[index].jointTransform);
			local rx,ry,rz = worldToLocal(self.rootNode,x,y,z);
			pos[index] = rz;
		end;
		if pos[joints[1]] >  pos[joints[2]] then
			self.LoogleCZIC.back3 = pos[joints[2]];
		else
			self.LoogleCZIC.back3 = pos[joints[1]];
		end;
	end;
	-- end of modified part
	local i=0;
	while true do
		local buttonName = string.format("vehicle.interactiveComponents.buttons.button(%d)", i);	
		if not hasXMLProperty(xmlFile, buttonName) then
			break;
		end;
		local name = Utils.getNoNil(g_i18n:getText(getXMLString(xmlFile, buttonName .. "#name")), "ERROR");
		local mark = Utils.indexToObject(self.components, getXMLString(xmlFile, buttonName .. "#mark"));
		local highlight = getChildAt(mark, 0);
		local size = Utils.getNoNil(getXMLFloat(xmlFile, buttonName .. "#size"), 0.1);
		local event = getXMLString(xmlFile, buttonName .. "#event");
		local onMessage = g_i18n:getText(Utils.getNoNil(getXMLString(xmlFile, buttonName .. "#onMessage"), "ic_button_on"));
		local offMessage =  g_i18n:getText(Utils.getNoNil(getXMLString(xmlFile, buttonName .. "#offMessage") , "ic_button_off"));
	
		local button = Button:new(nil, highlight, name, mark, size, event, self, onMessage, offMessage, self.infoBar, {self.cpState0,self.cpState1,self.cpState2,self.cpState3,self.cpState4,self.cpState5,self.cpState6,self.cpBackupPos,self.cpHiddenPos},{self.LoogleCZIC.back,self.LoogleCZIC.front,self.LoogleCZIC.back2,self.LoogleCZIC.back3});
		
		button.synch = Utils.getNoNil(getXMLBool(xmlFile, buttonName .. "#synch"), true);

		table.insert(self.interactiveObjects, button);
		i = i + 1;
	end;
	
end;

function InteractiveButtons:delete()
end;

function InteractiveButtons:mouseEvent(posX, posY, isDown, isUp, button)
end;

function InteractiveButtons:keyEvent(unicode, sym, modifier, isDown)
end;

function InteractiveButtons:update(dt)	
end;

function InteractiveButtons:draw()
end;



--
-- Button Class
-- Specifies an interactive Button
--
-- SFM-Modding
-- @author  Manuel Leithner
-- @date  29/08/11
--

Button = {};

function Button:new(node, highlight, name, mark, size, event, vehicle, onMessage, offMessage, infobar, cpStates, implementControlVar)

	local Button_mt = Class(Button, InteractiveComponentInterface);	
    local instance = InteractiveComponentInterface:new(node, highlight, name, mark, size, onMessage, offMessage, infobar, Button_mt);

	instance.vehicle = vehicle;
	instance.event = event;
	instance.cpStates = cpStates;
	instance.implementControlVar = implementControlVar;
	return instance;	
end;

function Button:delete()
	InteractiveComponentInterface.delete(self);
end;

function Button:mouseEvent(posX, posY, isDown, isUp, button)
	InteractiveComponentInterface.mouseEvent(self, posX, posY, isDown, isUp, button);
end;

function Button:keyEvent(unicode, sym, modifier, isDown)
	InteractiveComponentInterface.keyEvent(self, unicode, sym, modifier, isDown);
end;

function Button:update(dt)
	if self.vehicle ~= nil then
		if self.event == "togglePipe" then
			self.isOpen = self.vehicle.targetPipeState ~= 1;
		elseif self.event == "toggleBeaconLights" then
			self.isOpen = not self.vehicle.beaconLightsActive;
		elseif self.event == "toggleFrontWorklights" then
			self.isOpen = not getVisibility(Utils.indexToObject(self.vehicle.components, "0>11|1|0|0"));
		elseif self.event == "toggleBackWorklights" then
			self.isOpen = not getVisibility(Utils.indexToObject(self.vehicle.components, "0>11|1|1|0"));
		elseif self.event == "toggleLevyBlinkr" then
			self.isOpen = not getVisibility(Utils.indexToObject(self.vehicle.components, "0>13|0"));
		elseif self.event == "togglePravyBlinkr" then
			self.isOpen = not getVisibility(Utils.indexToObject(self.vehicle.components, "0>13|1"));
		elseif self.event == "toggleZadniPravyTuplak" then
			self.isOpen = not getVisibility(Utils.indexToObject(self.vehicle.components, "4>1|1"));
		elseif self.event == "toggleZadniLevyTuplak" then
			self.isOpen = not getVisibility(Utils.indexToObject(self.vehicle.components, "3>1|1"));
		elseif self.event == "togglePredniPravyTuplak" then
			self.isOpen = not getVisibility(Utils.indexToObject(self.vehicle.components, "2>1|1|2"));
		elseif self.event == "togglePredniLevyTuplak" then
			self.isOpen = not getVisibility(Utils.indexToObject(self.vehicle.components, "1>1|1|2"));
		elseif self.event == "toggleChopper" then
			self.isOpen = not self.vehicle.isStrawEnabled;
		end;
	end;
	InteractiveComponentInterface.update(self, dt);
end;

function Button:draw()
	InteractiveComponentInterface.draw(self);
end;

function Button:doAction(noEventSend, forceAction)
    if self.event == "toggleBeaconLights" then
		if self.vehicle ~= nil then
			if self.vehicle.beaconLightsActive then
				self.vehicle:setBeaconLightsVisibility(false);
			else
				self.vehicle:setBeaconLightsVisibility(true);
			end;
		end;
	end;
	if self.event == "ptoToggle" then
		if self.vehicle ~= nil then
			for k, implement in pairs(self.vehicle.attachedImplements) do
				if implement.object ~= nil then
					if implement.object.isTurnedOn ~= nil then
						if implement.object.isTurnedOn then
							implement.object.isTurnedOn = false;
						else
							implement.object.isTurnedOn = true;
						end;
					end;
				end;
			end;
		end;
	end;
	if self.event == "toggleHandBreak" then
		if self.vehicle ~= nil then
			if self.vehicle.handbrake then
				self.vehicle.handbrake = false;
			else
				self.vehicle.handbrake = true;
			end;
		end;
	end;
	if self.vehicle ~= nil then
		if self.event == "togglePipe" then
			if forceAction == nil then
				local nextState = self.vehicle.targetPipeState+1;
				if nextState > self.vehicle.numPipeStates then
					nextState = 1;
				end;
				self.vehicle:setPipeState(nextState, true);
			end;
		-- CP eventy
		elseif self.event == "monitor1_tuplaky" then
			setVisibility(self.cpStates[1], true);
			setVisibility(self.cpStates[3], true);
			setVisibility(self.cpStates[4], false);
			setVisibility(self.cpStates[5], false);
			setTranslation(self.cpStates[1], unpack(self.cpStates[8]));
			setTranslation(self.cpStates[3], unpack(self.cpStates[8]));
			setTranslation(self.cpStates[4], unpack(self.cpStates[9]));
			setTranslation(self.cpStates[5], unpack(self.cpStates[9]));
		elseif self.event == "monitor1_tuplaky_zavrit" then
			setVisibility(self.cpStates[1], true);
			setVisibility(self.cpStates[3], false);
			setVisibility(self.cpStates[4], false);
			setVisibility(self.cpStates[5], false);
			setTranslation(self.cpStates[1], unpack(self.cpStates[8]));
			setTranslation(self.cpStates[3], unpack(self.cpStates[9]));
			setTranslation(self.cpStates[4], unpack(self.cpStates[9]));
			setTranslation(self.cpStates[5], unpack(self.cpStates[9]));
		elseif self.event == "monitor1_zaplneni" then
			setVisibility(self.cpStates[1], true);
			setVisibility(self.cpStates[3], false);
			setVisibility(self.cpStates[4], true);
			setVisibility(self.cpStates[5], false);
			setTranslation(self.cpStates[1], unpack(self.cpStates[8]));
			setTranslation(self.cpStates[3], unpack(self.cpStates[9]));
			setTranslation(self.cpStates[4], unpack(self.cpStates[8]));
			setTranslation(self.cpStates[5], unpack(self.cpStates[9]));
		elseif self.event == "monitor1_zaplneni_zavrit" then
			setVisibility(self.cpStates[1], true);
			setVisibility(self.cpStates[3], false);
			setVisibility(self.cpStates[4], false);
			setVisibility(self.cpStates[5], false);
			setTranslation(self.cpStates[1], unpack(self.cpStates[8]));
			setTranslation(self.cpStates[3], unpack(self.cpStates[9]));
			setTranslation(self.cpStates[4], unpack(self.cpStates[9]));
			setTranslation(self.cpStates[5], unpack(self.cpStates[9]));
		elseif self.event == "monitor1_svetla" then
			setVisibility(self.cpStates[1], true);
			setVisibility(self.cpStates[3], false);
			setVisibility(self.cpStates[4], false);
			setVisibility(self.cpStates[5], true);
			setTranslation(self.cpStates[1], unpack(self.cpStates[8]));
			setTranslation(self.cpStates[3], unpack(self.cpStates[9]));
			setTranslation(self.cpStates[4], unpack(self.cpStates[9]));
			setTranslation(self.cpStates[5], unpack(self.cpStates[8]));
		elseif self.event == "monitor1_svetla_zavrit" then
			setVisibility(self.cpStates[1], true);
			setVisibility(self.cpStates[3], false);
			setVisibility(self.cpStates[4], false);
			setVisibility(self.cpStates[5], false);
			setTranslation(self.cpStates[1], unpack(self.cpStates[8]));
			setTranslation(self.cpStates[3], unpack(self.cpStates[9]));
			setTranslation(self.cpStates[4], unpack(self.cpStates[9]));
			setTranslation(self.cpStates[5], unpack(self.cpStates[9]));
		elseif self.event == "monitor2_tuplaky" then
			setVisibility(self.cpStates[2], true);
			setVisibility(self.cpStates[6], true);
			setVisibility(self.cpStates[7], false);
			setTranslation(self.cpStates[2], unpack(self.cpStates[8]));
			setTranslation(self.cpStates[6], unpack(self.cpStates[8]));
			setTranslation(self.cpStates[7], unpack(self.cpStates[9]));
		elseif self.event == "monitor2_tuplaky_zavrit" then
			setVisibility(self.cpStates[2], true);
			setVisibility(self.cpStates[6], false);
			setVisibility(self.cpStates[7], false);
			setTranslation(self.cpStates[2], unpack(self.cpStates[8]));
			setTranslation(self.cpStates[6], unpack(self.cpStates[9]));
			setTranslation(self.cpStates[7], unpack(self.cpStates[9]));
		elseif self.event == "monitor2_svetla" then
			setVisibility(self.cpStates[2], true);
			setVisibility(self.cpStates[6], false);
			setVisibility(self.cpStates[7], true);
			setTranslation(self.cpStates[2], unpack(self.cpStates[8]));
			setTranslation(self.cpStates[6], unpack(self.cpStates[9]));
			setTranslation(self.cpStates[7], unpack(self.cpStates[8]));
		elseif self.event == "monitor2_svetla_zavrit" then
			setVisibility(self.cpStates[2], true);
			setVisibility(self.cpStates[6], false);
			setVisibility(self.cpStates[7], false);
			setTranslation(self.cpStates[2], unpack(self.cpStates[8]));
			setTranslation(self.cpStates[6], unpack(self.cpStates[9]));
			setTranslation(self.cpStates[7], unpack(self.cpStates[9]));
		elseif self.event == "toggleFrontWorklights" then
			local realLight = "";
			if getVisibility(Utils.indexToObject(self.vehicle.components, "0>11|1|0|0")) then
				setVisibility(Utils.indexToObject(self.vehicle.components, "0>11|1|0|0"), false);
				setVisibility(Utils.indexToObject(self.vehicle.components, "0>10|1|0"), false);
				setVisibility(Utils.indexToObject(self.vehicle.components, "0>6|0|15|0|5|0|0|3|5"), false);
				setVisibility(Utils.indexToObject(self.vehicle.components, "0>6|0|15|0|5|0|1|2|5"), false);
			else
				setVisibility(Utils.indexToObject(self.vehicle.components, "0>11|1|0|0"), true);
				setVisibility(Utils.indexToObject(self.vehicle.components, "0>10|1|0"), true);
				setVisibility(Utils.indexToObject(self.vehicle.components, "0>6|0|15|0|5|0|0|3|5"), true);
				setVisibility(Utils.indexToObject(self.vehicle.components, "0>6|0|15|0|5|0|1|2|5"), true);
			end;
		elseif self.event == "toggleBackWorklights" then
			local realLight = "";
			if getVisibility(Utils.indexToObject(self.vehicle.components, "0>11|1|1|0")) then
				setVisibility(Utils.indexToObject(self.vehicle.components, "0>11|1|1|0"), false);
				setVisibility(Utils.indexToObject(self.vehicle.components, "0>10|1|1"), false);
				setVisibility(Utils.indexToObject(self.vehicle.components, "0>6|0|15|0|5|0|0|3|6"), false);
				setVisibility(Utils.indexToObject(self.vehicle.components, "0>6|0|15|0|5|0|1|2|6"), false);
			else
				setVisibility(Utils.indexToObject(self.vehicle.components, "0>11|1|1|0"), true);
				setVisibility(Utils.indexToObject(self.vehicle.components, "0>10|1|1"), true);
				setVisibility(Utils.indexToObject(self.vehicle.components, "0>6|0|15|0|5|0|0|3|6"), true);
				setVisibility(Utils.indexToObject(self.vehicle.components, "0>6|0|15|0|5|0|1|2|6"), true);
			end;
		elseif self.event == "toggleLevyBlinkr" then
			local realLight = "";
			if getVisibility(Utils.indexToObject(self.vehicle.components, "0>13|0")) then
				setVisibility(Utils.indexToObject(self.vehicle.components, "0>13|0"), false);
			else
				setVisibility(Utils.indexToObject(self.vehicle.components, "0>13|0"), true);
			end;
		elseif self.event == "togglePravyBlinkr" then
			local realLight = "";
			if getVisibility(Utils.indexToObject(self.vehicle.components, "0>13|1")) then
				setVisibility(Utils.indexToObject(self.vehicle.components, "0>13|1"), false);
			else
				setVisibility(Utils.indexToObject(self.vehicle.components, "0>13|1"), true);
			end;
		elseif self.event == "toggleZadniPravyTuplak" then
			local realLight = "";
			if getVisibility(Utils.indexToObject(self.vehicle.components, "4>1|1")) then
				setVisibility(Utils.indexToObject(self.vehicle.components, "4>1|1"), false);
				setVisibility(Utils.indexToObject(self.vehicle.components, "0>6|0|15|0|5|0|0|1|3"), false);
				setVisibility(Utils.indexToObject(self.vehicle.components, "0>6|0|15|0|5|0|1|1|3"), false);
			else
				setVisibility(Utils.indexToObject(self.vehicle.components, "4>1|1"), true);
				setVisibility(Utils.indexToObject(self.vehicle.components, "0>6|0|15|0|5|0|0|1|3"), true);
				setVisibility(Utils.indexToObject(self.vehicle.components, "0>6|0|15|0|5|0|1|1|3"), true);
			end;
		elseif self.event == "toggleZadniLevyTuplak" then
			local realLight = "";
			if getVisibility(Utils.indexToObject(self.vehicle.components, "3>1|1")) then
				setVisibility(Utils.indexToObject(self.vehicle.components, "3>1|1"), false);
				setVisibility(Utils.indexToObject(self.vehicle.components, "0>6|0|15|0|5|0|0|1|1"), false);
				setVisibility(Utils.indexToObject(self.vehicle.components, "0>6|0|15|0|5|0|1|1|1"), false);
			else
				setVisibility(Utils.indexToObject(self.vehicle.components, "3>1|1"), true);
				setVisibility(Utils.indexToObject(self.vehicle.components, "0>6|0|15|0|5|0|0|1|1"), true);
				setVisibility(Utils.indexToObject(self.vehicle.components, "0>6|0|15|0|5|0|1|1|1"), true);
			end;
		elseif self.event == "togglePredniLevyTuplak" then
			local realLight = "";
			if getVisibility(Utils.indexToObject(self.vehicle.components, "1>1|1|2")) then
				setVisibility(Utils.indexToObject(self.vehicle.components, "1>1|1|2"), false);
				setVisibility(Utils.indexToObject(self.vehicle.components, "0>6|0|15|0|5|0|0|1|0"), false);
				setVisibility(Utils.indexToObject(self.vehicle.components, "0>6|0|15|0|5|0|1|1|0"), false);
			else
				setVisibility(Utils.indexToObject(self.vehicle.components, "1>1|1|2"), true);
				setVisibility(Utils.indexToObject(self.vehicle.components, "0>6|0|15|0|5|0|0|1|0"), true);
				setVisibility(Utils.indexToObject(self.vehicle.components, "0>6|0|15|0|5|0|1|1|0"), true);
			end;
		elseif self.event == "togglePredniPravyTuplak" then
			local realLight = "";
			if getVisibility(Utils.indexToObject(self.vehicle.components, "2>1|1|2")) then
				setVisibility(Utils.indexToObject(self.vehicle.components, "2>1|1|2"), false);
				setVisibility(Utils.indexToObject(self.vehicle.components, "0>6|0|15|0|5|0|0|1|2"), false);
				setVisibility(Utils.indexToObject(self.vehicle.components, "0>6|0|15|0|5|0|1|1|2"), false);
			else
				setVisibility(Utils.indexToObject(self.vehicle.components, "2>1|1|2"), true);
				setVisibility(Utils.indexToObject(self.vehicle.components, "0>6|0|15|0|5|0|0|1|2"), true);
				setVisibility(Utils.indexToObject(self.vehicle.components, "0>6|0|15|0|5|0|1|1|2"), true);
			end;
		elseif self.event == "toggleFrontImplementTurnState" then
			if self.implementControlVar[2] ~= nil then
				local index = self.implementControlVar[2];
				local jointDesc = self.vehicle.attacherJoints[index];
				local implementIndex = self.vehicle:getImplementIndexByJointDescIndex(index);
				local implement = self.vehicle.attachedImplements[implementIndex];
				if implement ~= nil then
					local object = implement.object;
					if object ~= nil then
						if object.setIsTurnedOn~= nil and object.isTurnedOn~= nil then
							object:setIsTurnedOn(not object.isTurnedOn);
						elseif jointDesc.jointType == Vehicle.JOINTTYPE_CUTTER or jointDesc.jointType == Vehicle.JOINTTYPE_CUTTERHARVESTER then	
							if self.vehicle.setIsTurnedOn~= nil and self.vehicle.isTurnedOn~= nil then
								self.vehicle:setIsTurnedOn(not self.vehicle.isTurnedOn)
							end;
						end;
					end;
				end;
			end;
		elseif self.event == "toggleBackImplementTurnState" then
			local joints = {self.implementControlVar[1], self.implementControlVar[3], self.implementControlVar[4]};
			for _,joint in pairs(joints) do
				if joint~= nil then
					local youShallNotPass = false;
					local index = joint;
					local jointDesc = self.vehicle.attacherJoints[index];
					local implementIndex = self.vehicle:getImplementIndexByJointDescIndex(index);
					local implement = self.vehicle.attachedImplements[implementIndex];
					if implement ~= nil then
						local object = implement.object;
						if object ~= nil then
							if object.setIsTurnedOn~= nil and object.isTurnedOn~= nil then
								object:setIsTurnedOn(not object.isTurnedOn);
								youShallNotPass = true;
							elseif jointDesc.jointType == Vehicle.JOINTTYPE_CUTTER or jointDesc.jointType == Vehicle.JOINTTYPE_CUTTERHARVESTER then	
								if self.vehicle.setIsTurnedOn~= nil and self.vehicle.isTurnedOn~= nil then
									self.vehicle:setIsTurnedOn(not self.vehicle.isTurnedOn)
									youShallNotPass = true;
								end;
							end;
						end;
					end;
					if youShallNotPass then
						break;
					end;
				end;
			end;
		end;
		-- CP eventy konec
		if self.event == "toggleFrontlights" then
			if self.vehicle ~= nil then
				if self.vehicle.realLightsActive then
					self.vehicle:setLightsVisibility(false);
				else
					self.vehicle:setLightsVisibility(true);
				end;
			end;
		end;
		if self.event == "toggleChopper" then
			local newValue = not self.vehicle.isStrawEnabled;
			self.vehicle:setIsStrawEnabled(newValue, true);
		end;	
	end;
end;

function Button:onEnter(dt)
	InteractiveComponentInterface.onEnter(self, dt);
end;

function Button:onExit(dt)
	InteractiveComponentInterface.onExit(self, dt);
end;

function Button:setActive()
	InteractiveComponentInterface.setActive(self, isActive);
end;

function Button:setVisible(isVisible)
	InteractiveComponentInterface.setVisible(self, isVisible);
end;