

kzk6 = {};

function kzk6.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Attachable, specializations); 
end;

function kzk6:load(xmlFile)
	self.updateSafeArea = SpecializationUtil.callSpecializationsFunction("updateSafeArea");
	self.aiTerrainDetailChannel1 = g_currentMission.ploughChannel; 
	self.aiTerrainDetailChannel2 = g_currentMission.cultivatorChannel;		

	local MiddlePartXNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.MiddlePart#index"));
    if MiddlePartXNode ~= nil then
        self.MiddlePart = {};
        self.MiddlePart.node = MiddlePartXNode;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.MiddlePart#minRot"));
        self.MiddlePart.minRot = {};
        self.MiddlePart.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.MiddlePart.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.MiddlePart.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.MiddlePart#maxRot"));
        self.MiddlePart.maxRot = {};
        self.MiddlePart.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.MiddlePart.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.MiddlePart.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.MiddlePart.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.MiddlePart#rotTime"), 2)*1000;
        self.MiddlePart.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.MiddlePart#touchRotLimit"), 10));
    end;	
	local LeftJointXNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.LeftJoint#index"));
    if LeftJointXNode ~= nil then
        self.LeftJoint = {};
        self.LeftJoint.node = LeftJointXNode;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.LeftJoint#minRot"));
        self.LeftJoint.minRot = {};
        self.LeftJoint.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.LeftJoint.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.LeftJoint.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.LeftJoint#maxRot"));
        self.LeftJoint.maxRot = {};
        self.LeftJoint.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.LeftJoint.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.LeftJoint.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.LeftJoint.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.LeftJoint#rotTime"), 2)*1000;
        self.LeftJoint.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.LeftJoint#touchRotLimit"), 10));
    end;
	local RightJointXNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.RightJoint#index"));
    if RightJointXNode ~= nil then
        self.RightJoint = {};
        self.RightJoint.node = RightJointXNode;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.RightJoint#minRot"));
        self.RightJoint.minRot = {};
        self.RightJoint.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.RightJoint.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.RightJoint.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.RightJoint#maxRot"));
        self.RightJoint.maxRot = {};
        self.RightJoint.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.RightJoint.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.RightJoint.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.RightJoint.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.RightJoint#rotTime"), 2)*1000;
        self.RightJoint.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.RightJoint#touchRotLimit"), 10));
    end;	

	local cultivatorSound = getXMLString(xmlFile, "vehicle.cultivatorSound#file");
    if cultivatorSound ~= nil and cultivatorSound ~= "" then
        cultivatorSound = Utils.getFilename(cultivatorSound, self.baseDirectory);
        self.cultivatorSound = createSample("cultivatorSound");
        loadSample(self.cultivatorSound, cultivatorSound, false);
        self.cultivatorSoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.cultivatorSound#pitchOffset"), 0);
        self.cultivatorSoundVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.cultivatorSound#volume"), 1.5);
        self.cultivatorSoundEnabled = false;
    end;
	
	self.charIdAnim = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.animWorkingDiscs#Node"));
	self.clipIndexAnim = getXMLString(xmlFile, "vehicle.animWorkingDiscs#animationClip");	
	
	self.isDown = false;
	self.safeMode = true;	
	self.Frame = true;
	self.MiddlePartMax = true	

end;

function kzk6:delete()
    if self.cultivatorSound ~= nil then
        delete(self.cultivatorSound);
    end;
end;

function kzk6:mouseEvent(posX, posY, isDown, isUp, button)
end;

function kzk6:keyEvent(unicode, sym, modifier, isDown)
end;

function kzk6:update(dt)
    if self.attacherVehicle then	

		if self.isActive then
			
			if InputBinding.hasEvent(InputBinding.SAFE_MODE) then
				self.safeMode = not self.safeMode;
			end;		

			if InputBinding.hasEvent(InputBinding.LOWER_IMPLEMENT)  then
				self.MiddlePartMax = not self.MiddlePartMax;
			    self.isDown = not self.isDown;				
			end;			
			local doRotate = self.MiddlePartMax or self.MiddlePartMin or not self.MiddlePartMax
			if self.MiddlePart ~= nil and doRotate then
				local x, y, z = getRotation(self.MiddlePart.node);
				local rot = {x,y,z};
				local newRot = Utils.getMovedLimitedValues(rot, self.MiddlePart.maxRot, self.MiddlePart.minRot, 3, self.MiddlePart.rotTime, dt, not self.MiddlePartMax);
				setRotation(self.MiddlePart.node,unpack(newRot));
			end;		

			if  self.Frame then
				self.LeftJointMax = true;
				self.LeftJointMin = false;
				setJointRotationLimit(self.componentJoints[1].jointIndex, 0, true, math.rad(2), math.rad(25));	
				setJointRotationLimit(self.componentJoints[1].jointIndex, 2, true, math.rad(-0.5), math.rad(0.5));				
			end;
				local x, y, z = getRotation(self.componentJoints[1].jointNode);
				local minRot = self.RightJoint.minRot;
				local eps = self.RightJoint.touchRotLimit;
				if  (math.abs(x-minRot[1]) < eps) then
					self.RightJointMax = true;
					self.RightJointMin = false;				
					setJointRotationLimit(self.componentJoints[2].jointIndex, 0, true, math.rad(-10), math.rad(-2));
				end;			
			setJointFrame(self.componentJoints[1].jointIndex, 1,self.componentJoints[1].jointNode);	
			setJointFrame(self.componentJoints[2].jointIndex, 1,self.componentJoints[2].jointNode);				
			
			
			local doRotate = self.LeftJointMax or self.LeftJointMin or not self.LeftJointMax
			if self.LeftJoint ~= nil and doRotate then
				local x, y, z = getRotation(self.componentJoints[1].jointNode);
				local rot = {x,y,z};
				local newRot = Utils.getMovedLimitedValues(rot, self.LeftJoint.maxRot, self.LeftJoint.minRot, 3, self.LeftJoint.rotTime, dt, not self.LeftJointMax);
				setRotation(self.componentJoints[1].jointNode,unpack(newRot));
			end;
			
			if self.isDown then
				for k, cuttingArea in pairs(self.cuttingAreas) do
					local x,y,z = getWorldTranslation(cuttingArea.start);
					local x1,y1,z1 = getWorldTranslation(cuttingArea.width);
					local x2,y2,z2 = getWorldTranslation(cuttingArea.height);
					if self.safeMode then
						self:updateSafeArea(x, z, x1, z1, x2, z2);
					else
						Utils.updateCultivatorArea(x, z, x1, z1, x2, z2);
					end;
				end;
		local charId = getAnimCharacterSet(self.charIdAnim);
		local clipIndex = getAnimClipIndex(charId, self.clipIndexAnim);		
			if self.lastSpeed*3600 > 8 then
				assignAnimTrackClip(charId , 0, clipIndex);
				setAnimTrackLoopState(charId, 0, true);
				setAnimTrackSpeedScale(charId, 0, 6);
				enableAnimTrack(charId, 0);
			else
				disableAnimTrack(charId, 0);
			end;		
				if self.cultivatorSound ~= nil and not self.cultivatorSoundEnabled and self:getIsActiveForSound() then
					if self.lastSpeed*3600 > 1 then
						playSample(self.cultivatorSound, 0, self.cultivatorSoundVolume, 0);
						setSamplePitch(self.cultivatorSound, self.cultivatorSoundPitchOffset);
						self.cultivatorSoundEnabled = true;
					end;
				end;
			else
				if self.cultivatorSoundEnabled then
					stopSample(self.cultivatorSound);
					self.cultivatorSoundEnabled = false;
				end;				
			end;
			if self.cultivatorSoundEnabled then
				if self.lastSpeed*3600 < 1 then
					stopSample(self.cultivatorSound);
					self.cultivatorSoundEnabled = false;
				end;
			end;			
					
		end;
	end;	
end;

function kzk6:draw()

	if self.MiddlePartMax then
		g_currentMission:addHelpButtonText(g_i18n:getText("LiftCultivator"), InputBinding.LOWER_IMPLEMENT);
	else
		g_currentMission:addHelpButtonText(g_i18n:getText("LowerCultivator"), InputBinding.LOWER_IMPLEMENT);
	end;
	if self.safeMode then
		g_currentMission:addHelpButtonText(g_i18n:getText("SafeModeOff"), InputBinding.SAFE_MODE);
	else
		g_currentMission:addHelpButtonText(g_i18n:getText("SafeModeOn"), InputBinding.SAFE_MODE);
	end;	
end;

function kzk6:onDetach()

end;

function kzk6:onAttach()
end; 
function kzk6:onLeave()

end;

function kzk6:onActivate()
end;

function kzk6:onDeactivate()

end;

function kzk6:CarrierWorkingTime(diffTime)

end; 
function kzk6:updateSafeArea(startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ)
  local cultiId = g_currentMission.cultivatorChannel;
  local sowingId = g_currentMission.sowingChannel;
  local detailId = g_currentMission.terrainDetailId;
  local ploughId = g_currentMission.ploughChannel;
  local sprayId = g_currentMission.sprayChannel;
  
  local x, z, widthX, widthZ, heightX, heightZ = Utils.getXZWidthAndHeight(detailId, startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ);
  
  Utils.updateDestroyCommonArea(startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ);
  
  setDensityMaskedParallelogram(detailId, x, z, widthX, widthZ, heightX, heightZ, cultiId, 1, detailId, sowingId, 1, 1);
  setDensityParallelogram(detailId, x, z, widthX, widthZ, heightX, heightZ, sowingId, 1, 0);
  setDensityParallelogram(detailId, x, z, widthX, widthZ, heightX, heightZ, ploughId, 1, 0);
  setDensityParallelogram(detailId, x, z, widthX, widthZ, heightX, heightZ, sprayId, 1, 0);
end;


