

KPS4 = {};

function KPS4.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Attachable, specializations); 
end;

function KPS4:load(xmlFile)
	self.updateSafeArea = SpecializationUtil.callSpecializationsFunction("updateSafeArea");
	self.aiTerrainDetailChannel1 = g_currentMission.ploughChannel; 
	self.aiTerrainDetailChannel2 = g_currentMission.cultivatorChannel;		

	local RamaLapXNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.RamaLap#index"));
    if RamaLapXNode ~= nil then
        self.RamaLap = {};
        self.RamaLap.node = RamaLapXNode;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.RamaLap#minRot"));
        self.RamaLap.minRot = {};
        self.RamaLap.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.RamaLap.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.RamaLap.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.RamaLap#maxRot"));
        self.RamaLap.maxRot = {};
        self.RamaLap.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.RamaLap.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.RamaLap.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.RamaLap.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.RamaLap#rotTime"), 2)*1000;
        self.RamaLap.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.RamaLap#touchRotLimit"), 10));
    end;	
	local PlankaXNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Planka#index"));
    if PlankaXNode ~= nil then
        self.Planka = {};
        self.Planka.node = PlankaXNode;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.Planka#minRot"));
        self.Planka.minRot = {};
        self.Planka.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.Planka.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.Planka.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.Planka#maxRot"));
        self.Planka.maxRot = {};
        self.Planka.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.Planka.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.Planka.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.Planka.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.Planka#rotTime"), 2)*1000;
        self.Planka.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.Planka#touchRotLimit"), 10));
    end;
	local BoronaXNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Borona#index"));
    if BoronaXNode ~= nil then
        self.Borona = {};
        self.Borona.node = BoronaXNode;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.Borona#minRot"));
        self.Borona.minRot = {};
        self.Borona.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.Borona.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.Borona.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.Borona#maxRot"));
        self.Borona.maxRot = {};
        self.Borona.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.Borona.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.Borona.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.Borona.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.Borona#rotTime"), 2)*1000;
        self.Borona.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.Borona#touchRotLimit"), 10));
    end;	

	local cultivatorSound = getXMLString(xmlFile, "vehicle.cultivatorSound#file");
    if cultivatorSound ~= nil and cultivatorSound ~= "" then
        cultivatorSound = Utils.getFilename(cultivatorSound, self.baseDirectory);
        self.cultivatorSound = createSample("cultivatorSound");
        loadSample(self.cultivatorSound, cultivatorSound, false);
        self.cultivatorSoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.cultivatorSound#pitchOffset"), 0);
        self.cultivatorSoundVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.cultivatorSound#volume"), 1.5);
        self.cultivatorSoundEnabled = false;
    end;
	
	self.charIdAnim = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.animWorkingDiscs#Node"));
	self.clipIndexAnim = getXMLString(xmlFile, "vehicle.animWorkingDiscs#animationClip");	
	
	self.isDown = false;
	self.safeMode = true;	
	self.Frame = true;
	self.RamaLapMax = true	

end;

function KPS4:delete()
    if self.cultivatorSound ~= nil then
        delete(self.cultivatorSound);
    end;
end;

function KPS4:mouseEvent(posX, posY, isDown, isUp, button)
end;

function KPS4:keyEvent(unicode, sym, modifier, isDown)
end;

function KPS4:update(dt)
    if self.attacherVehicle then	

		if self.isActive then
			
			if InputBinding.hasEvent(InputBinding.SAFE_MODE) then
				self.safeMode = not self.safeMode;
			end;		

			if InputBinding.hasEvent(InputBinding.LOWER_IMPLEMENT)  then
				self.RamaLapMax = not self.RamaLapMax;
			    self.isDown = not self.isDown;				
			end;			
			local doRotate = self.RamaLapMax or self.RamaLapMin or not self.RamaLapMax
			if self.RamaLap ~= nil and doRotate then
				local x, y, z = getRotation(self.RamaLap.node);
				local rot = {x,y,z};
				local newRot = Utils.getMovedLimitedValues(rot, self.RamaLap.maxRot, self.RamaLap.minRot, 3, self.RamaLap.rotTime, dt, not self.RamaLapMax);
				setRotation(self.RamaLap.node,unpack(newRot));
			end;		

			if  self.Frame then
				self.PlankaMax = true;
				self.PlankaMin = false;
				setJointRotationLimit(self.componentJoints[1].jointIndex, 0, true, math.rad(2), math.rad(25));	
				setJointRotationLimit(self.componentJoints[1].jointIndex, 2, true, math.rad(-0.5), math.rad(0.5));				
			end;
				local x, y, z = getRotation(self.componentJoints[1].jointNode);
				local minRot = self.Borona.minRot;
				local eps = self.Borona.touchRotLimit;
				if  (math.abs(x-minRot[1]) < eps) then
					self.BoronaMax = true;
					self.BoronaMin = false;				
					setJointRotationLimit(self.componentJoints[2].jointIndex, 0, true, math.rad(-10), math.rad(-2));
				end;			
			setJointFrame(self.componentJoints[1].jointIndex, 1,self.componentJoints[1].jointNode);	
			setJointFrame(self.componentJoints[2].jointIndex, 1,self.componentJoints[2].jointNode);				
			
			
			local doRotate = self.PlankaMax or self.PlankaMin or not self.PlankaMax
			if self.Planka ~= nil and doRotate then
				local x, y, z = getRotation(self.componentJoints[1].jointNode);
				local rot = {x,y,z};
				local newRot = Utils.getMovedLimitedValues(rot, self.Planka.maxRot, self.Planka.minRot, 3, self.Planka.rotTime, dt, not self.PlankaMax);
				setRotation(self.componentJoints[1].jointNode,unpack(newRot));
			end;
			local doRotate = self.BoronaMax or self.BoronaMin or not self.BoronaMax
			if self.Borona ~= nil and doRotate then
				local x, y, z = getRotation(self.componentJoints[2].jointNode);
				local rot = {x,y,z};
				local newRot = Utils.getMovedLimitedValues(rot, self.Borona.maxRot, self.Borona.minRot, 3, self.Borona.rotTime, dt, not self.BoronaMax);
				setRotation(self.componentJoints[2].jointNode,unpack(newRot));
			end;			
			if self.isDown then
				for k, cuttingArea in pairs(self.cuttingAreas) do
					local x,y,z = getWorldTranslation(cuttingArea.start);
					local x1,y1,z1 = getWorldTranslation(cuttingArea.width);
					local x2,y2,z2 = getWorldTranslation(cuttingArea.height);
					if self.safeMode then
						self:updateSafeArea(x, z, x1, z1, x2, z2);
					else
						Utils.updateCultivatorArea(x, z, x1, z1, x2, z2);
					end;
				end;
		local charId = getAnimCharacterSet(self.charIdAnim);
		local clipIndex = getAnimClipIndex(charId, self.clipIndexAnim);		
			if self.lastSpeed*3600 > 8 then
				assignAnimTrackClip(charId , 0, clipIndex);
				setAnimTrackLoopState(charId, 0, true);
				setAnimTrackSpeedScale(charId, 0, 6);
				enableAnimTrack(charId, 0);
			else
				disableAnimTrack(charId, 0);
			end;		
				if self.cultivatorSound ~= nil and not self.cultivatorSoundEnabled and self:getIsActiveForSound() then
					if self.lastSpeed*3600 > 1 then
						playSample(self.cultivatorSound, 0, self.cultivatorSoundVolume, 0);
						setSamplePitch(self.cultivatorSound, self.cultivatorSoundPitchOffset);
						self.cultivatorSoundEnabled = true;
					end;
				end;
			else
				if self.cultivatorSoundEnabled then
					stopSample(self.cultivatorSound);
					self.cultivatorSoundEnabled = false;
				end;				
			end;
			if self.cultivatorSoundEnabled then
				if self.lastSpeed*3600 < 1 then
					stopSample(self.cultivatorSound);
					self.cultivatorSoundEnabled = false;
				end;
			end;			
					
		end;
	end;	
end;

function KPS4:draw()

	if self.RamaLapMax then
		g_currentMission:addHelpButtonText(g_i18n:getText("LiftCultivator"), InputBinding.LOWER_IMPLEMENT);
	else
		g_currentMission:addHelpButtonText(g_i18n:getText("LowerCultivator"), InputBinding.LOWER_IMPLEMENT);
	end;
	if self.safeMode then
		g_currentMission:addHelpButtonText(g_i18n:getText("SafeModeOff"), InputBinding.SAFE_MODE);
	else
		g_currentMission:addHelpButtonText(g_i18n:getText("SafeModeOn"), InputBinding.SAFE_MODE);
	end;	
end;

function KPS4:onDetach()

end;

function KPS4:onAttach()
end; 
function KPS4:onLeave()

end;

function KPS4:onActivate()
end;

function KPS4:onDeactivate()

end;

function KPS4:CarrierWorkingTime(diffTime)

end; 
function KPS4:updateSafeArea(startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ)
  local cultiId = g_currentMission.cultivatorChannel;
  local sowingId = g_currentMission.sowingChannel;
  local detailId = g_currentMission.terrainDetailId;
  local ploughId = g_currentMission.ploughChannel;
  local sprayId = g_currentMission.sprayChannel;
  
  local x, z, widthX, widthZ, heightX, heightZ = Utils.getXZWidthAndHeight(detailId, startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ);
  
  Utils.updateDestroyCommonArea(startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ);
  
  setDensityMaskedParallelogram(detailId, x, z, widthX, widthZ, heightX, heightZ, cultiId, 1, detailId, sowingId, 1, 1);
  setDensityParallelogram(detailId, x, z, widthX, widthZ, heightX, heightZ, sowingId, 1, 0);
  setDensityParallelogram(detailId, x, z, widthX, widthZ, heightX, heightZ, ploughId, 1, 0);
  setDensityParallelogram(detailId, x, z, widthX, widthZ, heightX, heightZ, sprayId, 1, 0);
end;


