--
--	ToggleTipSide
--
--	This script enables the player to choose the tipping side
--
--
--	version: 		0.1
--	last edit:		13.02.2013
--	written by: 	fruktor
-- 	powered by: 	www.eifok-team.de	
--  Edited by Lulu88520
--  http://www.ls-modteam-france.com/


ToggleTipSide = {};

-- local mod_directory = g_currentModDirectory;
-- source(Utils.getFilename("SetTipSideEvent.lua", mod_directory));


function ToggleTipSide.prerequisitesPresent(specializations)
    return true;
end;

function ToggleTipSide:load(xmlFile)	

	-- check if count of tipRef matches the count of animations
	if table.getn(self.tipReferencePoints) ~= table.getn(self.tipAnimations) then
		print("[ToggleTipState] WARNING: the number of entries in tipReferencePoints doesn't matchs the one of tipAnimations");
		print("[ToggleTipState] WARNING: ToggleTipState is disabled for this vehicle!");
		self.toggleTipSideActive = false;
	else
		if table.getn(self.tipReferencePoints) == 1 then
			self.toggleTipSideActive = false;
		else
			self.toggleTipSideActive = true;
			self.toggleTipSideCount = table.getn(self.tipReferencePoints);
			self.toggleTipSideIndex = 1;
		end
	end;
	
	--
	self.setTipSide = SpecializationUtil.callSpecializationsFunction("setTipSide");
	self.toggleTipState = Utils.overwrittenFunction(self.toggleTipState, ToggleTipSide.toggleTipState);

	--
	self.notSelectedTime = 0;
	
	self.nomAnimBennage1 = getXMLString(xmlFile, "vehicle.animBennage#name1");	
	self.nomAnimBennage2 = getXMLString(xmlFile, "vehicle.animBennage#name2");	
	self.nomAnimBennage3 = getXMLString(xmlFile, "vehicle.animBennage#name3");	
end;


function ToggleTipSide:delete()
end;


function ToggleTipSide:readStream(streamId, connection)
	self.toggleTipSideIndex = streamReadInt32(streamId);
end;


function ToggleTipSide:writeStream(streamId, connection)	
	streamWriteInt32(streamId, self.toggleTipSideIndex);
end;


function ToggleTipSide:mouseEvent(posX, posY, isDown, isUp, button)
end;


function ToggleTipSide:keyEvent(unicode, sym, modifier, isDown)
end;


function ToggleTipSide:update(dt)
	
	--###
	if self:getIsActive() and self.toggleTipSideActive then
		
		--#
		if self.isClient and self:getIsActiveForInput(false) and not self:hasInputConflictWithSelection() then

			if self.tipState == Trailer.TIPSTATE_CLOSED then
				if InputBinding.hasEvent(InputBinding.MAUPU_ToggleTipSide) then
					local idx = self.toggleTipSideIndex + 1;
					if idx > self.toggleTipSideCount then
						idx = 1;
					end;
					self:setTipSide(idx);
				end;
			end;
			
		end;
	end;
	if self.notSelectedTime > self.time then
		g_currentMission:addWarning(g_i18n:getText("TOGGLETIP_NOTSELECTED"));
	end;
end;


function ToggleTipSide:updateTick(dt)
end;


function ToggleTipSide:draw()
	if self.toggleTipSideActive then
		if self.tipState == Trailer.TIPSTATE_CLOSED and self.toggleTipSideIndex == 1 then
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("TOGGLETIPSIDETEXT"), self.nomAnimBennage1), InputBinding.MAUPU_ToggleTipSide);
		else if self.tipState == Trailer.TIPSTATE_CLOSED and self.toggleTipSideIndex == 2 then
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("TOGGLETIPSIDETEXT"), self.nomAnimBennage2), InputBinding.MAUPU_ToggleTipSide);
			else if self.tipState == Trailer.TIPSTATE_CLOSED and self.toggleTipSideIndex == 3 then
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("TOGGLETIPSIDETEXT"), self.nomAnimBennage3), InputBinding.MAUPU_ToggleTipSide);
				end;
			end;
		end;		
	end;
end;


function ToggleTipSide:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)	
    return BaseMission.VEHICLE_LOAD_OK;	
end;


function ToggleTipSide:getSaveAttributesAndNodes(nodeIdent)
    local attributes = '';
    return attributes, nil;
end;


function ToggleTipSide:onAttach(attacherVehicle)
end;


function ToggleTipSide:onDetach()
end;


function ToggleTipSide:attachImplement(object, jointIndex, noEventSend, index)
end;


function ToggleTipSide:detachImplement(implementIndex, noEventSend)
end

function ToggleTipSide:toggleTipState(_func, tipTrigger, tipReferencePointIndex)
		
	local traVeh = not self.isSelectable or self.isSelected == nil;
	
	if (self.isSelected and self.isSelectable) or traVeh then

		if self.toggleTipSideActive then	
			tipReferencePointIndex = self.toggleTipSideIndex;
		end;		
		
		local ir = g_currentMission:getIsTrailerInTipRange(self, tipTrigger, tipReferencePointIndex);

		
		if (self.tipState == Trailer.TIPSTATE_CLOSED or self.tipState == Trailer.TIPSTATE_CLOSING) then
			if ir then
				self:onStartTip(tipTrigger, tipReferencePointIndex);			
			end;
		else
			self:onEndTip();
		end;
	else
		self.notSelectedTime = self.time + 1000;
	end;

	
end;


function ToggleTipSide:setTipSide(state, noEventSend)
	SetTipSideEvent.sendEvent(self, state, noEventSend);
	self.toggleTipSideIndex = state;
end