-- Handbremse - Script = ParkBrake
-- Änderung von parkingBrake in ParkBrake weil die Eingabe von "Space" auf "H" verlegt wurde, da andere mods sich sonst überschneiden.
-- Change of parking brake in park brake because typing "Space" to "H" was moved because other mods overlap otherwise.
-- edit by ieg53i
ParkBrake = {};
ParkBrake.modDir = g_currentModDirectory;

function ParkBrake.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function ParkBrake:load(xmlFile)
	if self.setparkingBrakeStateHM ~= nil then
		return;
	end;
	if g_newGUISkin then
		self.ParkBrakeOnHud = Overlay:new("hBOn", (ParkBrake.modDir.."Textures/brake_on_ngs.dds"), 0.78, 0.134, 0.0288, 0.039);
		self.ParkBrakeOffHud = Overlay:new("hBOff", (ParkBrake.modDir.."Textures/brake_off_ngs.dds"), 0.78, 0.134, 0.0288, 0.039);
	else
		self.ParkBrakeOnHud = Overlay:new("hBOn", (ParkBrake.modDir.."Textures/brake_on.dds"), 0.9443, 0.172, 0.0288, 0.039);
		self.ParkBrakeOffHud = Overlay:new("hBOff", (ParkBrake.modDir.."Textures/brake_off.dds"), 0.9443, 0.172, 0.0288, 0.039);
	end;
	self.setParkBrakeState = SpecializationUtil.callSpecializationsFunction("setParkBrakeState");

	self.ParkBrake = true;


	ParkBrakeSoundFile = Utils.getFilename("Sounds/handbrake_on.wav", self.baseDirectory);
	self.ParkBrakeSoundId = createSample("ParkBrakeSound");
	loadSample(self.ParkBrakeSoundId, ParkBrakeSoundFile, false);
	self.ParkBrakePlaying = false;

	self.ParkBrakeReleasePlaying = false;
	brakereleaseSoundFile = Utils.getFilename("Sounds/handbrake_release.wav", self.baseDirectory);
	self.ParkBrakeReleaseSoundId = createSample("brakereleaseSound");
	loadSample(self.ParkBrakeReleaseSoundId, brakereleaseSoundFile, false);

	self.ParkBrakeReleasePlaying = false;
	self.BreakForceVal = 10000/self.motor.brakeForce;
	if g_currentMission.extraHudMode == nil then
		g_currentMission.extraHudMode = 0;
	end;

    self.ParkBrakeTurnOff = false;
end;

function ParkBrake:delete()

end;

function ParkBrake:mouseEvent(posX, posY, isDown, isUp, button)
end;

function ParkBrake:keyEvent(unicode, sym, modifier, isDown)
end;

function ParkBrake:readStream(streamId, connection)
	if self.setParkBrakeStateHM ~= nil then
		return;
	end;
	self:setParkBrakeState(streamReadBool(streamId));
end;

function ParkBrake:writeStream(streamId, connection)
	if self.setParkBrakeStateHM ~= nil then
		return;
	end;
	streamWriteBool(streamId, self.ParkBrake);
end;

function ParkBrake:updateTick(dt)
	if self.setParkBrakeStateHM ~= nil then
		return;
	end;
	if self.isServer then
		if self.ParkBrake then
			for k,wheel in pairs(self.wheels) do
				wheel.hasHandbrake = true;
				if self.isRealistic then
					WheelsUtil.updateWheelsPhysics(self, 0, self.lastSpeed, 0, true, 0, true)
				else
					WheelsUtil.updateWheelsPhysics(self, 0, self.lastSpeed, 0, true, 0)
				end;
				setWheelShapeProps(wheel.node, wheel.wheelShape, 0, 999, wheel.steeringAngle);
			end;
		elseif (not self.ParkBrake) and self.ParkBrakeTurnOff then
			for k,wheel in pairs(self.wheels) do
				setWheelShapeProps(wheel.node, wheel.wheelShape, 0, 0, wheel.steeringAngle);
			end;
			self.ParkBrakeTurnOff = false;
		end;
	end;
end;

function ParkBrake:update(dt)
	if self.setParkBrakeStateHM ~= nil then
		return;
	end;
	if self.isClient then
		if self:getIsActiveForInput() or self:getIsActiveForInput(false) then
			if InputBinding.hasEvent(InputBinding.handbremse) then
				self:setParkBrakeState(not self.ParkBrake);
				if self.ParkBrake and self:getIsActiveForSound() and self.isClient then
					playSample(self.ParkBrakeSoundId,1,1,0);
				else
					playSample(self.ParkBrakeReleaseSoundId,1,1,0);
				end;
			end;
		end;
		local ax = false;
		if self.axisForward ~= nil then
			if self.axisForward ~= 0 then
				if self.axisForward < -0.2 then
					ax = true;
				end;
			end;
		end;
		if Input.isKeyPressed(Input.KEY_s) or ax == true then
			if not self.braking then
				self.braking = true;
			end;
			if not self.ParkBrakePlaying and self:getIsActiveForSound() then
				self.ParkBrakePlaying = true;
			end;
			self.ParkBrakeReleasePlaying = false;
		else
			self.ParkBrakePlaying = false;
			self.braking = false;
			if not self.ParkBrakeReleasePlaying and self:getIsActiveForSound() then
				self.ParkBrakeReleasePlaying = true;
			end;
		end;
	end;
end;

function ParkBrake:draw()
	if self.setParkBrakeStateHM ~= nil then
		return;
	end;
	if self.isEntered then
		if self.ParkBrake then
			g_currentMission:addHelpButtonText(g_i18n:getText("handbrakeOFF"), InputBinding.handbremse);
			self.ParkBrakeOnHud:render();
			if self.isMotorStarted then
				local ax = false;
				if self.axisForward ~= nil then
					if self.axisForward < -0.4 then
						ax = true;
					end;
				end;
				if Input.isKeyPressed(Input.KEY_w) or ax == true then
					g_currentMission:addWarning(g_i18n:getText("handbrakeRELEASE"), 0.015, 0.030);
				end;
			end;
		else
			g_currentMission:addHelpButtonText(g_i18n:getText("handbrakeON"), InputBinding.handbremse);
			self.ParkBrakeOffHud:render();
		end;
	end;
end;

function ParkBrake:onLeave()

end;

function ParkBrake:setParkBrakeState(state, noEventSend)
	if self.setParkBrakeStateHM ~= nil then
		return;
	end;
	ParkBrakeEvent.sendEvent(self, state, noEventSend);
	self.ParkBrake = state;
	if state then
		self.ParkBrakeTurnOff = state;
	end;
	if self.ParkBrakelight ~= nil then
		setVisibility(self.ParkBrakelight, state);
	end;
end;

-----------------------------------------------------

ParkBrakeEvent = {};
ParkBrakeEvent_mt = Class(ParkBrakeEvent, Event);

InitEventClass(ParkBrakeEvent, "ParkBrakeEvent");

function ParkBrakeEvent:emptyNew()
    local self = Event:new(ParkBrakeEvent_mt);
    self.className="ParkBrakeEvent";
    return self;
end;

function ParkBrakeEvent:new(vehicle, ParkBrake)
    local self = ParkBrakeEvent:emptyNew()
    self.vehicle = vehicle;
	self.ParkBrake = ParkBrake;
    return self;
end;

function ParkBrakeEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.ParkBrake = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function ParkBrakeEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteBool(streamId, self.ParkBrake);
end;

function ParkBrakeEvent:run(connection)
	if self.vehicle ~= nil then
		if not connection:getIsServer() then
			g_server:broadcastEvent(ParkBrakeEvent:new(self.vehicle, self.ParkBrake), nil, connection, self.vehicle);
		end;
		if self.vehicle.setParkBrakeState ~= nil then
			self.vehicle:setParkBrakeState(self.ParkBrake, true);
		end;
	end;
end;
function ParkBrakeEvent.sendEvent(vehicle, ParkBrake, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(ParkBrakeEvent:new(vehicle, ParkBrake), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(ParkBrakeEvent:new(vehicle, ParkBrake));
		end;
	end;
end;

