--
--
-- @author  Ago-Systemtech
-- @date  20/09/2012
-- Copyright (C) Ago-Systemtech, All Rights Reserved.

bremsemp = {};
function bremsemp.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;
function bremsemp:load(xmlFile)
	
	---------------------HANDBRAKE---------------------
	self.handbrakelight = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.handbrakelight#index"));
	self.setHandBrakeState = SpecializationUtil.callSpecializationsFunction("setHandBrakeState");
	self.handBrakeHud = Overlay:new("HandbrakeOverlay", Utils.getFilename("Textures/handbrake.dds", self.baseDirectory), 0.860, 0.254, 0.1726, 0.039525); -- 0.080, 0.085
	self.handbrake = true;
	handbrakeSoundFile = Utils.getFilename("sounds/handbrake.wav", self.baseDirectory);
    self.handbrakeSoundId = createSample("handbrakeSound");
    loadSample(self.handbrakeSoundId, handbrakeSoundFile, false);
    self.handbrakePlaying = false;
	brakeSoundFile = Utils.getFilename("sounds/compressedAir.ogg", self.baseDirectory);
    self.brakeSoundId = createSample("brakeSound");
    loadSample(self.brakeSoundId, brakeSoundFile, false);
    self.brakePlaying = false;
	brakereleaseSoundFile = Utils.getFilename("sounds/brakeOld.wav", self.baseDirectory);
    self.brakereleaseSoundId = createSample("brakereleaseSound");
    loadSample(self.brakereleaseSoundId, brakereleaseSoundFile, false);
	self.brakereleasePlaying = false;
    self.BreakForceVal = 10000/self.motor.brakeForce;
    self.HandBrakeTurnOff = false;
	
	
end;
function bremsemp:delete()
  
end;

function bremsemp:mouseEvent(posX, posY, isDown, isUp, button)
end;
function bremsemp:keyEvent(unicode, sym, modifier, isDown)
	-------------------------HANDBRAKE---------------------------
   if isDown and sym == Input.KEY_space then
        self:setHandBrakeState(not self.handbrake);
		if self.handbrake and self:getIsActiveForSound() then
			playSample(self.handbrakeSoundId,1,1,0);
		end;
	end;
end;

function bremsemp:update(dt)
	
	 ----------------------HANDBRAKE--------------------
		if self:getIsActive() then
		if Input.isKeyPressed(Input.KEY_s) then
				if not self.braking then
					self.braking = true;
				end;
				if not self.brakePlaying and self:getIsActiveForSound() then
					playSample(self.brakeSoundId,1,1,0);
					self.brakePlaying = true;
				end;
				self.brakereleasePlaying = false;
		else
			self.brakePlaying = false;
			self.braking = false;
			if not self.brakereleasePlaying and self:getIsActiveForSound() then
				playSample(self.brakereleaseSoundId,1,1,0);
				self.brakereleasePlaying = true;
			end;
		end;
	end;
	
end;

function bremsemp:updateTick(dt)
   
	
	-------------------HANDBRAKE-----------------
	 	if self.isServer then
        if self.handbrake then
            if self.isServer then
                for k,wheel in pairs(self.wheels) do
                    setWheelShapeProps(wheel.node, wheel.wheelShape, 0, 999, 0);
                end;
            end;
        elseif not self.handbrake and self.HandBrakeTurnOff then
            if self.isServer then
                for k,wheel in pairs(self.wheels) do
                    setWheelShapeProps(wheel.node, wheel.wheelShape, 0, 0, 0);
                end;
            end;
            self.HandBrakeTurnOff = false;
        end;
    end;
end;
function bremsemp:setHandBrakeState(state, noEventSend)
HandbrakeEvent.sendEvent(self, state, noEventSend); -- MP Fix by modelleicher, addet Event
    self.handbrake = state;
    self.HandBrakeTurnOff = state;
    setVisibility(self.handbrakelight, state);
end;

function bremsemp:draw()
	
	if self.isEntered then
		if self.handbrake then
			if Input.isKeyPressed(Input.KEY_w) then
				self.handBrakeHud:render();
			end;
		self.handBrakeHud:render();
		end;
	end;
	if self.isEntered then
		if self.handbrake then
			if Input.isKeyPressed(Input.KEY_w) then
				g_currentMission:addWarning(g_i18n:getText("handbrakeRELEASE"), 0.015, 0.030);
			end;
		end;
	end;
	if self.isEntered then
		if self.handbrake then
			if Input.isKeyPressed(Input.KEY_s) then
				g_currentMission:addWarning(g_i18n:getText("handbrakeRELEASE"), 0.015, 0.030);
			end;
		end;
	end;
	
end;



-- HANDBRAKE EVENT --
-- MP Fix by modelleicher
HandbrakeEvent = {};
HandbrakeEvent_mt = Class(HandbrakeEvent, Event);

InitEventClass(HandbrakeEvent, "HandbrakeEvent");

function HandbrakeEvent:emptyNew()
    local self = Event:new(HandbrakeEvent_mt);
    self.className = "HandbrakeEvent";
    return self;
end;

function HandbrakeEvent:new(object, state)
    local self = HandbrakeEvent:emptyNew()
    self.object = object;
	self.state = state;
    return self;
end;

function HandbrakeEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.state = streamReadBool(streamId);
    self.object = networkGetObject(id);
    self:run(connection);
end;

function HandbrakeEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteBool(streamId, self.state);
end;

function HandbrakeEvent:run(connection)
    self.object:setHandBrakeState(self.state, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(HandbrakeEvent:new(self.object, self.state), nil, connection, self.object);
    end;
end;

function HandbrakeEvent.sendEvent(vehicle, state, noEventSend)
    if state ~= vehicle.handbrake then
        if noEventSend == nil or noEventSend == false then
            if g_server ~= nil then
                g_server:broadcastEvent(HandbrakeEvent:new(vehicle, state), nil, nil, vehicle);
            else
                g_client:getServerConnection():sendEvent(HandbrakeEvent:new(vehicle, state));
            end;
        end;
    end;
end;