-- v1.0: date 22.06.2016
-- by werik

indoorSound = {};

function indoorSound.prerequisitesPresent(specializations)
--	print("......LOADING INDOOR SOUND SCRIPT BY WERIK......");
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function indoorSound:load(xmlFile)

	self.indoorSound = {};
	self.indoorSound.factor = Utils.getNoNil(self.indoorSound.factor,0.45);
end;

function indoorSound:delete()
end;

function indoorSound:mouseEvent(posX, posY, isDown, isUp, button)
end;

function indoorSound:keyEvent(unicode, sym, modifier, isDown)
end;

function indoorSound:update(dt)

	if self.isEntered then
		if g_currentMission.driveControl ~= nil and g_currentMission.driveControl.useModules.inDoorSound then
			g_currentMission.driveControl.useModules.inDoorSound = false;
		end;

	if self.isEntered then		
		if self:getIsActiveForSound() then
			if self.sampleMotor ~= nil then
				local isIndoor = false;
				for _,camera in pairs(self.cameras) do
					if camera.isInside and camera.isActivated then
						isIndoor = true;
						break;
					end;
				end;
				local samples = {self.sampleMotor, self.sampleMotorStart, self.sampleMotorStop};
				for _,sample in pairs(samples) do
					if sample ~= nil then --and sample.isPlaying then
						--local volume = getSampleVolume(sample.sample)
						-- print(volume)
						local targetVolume = sample.volume;
						if isIndoor then
							targetVolume = self.indoorSound.factor*targetVolume;
						end;
						if sample.sample~= nil then --or volume ~= targetVolume then
							setSampleVolume(sample.sample,targetVolume)
						end;					
					end;	
				end;
			end;
		end;
	 end;
	else
		if g_currentMission.driveControl ~= nil and not g_currentMission.driveControl.useModules.inDoorSound then
			g_currentMission.driveControl.useModules.inDoorSound = true;
		end;
	end;
end;

function indoorSound:updateTick(dt)
end;

function indoorSound:draw()	
end;
