--
-- BJR_BaleTrakPanel
--
-- @author  JoXXer
-- @date  	17/11/13
--
-- @history	v1.0 - Initial implementation
--
--

BJR_BaleTrakPanel = {};

function BJR_BaleTrakPanel.prerequisitesPresent(specializations)
    return true;
end;

function BJR_BaleTrakPanel:load(xmlFile)
	self.turnOffBaleTrak = SpecializationUtil.callSpecializationsFunction("turnOffBaleTrak");
	self.setTimerDone = SpecializationUtil.callSpecializationsFunction("setTimerDone");
	
	-- Monitor
	self.detachPosition = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.baleTrakPanel#detachPosition"));
	self.controlPanel = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.baleTrakPanel#index"));
	
	-- Icons
	self.baleTrakIcons = {};

	self.baleTrakIcons.balerClosed = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.baleTrakIcons.balerClosed#index"));
	self.baleTrakIcons.tinyNet = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.baleTrakIcons.tinyNet#index"));
	self.baleTrakIcons.ropes = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.baleTrakIcons.ropes#index"));
	self.baleTrakIcons.nettingLeft = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.baleTrakIcons.nettingLeft#index"));
	self.baleTrakIcons.balerEject = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.baleTrakIcons.balerEject#index"));
	self.baleTrakIcons.knives = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.baleTrakIcons.knives#index"));
	self.baleTrakIcons.stop = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.baleTrakIcons.stop#index"));
	self.baleTrakIcons.balerClosing = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.baleTrakIcons.balerClosing#index"));
	self.baleTrakIcons.bigNet = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.baleTrakIcons.bigNet#index"));
	self.baleTrakIcons.nettingRight = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.baleTrakIcons.nettingRight#index"));
	self.baleTrakIcons.battery = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.baleTrakIcons.battery#index"));
	
	self.baleTrakIcons.fillLevelLeft = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.baleTrakIcons.fillLevelLeft#index"));
	self.baleTrakIcons.fillLevelRight = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.baleTrakIcons.fillLevelRight#index"));
	
	
	-- Digits
	self.baleTrakFirstDigits = {};
	local i = 0;
	while true do
		local key = string.format("vehicle.baleTrakFirstDigits.baleTrakFirstDigit(%d)", i);
		if not hasXMLProperty(xmlFile, key) then
			break;
		end;
		local baleTrakFirstDigit = Utils.indexToObject(self.components, getXMLString(xmlFile, key.."#index"));
		if baleTrakFirstDigit ~= nil then
			table.insert(self.baleTrakFirstDigits, baleTrakFirstDigit);
		end;
		i = i + 1;
	end;
	
	self.baleTrakSecondDigits = {};
	local i = 0;
	while true do
		local key = string.format("vehicle.baleTrakSecondDigits.baleTrakSecondDigit(%d)", i);
		if not hasXMLProperty(xmlFile, key) then
			break;
		end;
		local baleTrakSecondDigit = Utils.indexToObject(self.components, getXMLString(xmlFile, key.."#index"));
		if baleTrakSecondDigit ~= nil then
			table.insert(self.baleTrakSecondDigits, baleTrakSecondDigit);
		end;
		i = i + 1;
	end;
	
	self.baleTrakThirdDigits = {};
	local i = 0;
	while true do
		local key = string.format("vehicle.baleTrakThirdDigits.baleTrakThirdDigit(%d)", i);
		if not hasXMLProperty(xmlFile, key) then
			break;
		end;
		local baleTrakThirdDigit = Utils.indexToObject(self.components, getXMLString(xmlFile, key.."#index"));
		if baleTrakThirdDigit ~= nil then
			table.insert(self.baleTrakThirdDigits, baleTrakThirdDigit);
		end;
		i = i + 1;
	end;
	
	self.baleTrakFourthDigits = {};
	local i = 0;
	while true do
		local key = string.format("vehicle.baleTrakFourthDigits.baleTrakFourthDigit(%d)", i);
		if not hasXMLProperty(xmlFile, key) then
			break;
		end;
		local baleTrakFourthDigit = Utils.indexToObject(self.components, getXMLString(xmlFile, key.."#index"));
		if baleTrakFourthDigit ~= nil then
			table.insert(self.baleTrakFourthDigits, baleTrakFourthDigit);
		end;
		i = i + 1;
	end;
	
	self.baleTrakFifthDigits = {};
	local i = 0;
	while true do
		local key = string.format("vehicle.baleTrakFifthDigits.baleTrakFifthDigit(%d)", i);
		if not hasXMLProperty(xmlFile, key) then
			break;
		end;
		local baleTrakFifthDigit = Utils.indexToObject(self.components, getXMLString(xmlFile, key.."#index"));
		if baleTrakFifthDigit ~= nil then
			table.insert(self.baleTrakFifthDigits, baleTrakFifthDigit);
		end;
		i = i + 1;
	end;
	
	-- They're coming, hide everything! 
	self:turnOffBaleTrak(false);
	
    self.panelSound = createSample("panelSample");
    loadSample(self.panelSound, Utils.getFilename("sounds/peeptone.wav", self.baseDirectory), false);

	BJR_BaleTrakPanel.attacherVehicleCopy = nil;
	
	self.lastBaleCountValue = 0;
	self.defaultCapacityScale = 1 / self.capacity;
	
	self.startUpSequenceDone = false;
	self.startUpTimer = nil;
end;

function BJR_BaleTrakPanel:updateTick(dt)

	if self.isClient and self:getIsActive() and getVisibility(self.controlPanel) then
	
		if BJR_BaleTrakPanel.attacherVehicleCopy ~= nil and BJR_BaleTrakPanel.attacherVehicleCopy.isMotorStarted then
		
			if self.startUpSequenceDone then
				-- Update baleCount
				if self.totalBalesCount > self.lastBaleCountValue then
					local spareCountValue = self.totalBalesCount;
					
					-- Fifth digit
					local tenThousands = math.floor(self.totalBalesCount / 10000);
					local hasTenThousands = false;
					if tenThousands > 0 then
						for _, digit in pairs(self.baleTrakFifthDigits) do
							setVisibility(digit, false);
						end;
						setVisibility(self.baleTrakFifthDigits[tenThousands+1], true);
						
						spareCountValue = self.totalBalesCount - (tenThousands * 10000);
						hasTenThousands = true;
					else
						for _, digit in pairs(self.baleTrakFifthDigits) do
							setVisibility(digit, false);
						end;
					end;
					
					-- Fourth digit
					local thousands = math.floor(spareCountValue / 1000);
					local hasThousands = false;
					if thousands > 0 or hasTenThousands then
						for _, digit in pairs(self.baleTrakFourthDigits) do
							setVisibility(digit, false);
						end;
						setVisibility(self.baleTrakFourthDigits[thousands+1], true);
						
						spareCountValue = spareCountValue - (thousands * 1000);
						hasThousands = true;
					else
						for _, digit in pairs(self.baleTrakFourthDigits) do
							setVisibility(digit, false);
						end;
					end;
					
					-- Third digit
					local hundreds = math.floor(spareCountValue / 100);
					local hasHundreds = false;
					if hundreds > 0 or hasThousands then
						for _, digit in pairs(self.baleTrakThirdDigits) do
							setVisibility(digit, false);
						end;
						setVisibility(self.baleTrakThirdDigits[hundreds+1], true);
						
						spareCountValue = spareCountValue - (hundreds * 100);
						hasHundreds = true;
					else
						for _, digit in pairs(self.baleTrakThirdDigits) do
							setVisibility(digit, false);
						end;
					end;
					
					-- Second digit
					local tens = math.floor(spareCountValue / 10);
					if tens > 0 or hasHundreds then
						for _, digit in pairs(self.baleTrakSecondDigits) do
							setVisibility(digit, false);
						end;
						setVisibility(self.baleTrakSecondDigits[tens+1], true);
						
						spareCountValue = spareCountValue - (tens * 10);
					else
						for _, digit in pairs(self.baleTrakSecondDigits) do
							setVisibility(digit, false);
						end;
					end;
					
					-- First digit
					local ones = spareCountValue;
					if ones >= 0 then
						for _, digit in pairs(self.baleTrakFirstDigits) do
							setVisibility(digit, false);
						end;
						setVisibility(self.baleTrakFirstDigits[ones+1], true);
					else
						for _, digit in pairs(self.baleTrakFirstDigits) do
							setVisibility(digit, false);
						end;
					end;
				end;
				
				if self.balerUnloadingState == VariableChamberBaler.UNLOADING_OPENING or self.balerUnloadingState == VariableChamberBaler.UNLOADING_OPEN then
					setVisibility(self.baleTrakIcons.balerClosed, false);
					setVisibility(self.baleTrakIcons.balerClosing, true);
					setVisibility(self.baleTrakIcons.balerEject, true);
				end;
				
				if self.balerUnloadingState == VariableChamberBaler.UNLOADING_CLOSING then
					setVisibility(self.baleTrakIcons.balerClosed, false);
					setVisibility(self.baleTrakIcons.balerClosing, true);
					setVisibility(self.baleTrakIcons.balerEject, false);
				end;
				
				if self.balerUnloadingState == VariableChamberBaler.UNLOADING_CLOSED then
					if getVisibility(self.baleTrakIcons.balerClosed) == false then
						if self:getIsActiveForSound() then
							playSample(self.panelSound, 1, 0.5,0);
						end;
						setVisibility(self.baleTrakIcons.balerClosed, true);
						setVisibility(self.baleTrakIcons.balerClosing, false);
						setVisibility(self.baleTrakIcons.balerEject, false);
					end;
				end;
				
				if self.actLoad_Send ~= nil then
					setScale(self.baleTrakIcons.fillLevelLeft, 1, self.actLoad_Send, 1);
					setScale(self.baleTrakIcons.fillLevelRight, 1, self.actLoad_Send, 1);
				else
					setScale(self.baleTrakIcons.fillLevelLeft, 1, self.fillLevel * self.defaultCapacityScale, 1);
					setScale(self.baleTrakIcons.fillLevelRight, 1, self.capacity * self.defaultCapacityScale, 1);
				end;
				
				if getVisibility(self.baleTrakIcons.nettingLeft) == false then
					setVisibility(self.baleTrakIcons.nettingLeft, true);
				end;
		
				if self.isNetting then
					if getVisibility(self.baleTrakIcons.nettingRight) == false then
						if self:getIsActiveForSound() then
							playSample(self.panelSound, 1, 0.5,0);
						end;
						setVisibility(self.baleTrakIcons.nettingRight, true);
						setVisibility(self.baleTrakIcons.tinyNet, true);
					end;
				else
					setVisibility(self.baleTrakIcons.nettingRight, false);
					setVisibility(self.baleTrakIcons.tinyNet, false);
				end;
				
				if self.fillLevel >= self.capacity or self.isBlocked then
					setVisibility(self.baleTrakIcons.stop, true);
				else
					setVisibility(self.baleTrakIcons.stop, false);
				end;
				
				setVisibility(self.baleTrakIcons.knives, true);
				
				self.lastBaleCountValue = self.totalBalesCount;
			elseif self.startUpTimer == nil then
				self.startUpTimer = addTimer(4000, "setTimerDone", self);
				if self:getIsActiveForSound() then
					playSample(self.panelSound, 1, 0.5,0);
				end;
				self:turnOffBaleTrak(true);
			end;
		else
			self:turnOffBaleTrak(false);
		end;
	end;
end;

function BJR_BaleTrakPanel:draw()
end;

function BJR_BaleTrakPanel:setTimerDone()
	if self:getIsActiveForSound() then
		playSample(self.panelSound, 1, 0.5,0);
	end;
	self:turnOffBaleTrak(false);
	self.startUpSequenceDone = true;
	self.startUpTimer = nil;
end;

function BJR_BaleTrakPanel:turnOffBaleTrak(state)
	
	setVisibility(self.baleTrakIcons.balerClosed, state);
	setVisibility(self.baleTrakIcons.tinyNet, state);
	setVisibility(self.baleTrakIcons.ropes, state);
	setVisibility(self.baleTrakIcons.nettingLeft, state);
	setVisibility(self.baleTrakIcons.balerEject, state);
	setVisibility(self.baleTrakIcons.knives, state);
	setVisibility(self.baleTrakIcons.stop, state);
	setVisibility(self.baleTrakIcons.balerClosing, state);
	setVisibility(self.baleTrakIcons.bigNet, state);
	setVisibility(self.baleTrakIcons.nettingRight, state);
	setVisibility(self.baleTrakIcons.battery, state);
	
	for _, digit in pairs(self.baleTrakFirstDigits) do
		setVisibility(digit, state);
	end;
	for _, digit in pairs(self.baleTrakSecondDigits) do
		setVisibility(digit, state);
	end;
	for _, digit in pairs(self.baleTrakThirdDigits) do
		setVisibility(digit, state);
	end;
	for _, digit in pairs(self.baleTrakFourthDigits) do
		setVisibility(digit, state);
	end;
	for _, digit in pairs(self.baleTrakFifthDigits) do
		setVisibility(digit, state);
	end;
	
	if state == false then
		self.lastBaleCountValue = 0;
		self.startUpSequenceDone = false;
		setScale(self.baleTrakIcons.fillLevelLeft, 1, 0, 1);
		setScale(self.baleTrakIcons.fillLevelRight, 1, 0, 1);
	else
		setScale(self.baleTrakIcons.fillLevelLeft, 1, 1, 1);
		setScale(self.baleTrakIcons.fillLevelRight, 1, 1, 1);
	end;
end;

function BJR_BaleTrakPanel:onAttach(attacherVehicle)
	BJR_BaleTrakPanel.attacherVehicleCopy = attacherVehicle;
	if attacherVehicle.addControlPanel ~= nil then
		local wasSuccessful = attacherVehicle:addControlPanel(self);
	else
		setVisibility(self.controlPanel, false);
	end;
end;

function BJR_BaleTrakPanel:onDetach()
	if BJR_BaleTrakPanel.attacherVehicleCopy.removeControlPanel ~= nil then
		local wasSuccessful = BJR_BaleTrakPanel.attacherVehicleCopy:removeControlPanel(self);
	else
		setVisibility(self.controlPanel, true);
	end;

	self:turnOffBaleTrak(false);
	BJR_BaleTrakPanel.attacherVehicleCopy = nil;
end;

