SetPickupEvent = {};
SetPickupEvent_mt = Class(SetPickupEvent, Event);

InitEventClass(SetPickupEvent, "SetPickupEvent");

function SetPickupEvent:emptyNew()
	local self = Event:new(SetPickupEvent_mt);
	self.className="SetPickupEvent";
	return self;
end;

function SetPickupEvent:new(vehicle, isPickupState)
	local self = SetPickupEvent:emptyNew()
	self.vehicle = vehicle;
	self.isPickupState = isPickupState;
	return self;
end;

function SetPickupEvent:readStream(streamId, connection)
	local id = streamReadInt32(streamId);
	self.isPickupState = streamReadBool(streamId);
	self.vehicle = networkGetObject(id);
	self:run(connection);
end;

function SetPickupEvent:writeStream(streamId, connection)
	streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteBool(streamId, self.isPickupState);
end;

function SetPickupEvent:run(connection)   
	self.vehicle:setPickup(self.isPickupState, true);
	if not connection:getIsServer() then
		g_server:broadcastEvent(SetPickupEvent:new(self.vehicle, self.isPickupState), nil, connection, self.vehicle);
	end;
end;

function SetPickupEvent.sendEvent(vehicle, isPickupState, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(SetPickupEvent:new(vehicle, isPickupState), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(SetPickupEvent:new(vehicle, isPickupState));
		end;
	end;
end;